/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui;

import io.fair_acc.bench.BenchLevel;
import io.fair_acc.bench.DurationMeasure;
import io.fair_acc.bench.Measurable;
import io.fair_acc.bench.MeasurementRecorder;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.bench.MeasurementRecorders;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import us.hebi.gui.Scope;
import us.hebi.gui.e;
import us.hebi.gui.lib.amg;
import us.hebi.gui.lib.amm;
import us.hebi.gui.lib.amv;
import us.hebi.gui.lib.amx;
import us.hebi.gui.lib.anu;
import us.hebi.gui.lib.atd;
import us.hebi.gui.lib.ate;
import us.hebi.gui.lib.aug;
import us.hebi.gui.lib.auh;
import us.hebi.gui.lib.aum;
import us.hebi.gui.lib.awd;
import us.hebi.gui.lib.azj;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.b;
import us.hebi.gui.lib.bag;
import us.hebi.gui.lib.bah;
import us.hebi.gui.lib.bal;
import us.hebi.gui.lib.bap;
import us.hebi.gui.lib.baq;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.bzd;
import us.hebi.gui.lib.fc;
import us.hebi.gui.lib.h;
import us.hebi.gui.lib.io;
import us.hebi.gui.views.scope.ScopePresenter;
import us.hebi.gui.views.scope.ScopeView;

public class ScopeApp
extends Application {
    private static String[] ipAddresses = null;
    private static final MeasurementRecorder d = MeasurementRecorder.printRecorder().maxLevel(BenchLevel.Debug);
    private static final DurationMeasure e = d.newDuration("Scope initialization");

    public void start(Stage stage) throws Exception {
        e.start();
        azx.a(this);
        if (Boolean.valueOf(amv.a("hebi.debug", "false")).booleanValue()) {
            System.out.println("[debug] setting uncaught exception handler.");
            Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
                throwable.printStackTrace();
                atd.a(throwable, stage.getOwner());
            });
        }
        if (amv.j("hebi.statistics.scope")) {
            amm.b = MeasurementRecorders.newHdrHistogram("scope_statistics.hlog");
        }
        azx.ca();
        Image image = us.hebi.gui.e.d;
        Text text = new Text("Loading ...");
        text.setFill((Paint)Color.WHITE);
        text.setFont(Font.font((double)30.0));
        StackPane stackPane = new StackPane(new Node[]{new ImageView(image), text});
        Stage stage2 = new Stage(StageStyle.TRANSPARENT);
        stage2.setScene(new Scene((Parent)stackPane, (Paint)us.hebi.gui.b.e));
        stage2.getIcons().add((Object)image);
        CompletableFuture<Void> completableFuture = bah.a(stage2);
        Locale.setDefault(Locale.ENGLISH);
        Logger.getGlobal().setLevel(Level.WARNING);
        b.a(bap.class, bap.a(this));
        b.a(anu.class, anu.a(Scope.class));
        b.a(ExecutorService.class, Executors.newCachedThreadPool(io.a));
        b.a(ate.class, new ate(stage));
        b.b(aum.class);
        b.b(auh.class);
        bag.a("Scope");
        bal.cj();
        CompletableFuture[] completableFutureArray = new CompletableFuture[3];
        ScopeApp scopeApp = this;
        Supplier<Measurable> supplier = aug::new;
        CompletionStage completionStage = CompletableFuture.supplyAsync(() -> ScopeApp.a("Lookup initialization", supplier)).thenApplyAsync(aug2 -> {
            b.a(aug2);
            b.a(aug.class, aug2);
            return aug2;
        }, azx.d);
        ((CompletableFuture)completionStage).thenAcceptAsync(aug2 -> {
            List<InetAddress> list;
            if (ipAddresses == null) {
                System.out.println("Automatically determining broadcast addresses");
                list = bzd.e();
            } else {
                System.out.println("Requesting Info from " + Arrays.toString(ipAddresses));
                list = Arrays.stream(ipAddresses).map(fc::a).toList();
            }
            List<InetAddress> list2 = list;
            aug2.setAddresses(list2);
            if (list2.isEmpty()) {
                amx.b(8L, TimeUnit.SECONDS);
                List<InetAddress> list3 = bzd.e();
                Platform.runLater(() -> aug2.setAddresses(list3));
            }
        });
        completableFutureArray[0] = completionStage;
        supplier = () -> new awd(h.b());
        completableFutureArray[1] = CompletableFuture.supplyAsync(() -> ScopeApp.a("Plotting initialization", supplier)).thenApplyAsync(awd2 -> {
            b.a(awd2);
            b.a(awd.class, awd2);
            return awd2;
        }, azx.d);
        completableFutureArray[2] = completableFuture;
        CompletableFuture.allOf(completableFutureArray).thenRunAsync(() -> {
            Stage stage3 = stage;
            ScopeView scopeView = new ScopeView();
            Supplier<Parent> supplier = scopeView::getView;
            Parent parent = (Parent)((Supplier<Object>)() -> ScopeApp.a("FXML loading", supplier)).get();
            Scene scene = new Scene(parent);
            stage3.setTitle("HEBI Robotics Scope " + azj.a.W);
            stage3.setScene(scene);
            if (amg.au()) {
                List list = azx.a(Path.of(System.getProperty("app.dir"), new String[0]), "icon-*.png").orElseGet(() -> h.a(new Image[]{us.hebi.gui.e.c}));
                stage3.getIcons().setAll((Collection)list);
            }
            ((ScopePresenter)scopeView.getPresenter()).initKeyboardBindings(scene);
            azx.b(stage3);
            stage3.setOnCloseRequest(windowEvent -> Platform.exit());
            baq.c(parent);
            bat.f(parent);
            stage3.getScene().getRoot().mouseTransparentProperty().bind((ObservableValue)stage3.focusedProperty().not());
            e.stop();
            stage2.hide();
            CompletableFuture.supplyAsync(XYChart::new, azx.d);
        }, azx.d);
    }

    public void stop() {
        b.a();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            ipAddresses = stringArray;
        }
        ScopeApp.launch((String[])stringArray);
        if (amv.j("hebi.statistics.scope")) {
            System.exit(0);
        }
    }

    private static /* synthetic */ Object a(String string, Supplier supplier) {
        DurationMeasure durationMeasure = d.newDebugDuration(string);
        durationMeasure.start();
        Object t2 = supplier.get();
        durationMeasure.stop();
        return t2;
    }
}

