/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.publicsuffix;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.internal.Util;
import okhttp3.internal.platform.Platform;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;

public final class PublicSuffixDatabase {
    public static final String PUBLIC_SUFFIX_RESOURCE = "publicsuffixes.gz";
    private static final byte[] WILDCARD_LABEL = new byte[]{42};
    private static final String[] EMPTY_RULE = new String[0];
    private static final String[] PREVAILING_RULE = new String[]{"*"};
    private static final byte EXCEPTION_MARKER = 33;
    private static final PublicSuffixDatabase instance = new PublicSuffixDatabase();
    private final AtomicBoolean listRead = new AtomicBoolean(false);
    private final CountDownLatch readCompleteLatch = new CountDownLatch(1);
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;

    public static PublicSuffixDatabase get() {
        return instance;
    }

    public String getEffectiveTldPlusOne(String string) {
        String[] stringArray;
        if (string == null) {
            throw new NullPointerException("domain == null");
        }
        String string2 = IDN.toUnicode(string);
        String[] stringArray2 = string2.split("\\.");
        if (stringArray2.length == (stringArray = this.findMatchingRule(stringArray2)).length && stringArray[0].charAt(0) != '!') {
            return null;
        }
        int n2 = stringArray[0].charAt(0) == '!' ? stringArray2.length - stringArray.length : stringArray2.length - (stringArray.length + 1);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray3 = string.split("\\.");
        for (int i2 = n2; i2 < stringArray3.length; ++i2) {
            stringBuilder.append(stringArray3[i2]).append('.');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] findMatchingRule(String[] stringArray) {
        Object object;
        int n2;
        Object object2;
        if (!this.listRead.get() && this.listRead.compareAndSet(false, true)) {
            this.readTheListUninterruptibly();
        } else {
            try {
                this.readCompleteLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Object object3 = this;
        synchronized (object3) {
            if (this.publicSuffixListBytes == null) {
                throw new IllegalStateException("Unable to load publicsuffixes.gz resource from the classpath.");
            }
        }
        object3 = new byte[stringArray.length][];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            object3[i2] = stringArray[i2].getBytes(Util.UTF_8);
        }
        String string = null;
        for (int i3 = 0; i3 < ((Object)object3).length; ++i3) {
            object2 = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixListBytes, (byte[][])object3, i3);
            if (object2 == null) continue;
            string = object2;
            break;
        }
        Object object4 = null;
        if (((Object)object3).length > 1) {
            object2 = (byte[][])object3.clone();
            for (n2 = 0; n2 < ((Object)object2).length - 1; ++n2) {
                object2[n2] = WILDCARD_LABEL;
                object = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixListBytes, (byte[][])object2, n2);
                if (object == null) continue;
                object4 = object;
                break;
            }
        }
        object2 = null;
        if (object4 != null) {
            for (n2 = 0; n2 < ((Object)object3).length - 1; ++n2) {
                object = PublicSuffixDatabase.binarySearchBytes(this.publicSuffixExceptionListBytes, (byte[][])object3, n2);
                if (object == null) continue;
                object2 = object;
                break;
            }
        }
        if (object2 != null) {
            object2 = "!" + (String)object2;
            return object2.split("\\.");
        }
        if (string == null && object4 == null) {
            return PREVAILING_RULE;
        }
        String[] stringArray2 = string != null ? string.split("\\.") : EMPTY_RULE;
        object = object4 != null ? object4.split("\\.") : EMPTY_RULE;
        return stringArray2.length > ((String[])object).length ? stringArray2 : object;
    }

    private static String binarySearchBytes(byte[] byArray, byte[][] byArray2, int n2) {
        int n3 = 0;
        int n4 = byArray.length;
        String string = null;
        while (n3 < n4) {
            int n5;
            int n6;
            int n7;
            int n8;
            for (n8 = (n3 + n4) / 2; n8 > -1 && byArray[n8] != 10; --n8) {
            }
            ++n8;
            int n9 = 1;
            while (byArray[n8 + n9] != 10) {
                ++n9;
            }
            int n10 = n8 + n9 - n8;
            int n11 = n2;
            int n12 = 0;
            int n13 = 0;
            boolean bl2 = false;
            while (true) {
                if (bl2) {
                    n7 = 46;
                    bl2 = false;
                } else {
                    n7 = byArray2[n11][n12] & 0xFF;
                }
                n6 = byArray[n8 + n13] & 0xFF;
                n5 = n7 - n6;
                if (n5 != 0) break;
                ++n12;
                if (++n13 == n10) break;
                if (byArray2[n11].length != n12) continue;
                if (n11 == byArray2.length - 1) break;
                ++n11;
                n12 = -1;
                bl2 = true;
            }
            if (n5 < 0) {
                n4 = n8 - 1;
                continue;
            }
            if (n5 > 0) {
                n3 = n8 + n9 + 1;
                continue;
            }
            n7 = n10 - n13;
            n6 = byArray2[n11].length - n12;
            for (int i2 = n11 + 1; i2 < byArray2.length; ++i2) {
                n6 += byArray2[i2].length;
            }
            if (n6 < n7) {
                n4 = n8 - 1;
                continue;
            }
            if (n6 > n7) {
                n3 = n8 + n9 + 1;
                continue;
            }
            string = new String(byArray, n8, n10, Util.UTF_8);
            break;
        }
        return string;
    }

    private void readTheListUninterruptibly() {
        boolean bl2 = false;
        while (true) {
            try {
                this.readTheList();
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                bl2 = true;
                continue;
            }
            catch (IOException iOException) {
                Platform.get().log(5, "Failed to read public suffix list", iOException);
                return;
            }
            break;
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTheList() throws IOException {
        byte[] byArray;
        byte[] byArray2;
        InputStream inputStream = PublicSuffixDatabase.class.getResourceAsStream(PUBLIC_SUFFIX_RESOURCE);
        if (inputStream == null) {
            return;
        }
        BufferedSource bufferedSource = Okio.buffer(new GzipSource(Okio.source(inputStream)));
        try {
            int n2 = bufferedSource.readInt();
            byArray2 = new byte[n2];
            bufferedSource.readFully(byArray2);
            int n3 = bufferedSource.readInt();
            byArray = new byte[n3];
            bufferedSource.readFully(byArray);
        }
        finally {
            Util.closeQuietly(bufferedSource);
        }
        PublicSuffixDatabase publicSuffixDatabase = this;
        synchronized (publicSuffixDatabase) {
            this.publicSuffixListBytes = byArray2;
            this.publicSuffixExceptionListBytes = byArray;
        }
        this.readCompleteLatch.countDown();
    }

    void setListBytes(byte[] byArray, byte[] byArray2) {
        this.publicSuffixListBytes = byArray;
        this.publicSuffixExceptionListBytes = byArray2;
        this.listRead.set(true);
        this.readCompleteLatch.countDown();
    }
}

