/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import okhttp3.internal.Util;
import okio.ByteString;

public final class Http2 {
    static final ByteString CONNECTION_PREFACE = ByteString.encodeUtf8("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
    static final int INITIAL_MAX_FRAME_SIZE = 16384;
    static final byte TYPE_DATA = 0;
    static final byte TYPE_HEADERS = 1;
    static final byte TYPE_PRIORITY = 2;
    static final byte TYPE_RST_STREAM = 3;
    static final byte TYPE_SETTINGS = 4;
    static final byte TYPE_PUSH_PROMISE = 5;
    static final byte TYPE_PING = 6;
    static final byte TYPE_GOAWAY = 7;
    static final byte TYPE_WINDOW_UPDATE = 8;
    static final byte TYPE_CONTINUATION = 9;
    static final byte FLAG_NONE = 0;
    static final byte FLAG_ACK = 1;
    static final byte FLAG_END_STREAM = 1;
    static final byte FLAG_END_HEADERS = 4;
    static final byte FLAG_END_PUSH_PROMISE = 4;
    static final byte FLAG_PADDED = 8;
    static final byte FLAG_PRIORITY = 32;
    static final byte FLAG_COMPRESSED = 32;
    private static final String[] FRAME_NAMES = new String[]{"DATA", "HEADERS", "PRIORITY", "RST_STREAM", "SETTINGS", "PUSH_PROMISE", "PING", "GOAWAY", "WINDOW_UPDATE", "CONTINUATION"};
    static final String[] FLAGS = new String[64];
    static final String[] BINARY = new String[256];

    private Http2() {
    }

    static IllegalArgumentException illegalArgument(String string, Object ... objectArray) {
        throw new IllegalArgumentException(Util.format(string, objectArray));
    }

    static IOException ioException(String string, Object ... objectArray) throws IOException {
        throw new IOException(Util.format(string, objectArray));
    }

    static String frameLog(boolean bl2, int n2, int n3, byte by2, byte by3) {
        String string = by2 < FRAME_NAMES.length ? FRAME_NAMES[by2] : Util.format("0x%02x", by2);
        String string2 = Http2.formatFlags(by2, by3);
        return Util.format("%s 0x%08x %5d %-13s %s", bl2 ? "<<" : ">>", n2, n3, string, string2);
    }

    static String formatFlags(byte by2, byte by3) {
        String string;
        if (by3 == 0) {
            return "";
        }
        switch (by2) {
            case 4: 
            case 6: {
                return by3 == 1 ? "ACK" : BINARY[by3];
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return BINARY[by3];
            }
        }
        String string2 = string = by3 < FLAGS.length ? FLAGS[by3] : BINARY[by3];
        if (by2 == 5 && (by3 & 4) != 0) {
            return string.replace("HEADERS", "PUSH_PROMISE");
        }
        if (by2 == 0 && (by3 & 0x20) != 0) {
            return string.replace("PRIORITY", "COMPRESSED");
        }
        return string;
    }

    static {
        for (int i2 = 0; i2 < BINARY.length; ++i2) {
            Http2.BINARY[i2] = Util.format("%8s", Integer.toBinaryString(i2)).replace(' ', '0');
        }
        Http2.FLAGS[0] = "";
        Http2.FLAGS[1] = "END_STREAM";
        int[] nArray = new int[]{1};
        Http2.FLAGS[8] = "PADDED";
        int[] nArray2 = nArray;
        int n2 = nArray2.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            int n3 = nArray2[i3];
            Http2.FLAGS[n3 | 8] = FLAGS[n3] + "|PADDED";
        }
        Http2.FLAGS[4] = "END_HEADERS";
        Http2.FLAGS[32] = "PRIORITY";
        Http2.FLAGS[36] = "END_HEADERS|PRIORITY";
        for (int n4 : nArray2 = new int[]{4, 32, 36}) {
            for (int n5 : nArray) {
                Http2.FLAGS[n5 | n4] = FLAGS[n5] + '|' + FLAGS[n4];
                Http2.FLAGS[n5 | n4 | 8] = FLAGS[n5] + '|' + FLAGS[n4] + "|PADDED";
            }
        }
        for (int i4 = 0; i4 < FLAGS.length; ++i4) {
            if (FLAGS[i4] != null) continue;
            Http2.FLAGS[i4] = BINARY[i4];
        }
    }
}

