/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.net.CookieHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.internal.Util;
import okhttp3.internal.annotations.EverythingIsNonNull;
import okhttp3.internal.platform.Platform;

@EverythingIsNonNull
public final class JavaNetCookieJar
implements CookieJar {
    private final CookieHandler cookieHandler;

    public JavaNetCookieJar(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    @Override
    public void saveFromResponse(HttpUrl httpUrl, List<Cookie> list) {
        if (this.cookieHandler != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Cookie cookie : list) {
                arrayList.add(cookie.toString(true));
            }
            Map map = Collections.singletonMap("Set-Cookie", arrayList);
            try {
                this.cookieHandler.put(httpUrl.uri(), map);
            }
            catch (IOException iOException) {
                Platform.get().log(5, "Saving cookies failed for " + httpUrl.resolve("/..."), iOException);
            }
        }
    }

    @Override
    public List<Cookie> loadForRequest(HttpUrl httpUrl) {
        Map<String, List<String>> map;
        Map<String, List<String>> map2 = Collections.emptyMap();
        try {
            map = this.cookieHandler.get(httpUrl.uri(), map2);
        }
        catch (IOException iOException) {
            Platform.get().log(5, "Loading cookies failed for " + httpUrl.resolve("/..."), iOException);
            return Collections.emptyList();
        }
        ArrayList<Cookie> arrayList = null;
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            if (!"Cookie".equalsIgnoreCase(string) && !"Cookie2".equalsIgnoreCase(string) || entry.getValue().isEmpty()) continue;
            for (String string2 : entry.getValue()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Cookie>();
                }
                arrayList.addAll(this.decodeHeaderAsJavaNetCookies(httpUrl, string2));
            }
        }
        return arrayList != null ? Collections.unmodifiableList(arrayList) : Collections.emptyList();
    }

    private List<Cookie> decodeHeaderAsJavaNetCookies(HttpUrl httpUrl, String string) {
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>();
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4 = Util.delimiterOffset(string, n2, n3, ";,");
            int n5 = Util.delimiterOffset(string, n2, n4, '=');
            String string2 = Util.trimSubstring(string, n2, n5);
            if (!string2.startsWith("$")) {
                String string3;
                String string4 = string3 = n5 < n4 ? Util.trimSubstring(string, n5 + 1, n4) : "";
                if (string3.startsWith("\"") && string3.endsWith("\"")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                arrayList.add(new Cookie.Builder().name(string2).value(string3).domain(httpUrl.host()).build());
            }
            n2 = n4 + 1;
        }
        return arrayList;
    }
}

