/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.storage;

import io.fair_acc.math.storage.VoxelArrayND;
import java.util.Arrays;

public class DoubleStorage1D
implements VoxelArrayND {
    protected double[] fdata;

    public DoubleStorage1D(double[] dArray) {
        this.setArray(dArray);
    }

    public DoubleStorage1D(DoubleStorage1D doubleStorage1D) {
        this.setArray(doubleStorage1D.fdata);
    }

    @Override
    public VoxelArrayND copy() {
        return new DoubleStorage1D(this.fdata);
    }

    public double get(int n2) {
        return this.fdata[n2];
    }

    @Override
    public double[] get(int[] nArray) {
        return new double[]{this.get(nArray[0])};
    }

    public double[] getArray() {
        return this.fdata;
    }

    @Override
    public int[] getInverseLocalIndex(int n2) {
        return new int[]{n2};
    }

    @Override
    public double[] getLocal(int n2) {
        return new double[]{this.get(n2)};
    }

    @Override
    public int getLocalIndex(int[] nArray) {
        return nArray[0];
    }

    @Override
    public int getLocalStorageDim() {
        return this.fdata.length;
    }

    @Override
    public int getValueDimension() {
        return 1;
    }

    @Override
    public void initialiseWithValue(double d2) {
        Arrays.fill(this.fdata, d2);
    }

    public void set(int n2, double d2) {
        this.fdata[n2] = d2;
    }

    @Override
    public void set(int[] nArray, double[] dArray) {
        this.set(nArray[0], dArray[0]);
    }

    public void setArray(double[] dArray) {
        this.fdata = Arrays.copyOf(dArray, dArray.length);
    }

    @Override
    public void setLocal(int n2, double[] dArray) {
        this.fdata[n2] = dArray[0];
    }
}

