/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.spectra;

import io.fair_acc.math.MathBase;
import io.fair_acc.math.utils.ConcurrencyUtils;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.Arrays;
import org.jtransforms.fft.DoubleFFT_1D;

public class Convolution {
    public DoubleFFT_1D f1dFFT;

    private void init(int n2) {
        if (this.f1dFFT == null) {
            this.f1dFFT = new DoubleFFT_1D((long)n2);
        }
    }

    public void Test() {
        int n2;
        int n3 = 1024;
        boolean bl2 = false;
        double[] dArray = new double[1024];
        double[] dArray2 = new double[1024];
        for (n2 = 0; n2 < 1024; ++n2) {
            dArray[n2] = 100.0 * Math.cos(1.9477874452256718 * (double)n2 + 0.1) + 100.0;
        }
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        n2 = ConcurrencyUtils.nextPow2(3072);
        double[] dArray3 = Convolution.getIdentityFilter(n2);
        dArray = this.transform(dArray, dArray3, false);
        double d2 = 0.0;
        for (int i2 = 0; i2 < 1023; ++i2) {
            double d3 = Math.abs(dArray[i2] - dArray2[i2]);
            d2 = Math.max(d2, d3);
        }
        System.out.printf("reconstruction error = %e\n", d2);
    }

    public double[] transform(double[] dArray, double[] dArray2, boolean bl2) {
        int n2;
        if (dArray == null || dArray.length == 0) {
            throw new InvalidParameterException("Convolution::transform(double[], double[]-data is null");
        }
        int n3 = (bl2 ? 1 : 3) * dArray.length;
        int n4 = ConcurrencyUtils.nextPow2(n3);
        int n5 = n2 = bl2 ? 0 : n4 / 3 - 1;
        if (dArray2 == null || dArray2.length == 0 || dArray2.length != n4) {
            throw new InvalidParameterException("Convolution::transform(double[], double[]-filter is null or its dimension (" + (Serializable)(dArray2 == null ? "null" : Integer.valueOf(dArray2.length)) + ") does not match the data");
        }
        this.init(n4);
        double[] dArray3 = new double[n4];
        if (bl2) {
            for (int i2 = 0; i2 < n4; ++i2) {
                dArray3[i2] = i2 < dArray.length ? dArray[i2] : 0.0;
            }
        } else {
            for (int i3 = 0; i3 < n4; ++i3) {
                if (i3 < n2) {
                    dArray3[i3] = dArray[0];
                    continue;
                }
                if (i3 < n2 + dArray.length) {
                    dArray3[i3] = dArray[i3 - n2];
                    continue;
                }
                if (i3 <= n2 + dArray.length) continue;
                dArray3[i3] = dArray[dArray.length - 1];
            }
        }
        this.f1dFFT.realForward(dArray3);
        Convolution.complexMultiply(dArray3, dArray2);
        this.f1dFFT.realInverse(dArray3, true);
        if (bl2) {
            return dArray3.length != dArray.length ? Arrays.copyOf(dArray3, dArray.length) : dArray3;
        }
        return Arrays.copyOfRange(dArray3, n2, n2 + dArray.length);
    }

    public double[] transformFull(double[] dArray, double[] dArray2, boolean bl2) {
        int n2;
        if (dArray == null || dArray.length == 0) {
            throw new InvalidParameterException("Convolution::transform(double[], double[], boolean)\n-data is null");
        }
        int n3 = (bl2 ? 1 : 3) * dArray.length;
        int n4 = ConcurrencyUtils.nextPow2(n3);
        int n5 = n2 = bl2 ? 0 : n4 / 3 - 1;
        if (dArray2 == null || dArray2.length == 0 || dArray2.length != 2 * n4) {
            throw new InvalidParameterException("Convolution::transform(double[], double[], boolean)\n-filter is null or its dimension (" + (Serializable)(dArray2 == null ? "null" : Integer.valueOf(dArray2.length)) + ") does not match the data dimension (" + n4 + ")");
        }
        this.init(n4);
        double[] dArray3 = new double[n4];
        if (bl2) {
            for (var8_8 = 0; var8_8 < n4; ++var8_8) {
                dArray3[var8_8] = var8_8 < dArray.length ? dArray[var8_8] : 0.0;
            }
        } else {
            for (var8_8 = 0; var8_8 < n4; ++var8_8) {
                if (var8_8 < n2) {
                    dArray3[var8_8] = dArray[0];
                    continue;
                }
                if (var8_8 < n2 + dArray.length) {
                    dArray3[var8_8] = dArray[var8_8 - n2];
                    continue;
                }
                if (var8_8 <= n2 + dArray.length) continue;
                dArray3[var8_8] = dArray[dArray.length - 1];
            }
        }
        double[] dArray4 = new double[2 * n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            dArray4[i2 << 1] = dArray3[i2];
        }
        this.f1dFFT.complexForward(dArray4);
        Convolution.complexMultiply(dArray4, dArray2);
        this.f1dFFT.complexInverse(dArray4, true);
        if (bl2) {
            return dArray4;
        }
        return Arrays.copyOfRange(dArray4, 2 * n2, 2 * n2 + 2 * dArray.length);
    }

    public static void complexMultiply(double[] dArray, double[] dArray2) {
        int n2 = dArray2.length >> 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 << 1;
            int n4 = n3 + 1;
            double d2 = dArray[n3];
            double d3 = dArray[n4];
            double d4 = dArray2[n3];
            double d5 = dArray2[n4];
            dArray[2 * i2] = d2 * d4 - d3 * d5;
            dArray[2 * i2 + 1] = d2 * d5 + d3 * d4;
        }
    }

    public static double[] getDerivativeFilter(int n2) {
        if (n2 <= 0 || n2 % 2 != 0) {
            throw new InvalidParameterException("getDerivativeFilter(" + n2 + ") - length has to be positive and multiples of two");
        }
        double[] dArray = new double[n2];
        int n3 = n2 >> 1;
        double d2 = Math.PI * 2 / (double)n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2 << 1;
            double d3 = Math.cos(Math.PI * (double)i2 / (double)(n2 - 1));
            double d4 = d3 * d2 * (double)i2;
            if (i2 < n3) {
                dArray[n4] = 0.0;
                dArray[n4 + 1] = d4;
                continue;
            }
            dArray[n4] = 0.0;
            dArray[n4 + 1] = -d4;
        }
        dArray[1] = 0.0;
        return dArray;
    }

    public static double[] getHilbertFilter(int n2) {
        if (n2 <= 0 || !ConcurrencyUtils.isPowerOf2(n2)) {
            throw new InvalidParameterException("getHilbertFilter(" + n2 + ") - length has to be positive and a power of two");
        }
        double[] dArray = new double[n2];
        int n3 = n2 >> 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2 << 1;
            dArray[i2 << 1] = 1.0;
            if (i2 < n3) {
                dArray[n4] = 0.0;
                dArray[n4 + 1] = -1.0;
            } else {
                dArray[n4] = 0.0;
                dArray[n4 + 1] = 1.0;
            }
            if (n4 != 0) continue;
            dArray[n4] = 0.0;
            dArray[n4 + 1] = 0.0;
        }
        dArray[1] = 1.0;
        return dArray;
    }

    public static double[] getIdentityFilter(int n2) {
        if (n2 <= 0 || !ConcurrencyUtils.isPowerOf2(n2)) {
            throw new InvalidParameterException("getIdentityFilter(" + n2 + ") - length has to be a power of two");
        }
        double[] dArray = new double[n2];
        for (int i2 = 0; i2 < n2 >> 1; ++i2) {
            dArray[i2 << 1] = 1.0;
        }
        return dArray;
    }

    public static double[] getLowPassFilter(int n2, double d2) {
        if (n2 <= 0 || n2 % 2 != 0) {
            throw new InvalidParameterException("getLowPassFilter(" + n2 + ") - length has to be positive and a power of two");
        }
        if (d2 > 0.5) {
            d2 = 0.5;
        }
        double[] dArray = new double[n2];
        int n3 = n2 >> 1;
        double d3 = Math.PI * 2 / d2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2 << 1;
            double d4 = (double)i2 / (double)n2;
            double d5 = 1.0 / (1.0 + MathBase.sqr(d3 * d4));
            double d6 = d5 * d3 * d4;
            dArray[n4] = d5;
            dArray[n4 + 1] = d6;
        }
        return dArray;
    }

    public static double[] getMorletFilter(int n2, double d2, double d3) {
        if (n2 <= 0 || !ConcurrencyUtils.isPowerOf2(n2)) {
            throw new InvalidParameterException("getMorletFilter(" + n2 + "," + d2 + ") - length has to be positive and multiples of two");
        }
        if (d2 < 0.0 || d2 > 0.7957747154594768) {
            throw new InvalidParameterException("getMorletFilter(" + n2 + "," + d2 + ") - frequency has to be within [0,0.5]");
        }
        double[] dArray = new double[2 * n2];
        int n3 = n2;
        int n4 = 2 * n2 - 1;
        for (int i2 = 0; i2 < n3; ++i2) {
            double d4;
            int n5 = i2 << 1;
            double d5 = (double)i2 / (double)n2;
            dArray[n5] = d4 = Convolution.MorletWaveletFunctionFourier(d5, d2, d3);
            dArray[n5 + 1] = 0.0;
            dArray[n4 - n5] = d4;
        }
        return dArray;
    }

    public static void main(String[] stringArray) {
        Convolution convolution = new Convolution();
        convolution.Test();
    }

    protected static double MorletWaveletFunctionFourier(double d2, double d3, double d4) {
        double d5 = d4 / 2.0;
        double d6 = MathBase.exp(-0.5 * MathBase.sqr(Math.PI * 2 * d3 * d5));
        double d7 = MathBase.pow(Math.PI, 0.25);
        double d8 = d7 * (MathBase.exp(-0.5 * MathBase.sqr(Math.PI * 2 * (d3 - d2) * d5)) - d6 * MathBase.exp(-0.5 * MathBase.sqr(Math.PI * 2 * d2 * d5)));
        return d8;
    }
}

