/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.matrix;

import io.fair_acc.math.MathBase;
import io.fair_acc.math.functions.Function1D;
import io.fair_acc.math.matrix.AbstractMatrix;
import io.fair_acc.math.matrix.CholeskyDecomposition;
import io.fair_acc.math.matrix.EigenvalueDecomposition;
import io.fair_acc.math.matrix.LUDecomposition;
import io.fair_acc.math.matrix.MatrixFactory;
import io.fair_acc.math.matrix.QRDecomposition;
import io.fair_acc.math.matrix.SingularValueDecomposition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Vector;

public class MatrixD
extends AbstractMatrix {
    private static final long serialVersionUID = 491870425070247870L;
    private final double[][] element;

    public MatrixD(double[] dArray, int n2) {
        this(dArray, n2, true);
    }

    public MatrixD(double[] dArray, int n2, boolean bl2) {
        this.m = n2;
        int n3 = this.n = n2 != 0 ? dArray.length / n2 : 0;
        if (n2 * this.n != dArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.element = new double[n2][this.n];
        if (bl2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                System.arraycopy(dArray, i2 * this.n, this.element[i2], 0, this.n);
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                for (int i4 = 0; i4 < this.n; ++i4) {
                    this.element[i3][i4] = dArray[i3 + i4 * n2];
                }
            }
        }
    }

    public MatrixD(double[][] dArray) {
        this.m = dArray.length;
        this.n = dArray[0].length;
        for (int i2 = 0; i2 < this.m; ++i2) {
            if (dArray[i2].length == this.n) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.element = dArray;
    }

    public MatrixD(double[][] dArray, int n2, int n3) {
        this.element = dArray;
        this.m = n2;
        this.n = n3;
    }

    public MatrixD(int n2, int n3) {
        this.m = n2;
        this.n = n3;
        this.element = new double[n2][n3];
    }

    public MatrixD(int n2, int n3, double d2) {
        this.m = n2;
        this.n = n3;
        this.element = new double[n2][n3];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                this.element[i2][i3] = d2;
            }
        }
    }

    public void apply1DFunction(Function1D function1D) {
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.element[i2][i3] = function1D.getValue(this.element[i2][i3]);
            }
        }
    }

    public MatrixD arrayLeftDivide(MatrixD matrixD) {
        this.checkMatrixDimensions(matrixD);
        MatrixD matrixD2 = new MatrixD(this.m, this.n);
        double[][] dArray = matrixD2.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = matrixD.element[i2][i3] / this.element[i2][i3];
            }
        }
        return matrixD2;
    }

    public MatrixD arrayLeftDivideEquals(MatrixD matrixD) {
        this.checkMatrixDimensions(matrixD);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.element[i2][i3] = matrixD.element[i2][i3] / this.element[i2][i3];
            }
        }
        return this;
    }

    public MatrixD arrayRightDivide(MatrixD matrixD) {
        this.checkMatrixDimensions(matrixD);
        MatrixD matrixD2 = new MatrixD(this.m, this.n);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                matrixD2.set(i2, i3, this.get(i2, i3) / matrixD.get(i2, i3));
            }
        }
        return matrixD2;
    }

    public MatrixD arrayRightDivideEquals(MatrixD matrixD) {
        this.checkMatrixDimensions(matrixD);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.element[i2][i3] = this.element[i2][i3] / matrixD.element[i2][i3];
            }
        }
        return this;
    }

    public MatrixD arrayTimes(MatrixD matrixD) {
        this.checkMatrixDimensions(matrixD);
        MatrixD matrixD2 = new MatrixD(this.m, this.n);
        double[][] dArray = matrixD2.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = this.element[i2][i3] * matrixD.element[i2][i3];
            }
        }
        return matrixD2;
    }

    public MatrixD arrayTimesEquals(MatrixD matrixD) {
        this.checkMatrixDimensions(matrixD);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.set(i2, i3, this.get(i2, i3) * matrixD.get(i2, i3));
            }
        }
        return this;
    }

    public CholeskyDecomposition chol() {
        return new CholeskyDecomposition(this);
    }

    public Object clone() {
        return this.copy();
    }

    public double cond() {
        return new SingularValueDecomposition(this).cond();
    }

    @Override
    public MatrixD copy() {
        MatrixD matrixD = new MatrixD(this.m, this.n);
        double[][] dArray = matrixD.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            if (this.n < 0) continue;
            System.arraycopy(this.element[i2], 0, dArray[i2], 0, this.n);
        }
        return matrixD;
    }

    public double det() {
        return new LUDecomposition(this).det();
    }

    public EigenvalueDecomposition eig() {
        return new EigenvalueDecomposition(this);
    }

    @Override
    public double get(int n2, int n3) {
        return this.element[n2][n3];
    }

    public double[][] getArray() {
        return this.element;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.m][this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            System.arraycopy(this.element[i2], 0, dArray[i2], 0, this.n);
        }
        return dArray;
    }

    public double[] getColumnPackedCopy() {
        double[] dArray = new double[this.m * this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2 + i3 * this.m] = this.element[i2][i3];
            }
        }
        return dArray;
    }

    public MatrixD getMatrix(int n2, int n3, int n4, int n5) {
        MatrixD matrixD = new MatrixD(n3 - n2 + 1, n5 - n4 + 1);
        double[][] dArray = matrixD.getArray();
        try {
            for (int i2 = n2; i2 <= n3; ++i2) {
                System.arraycopy(this.element[i2], n4, dArray[i2 - n2], n4, n5 - n4);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrixD;
    }

    public MatrixD getMatrix(int n2, int n3, int[] nArray) {
        MatrixD matrixD = new MatrixD(n3 - n2 + 1, nArray.length);
        double[][] dArray = matrixD.getArray();
        try {
            for (int i2 = n2; i2 <= n3; ++i2) {
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    dArray[i2 - n2][i3] = this.element[i2][nArray[i3]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrixD;
    }

    public MatrixD getMatrix(int[] nArray, int n2, int n3) {
        MatrixD matrixD = new MatrixD(nArray.length, n3 - n2 + 1);
        double[][] dArray = matrixD.getArray();
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (n3 + 1 - n2 < 0) continue;
                System.arraycopy(this.element[nArray[i2]], n2, dArray[i2], n2 - n2, n3 + 1 - n2);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrixD;
    }

    public MatrixD getMatrix(int[] nArray, int[] nArray2) {
        MatrixD matrixD = new MatrixD(nArray.length, nArray2.length);
        double[][] dArray = matrixD.getArray();
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = 0; i3 < nArray2.length; ++i3) {
                    dArray[i2][i3] = this.element[nArray[i2]][nArray2[i3]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrixD;
    }

    public double[] getRowPackedCopy() {
        double[] dArray = new double[this.m * this.n];
        for (int i2 = 0; i2 < this.m; ++i2) {
            System.arraycopy(this.element[i2], 0, dArray, i2 * this.m, this.n);
        }
        return dArray;
    }

    public MatrixD inverse() {
        return this.solve(MatrixFactory.identity(this.m, this.m));
    }

    public LUDecomposition lu() {
        return new LUDecomposition(this);
    }

    public MatrixD minus(MatrixD matrixD) {
        this.checkMatrixDimensions(matrixD);
        MatrixD matrixD2 = new MatrixD(this.m, this.n);
        double[][] dArray = matrixD2.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = this.element[i2][i3] - matrixD.element[i2][i3];
            }
        }
        return matrixD2;
    }

    public MatrixD minusEquals(MatrixD matrixD) {
        this.checkMatrixDimensions(matrixD);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.element[i2][i3] = this.element[i2][i3] - matrixD.element[i2][i3];
            }
        }
        return this;
    }

    public MatrixD plus(MatrixD matrixD) {
        this.checkMatrixDimensions(matrixD);
        MatrixD matrixD2 = new MatrixD(this.m, this.n);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                matrixD2.set(i2, i3, this.get(i2, i3) + matrixD.get(i2, i3));
            }
        }
        return matrixD2;
    }

    public MatrixD plusEquals(MatrixD matrixD) {
        this.checkMatrixDimensions(matrixD);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.set(i2, i3, this.get(i2, i3) + matrixD.get(i2, i3));
            }
        }
        return this;
    }

    public void print(int n2, int n3) {
        this.print(new PrintWriter(System.out, true), n2, n3);
    }

    public void print(NumberFormat numberFormat, int n2) {
        this.print(new PrintWriter(System.out, true), numberFormat, n2);
    }

    public void print(PrintWriter printWriter, int n2, int n3) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumFractionDigits(n3);
        decimalFormat.setMinimumFractionDigits(n3);
        decimalFormat.setGroupingUsed(false);
        this.print(printWriter, decimalFormat, n2 + 2);
    }

    public void print(PrintWriter printWriter, NumberFormat numberFormat, int n2) {
        printWriter.println();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                String string = numberFormat.format(this.element[i2][i3]);
                int n3 = Math.max(1, n2 - string.length());
                for (int i4 = 0; i4 < n3; ++i4) {
                    printWriter.print(' ');
                }
                printWriter.print(string);
            }
            printWriter.println();
        }
        printWriter.println();
    }

    public MatrixD pseudoInverse(double d2) {
        SingularValueDecomposition singularValueDecomposition = this.svd();
        double d3 = d2 > 0.0 ? 1.0 / d2 : 1.0E19;
        double[] dArray = singularValueDecomposition.getSingularValues();
        MatrixD matrixD = new MatrixD(dArray.length, dArray.length);
        double d4 = dArray[0];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (dArray[i2] / d4 < d3 || MathBase.abs(dArray[i2]) < 9.9E-324) {
                System.out.println("TMatrixD::drop singluar eigenvalue " + i2);
                matrixD.set(i2, i2, 0.0);
                continue;
            }
            matrixD.set(i2, i2, 1.0 / dArray[i2]);
        }
        singularValueDecomposition.rank();
        return singularValueDecomposition.getV().times(matrixD).times(singularValueDecomposition.getU().transpose());
    }

    public QRDecomposition qr() {
        return new QRDecomposition(this);
    }

    public int rank() {
        return new SingularValueDecomposition(this).rank();
    }

    @Override
    public void set(int n2, int n3, double d2) {
        this.element[n2][n3] = d2;
    }

    public void setMatrix(int n2, int n3, int n4, int n5, MatrixD matrixD) {
        try {
            for (int i2 = n2; i2 <= n3; ++i2) {
                for (int i3 = n4; i3 <= n5; ++i3) {
                    this.element[i2][i3] = matrixD.get(i2 - n2, i3 - n4);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int n2, int n3, int[] nArray, MatrixD matrixD) {
        try {
            for (int i2 = n2; i2 <= n3; ++i2) {
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    this.element[i2][nArray[i3]] = matrixD.get(i2 - n2, i3);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int n2, int n3, MatrixD matrixD) {
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = n2; i3 <= n3; ++i3) {
                    this.element[nArray[i2]][i3] = matrixD.get(i2, i3 - n2);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int[] nArray2, MatrixD matrixD) {
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                for (int i3 = 0; i3 < nArray2.length; ++i3) {
                    this.element[nArray[i2]][nArray2[i3]] = matrixD.get(i2, i3);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public MatrixD solve(MatrixD matrixD) {
        return this.m == this.n ? new LUDecomposition(this).solve(matrixD) : new QRDecomposition(this).solve(matrixD);
    }

    public MatrixD solveTranspose(MatrixD matrixD) {
        return this.transpose().solve(matrixD.transpose());
    }

    public void squareElements() {
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.element[i2][i3] = MathBase.sqr(this.element[i2][i3]);
            }
        }
    }

    public SingularValueDecomposition svd() {
        return new SingularValueDecomposition(this);
    }

    public MatrixD times(double d2) {
        MatrixD matrixD = new MatrixD(this.m, this.n);
        double[][] dArray = matrixD.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i2][i3] = d2 * this.element[i2][i3];
            }
        }
        return matrixD;
    }

    public MatrixD times(MatrixD matrixD) {
        if (matrixD.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        MatrixD matrixD2 = new MatrixD(this.m, matrixD.n);
        double[][] dArray = matrixD2.getArray();
        double[] dArray2 = new double[this.n];
        if (matrixD.n != 1) {
            for (int i2 = 0; i2 < matrixD.n; ++i2) {
                int n2;
                for (n2 = 0; n2 < this.n; ++n2) {
                    dArray2[n2] = matrixD.element[n2][i2];
                }
                for (n2 = 0; n2 < this.m; ++n2) {
                    double[] dArray3 = this.element[n2];
                    double d2 = 0.0;
                    for (int i3 = 0; i3 < this.n; ++i3) {
                        d2 += dArray3[i3] * dArray2[i3];
                    }
                    dArray[n2][i2] = d2;
                }
            }
        } else {
            int n3;
            for (n3 = 0; n3 < this.n; ++n3) {
                dArray2[n3] = matrixD.element[n3][0];
            }
            for (n3 = 0; n3 < this.m; ++n3) {
                double d3 = 0.0;
                for (int i4 = 0; i4 < this.n; ++i4) {
                    d3 += this.element[n3][i4] * dArray2[i4];
                }
                dArray[n3][0] = d3;
            }
        }
        return matrixD2;
    }

    public MatrixD timesEquals(double d2) {
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                this.element[i2][i3] = d2 * this.element[i2][i3];
            }
        }
        return this;
    }

    public double trace() {
        double d2 = 0.0;
        for (int i2 = 0; i2 < Math.min(this.m, this.n); ++i2) {
            d2 += this.element[i2][i2];
        }
        return d2;
    }

    public MatrixD transpose() {
        MatrixD matrixD = new MatrixD(this.n, this.m);
        double[][] dArray = matrixD.getArray();
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                dArray[i3][i2] = this.element[i2][i3];
            }
        }
        return matrixD;
    }

    public MatrixD uminus() {
        MatrixD matrixD = new MatrixD(this.m, this.n);
        for (int i2 = 0; i2 < this.m; ++i2) {
            for (int i3 = 0; i3 < this.n; ++i3) {
                matrixD.set(i2, i3, -this.element[i2][i3]);
            }
        }
        return matrixD;
    }

    public static MatrixD read(BufferedReader bufferedReader) throws IOException {
        int n2;
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.eolIsSignificant(true);
        Vector<Double> vector = new Vector<Double>();
        while (streamTokenizer.nextToken() == 10) {
        }
        if (streamTokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            vector.addElement(Double.valueOf(streamTokenizer.sval));
        } while (streamTokenizer.nextToken() == -3);
        int n3 = vector.size();
        Double[] doubleArray = new Double[n3];
        vector.removeAllElements();
        for (n2 = 0; n2 < n3; ++n2) {
            vector.addElement((Double)vector.elementAt(n2));
        }
        while (streamTokenizer.nextToken() == -3) {
            n2 = 0;
            do {
                if (n2 >= n3) {
                    throw new IOException("Row " + vector.size() + " is too long.");
                }
                vector.addElement(Double.valueOf(streamTokenizer.sval));
            } while (streamTokenizer.nextToken() == -3);
            if (n2 >= n3) continue;
            throw new IOException("Row " + vector.size() + " is too short.");
        }
        n2 = vector.size();
        double[][] dArrayArray = new double[n2][];
        vector.copyInto((Object[])dArrayArray);
        return new MatrixD(dArrayArray);
    }
}

