/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.fitter;

import io.fair_acc.math.functions.Function;
import io.fair_acc.math.functions.Function1D;
import io.fair_acc.math.functions.PolynomialFunction;
import io.fair_acc.math.matrix.MatrixD;
import io.fair_acc.math.matrix.SingularValueDecomposition;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Random;

public class LinearRegressionFitter {
    private static final String NULL_FUNCTION_WARN = "function pointer is null/is not defined or fit hasn't been run yet";
    public static boolean USE_SVD = true;
    private MatrixD forwardMatrix;
    private MatrixD errorMatrix;
    private MatrixD inverseMatrix;
    private MatrixD errorPropagationMatrix;
    private Function1D function;
    private double[] xValuesRef;
    private double[] yValuesRef;
    private double fsvdCutOff = 1.0E-16;
    private double ftikhonov = 1.0;
    private REG_METHOD fregularisationMethod = REG_METHOD.STANDARD;
    private boolean useErrors;
    private boolean isConverged;
    private long lastPrepareDuration = -1L;
    private long lastFitDuration = -1L;
    private double chiSquared = -1.0;
    private boolean fisSilent = true;
    private MatrixD flastFitResult;
    private MatrixD flastFitError;

    public LinearRegressionFitter() {
        this.reinitialise();
    }

    public synchronized double[][] fit(Function function, double[] dArray, double[] dArray2) {
        this.fitLocal(function, dArray, dArray2);
        MatrixD matrixD = this.forwardMatrix.times(this.flastFitResult);
        this.chiSquared = 0.0;
        double[] dArray3 = new double[this.yValuesRef.length];
        double[] dArray4 = new double[this.yValuesRef.length];
        for (int i2 = 0; i2 < dArray3.length; ++i2) {
            dArray3[i2] = matrixD.get(i2, 0);
        }
        MatrixD matrixD2 = this.flastFitError.copy();
        MatrixD matrixD3 = this.errorPropagationMatrix.times(matrixD2);
        for (int i3 = 0; i3 < dArray3.length; ++i3) {
            dArray4[i3] = Math.sqrt(matrixD3.get(i3, 0));
        }
        return new double[][]{this.xValuesRef, dArray3, dArray4};
    }

    public synchronized void fit(Function function, Function function2, double[] dArray, double[] dArray2) {
        int n2;
        this.fitLocal(function, dArray, dArray2);
        if (function2 == null) {
            throw new InvalidParameterException("LinearRegressionFitter::fit(Function, Function, double[], double[]) - return function pointer is null");
        }
        int n3 = function.getParameterCount();
        if (n3 >= (n2 = function2.getParameterCount())) {
            throw new InvalidParameterException("LinearRegressionFitter::fit(Function, Function, double[], double[]) - return parameter function has insufficient parameter count (" + n2 + " vs. required " + n3);
        }
        for (int i2 = 0; i2 < function.getParameterCount(); ++i2) {
            double d2 = this.getParameter(i2);
            double d3 = this.getParError(i2);
            function2.setParameterValue(i2, d2);
            function2.setParameterRange(i2, d2 - d3, d2 + d3);
        }
    }

    private synchronized void fitLocal(Function function, double[] dArray, double[] dArray2) {
        Object object;
        String string = "RegressionFitter::fit(Function,";
        String string2 = "RegressionFitter::fit(Function, double[], double[]) - ";
        if (function == null) {
            throw new InvalidParameterException("RegressionFitter::fit(Function, double[], double[]) - function pointer is null");
        }
        if (dArray == null || dArray2 == null) {
            throw new InvalidParameterException("RegressionFitter::fit(Function," + (dArray != null ? "double[]" : "null") + ", " + (dArray2 != null ? "double[]" : "null") + ") - array pointer are null");
        }
        if (dArray.length != dArray2.length) {
            throw new InvalidParameterException("RegressionFitter::fit(Function,double[" + dArray.length + "], double[" + dArray2.length + "]) - array pointer size mis-match");
        }
        if (function.getInputDimension() != 1) {
            throw new InvalidParameterException("RegressionFitter::fit(Function, double[], double[]) -  for the time being: only one dimensional fits implemented");
        }
        if (function.getFreeParameterCount() > dArray2.length) {
            throw new InvalidParameterException("RegressionFitter::fit(Function, double[], double[]) -  cannot fit function with more free parameters than data points (" + function.getParameterCount() + " vs. " + dArray2.length + ")");
        }
        long l2 = System.currentTimeMillis();
        boolean bl2 = true;
        this.reinitialise();
        this.function = (Function1D)function;
        this.xValuesRef = Arrays.copyOf(dArray, dArray.length);
        this.yValuesRef = Arrays.copyOf(dArray2, dArray2.length);
        this.function.setFitterMode(true);
        if (bl2) {
            object = new double[this.yValuesRef.length][this.function.getParameterCount()];
            for (int i2 = 0; i2 < this.xValuesRef.length; ++i2) {
                double d2 = dArray[i2];
                for (int i3 = 0; i3 < this.function.getParameterCount(); ++i3) {
                    if (!this.function.isParameterFixed(i3)) {
                        this.function.clearParameterValues();
                        this.function.setParameterValue(i3, 1.0);
                        object[i2][i3] = this.function.getValue(d2);
                        continue;
                    }
                    object[i2][i3] = 0.0;
                }
            }
            this.function.clearParameterValues();
            this.forwardMatrix = new MatrixD((double[][])object);
            this.errorPropagationMatrix = (MatrixD)this.forwardMatrix.clone();
            this.errorPropagationMatrix.squareElements();
            if (USE_SVD) {
                SingularValueDecomposition singularValueDecomposition = this.forwardMatrix.svd();
                double[] dArray3 = singularValueDecomposition.getSingularValues();
                MatrixD matrixD = new MatrixD(dArray3.length, dArray3.length);
                double d3 = dArray3[0];
                switch (this.fregularisationMethod) {
                    case TIKHONOV: {
                        int n2;
                        for (n2 = 0; n2 < dArray3.length; ++n2) {
                            if (dArray3[n2] != 0.0) {
                                if (this.ftikhonov > 0.0) {
                                    matrixD.set(n2, n2, dArray3[n2] / (dArray3[n2] * dArray3[n2] + this.ftikhonov * this.ftikhonov));
                                    continue;
                                }
                                if (Math.abs(dArray3[n2]) > 1.0E-16) {
                                    matrixD.set(n2, n2, 1.0 / dArray3[n2]);
                                    continue;
                                }
                                matrixD.set(n2, n2, 0.0);
                                if (this.fisSilent) continue;
                                System.out.println("drop singular eigenvalue " + n2);
                                continue;
                            }
                            matrixD.set(n2, n2, 0.0);
                            if (this.fisSilent) continue;
                            System.out.println("drop singular eigenvalue " + n2);
                        }
                        break;
                    }
                    default: {
                        int n2;
                        for (n2 = 0; n2 < dArray3.length; ++n2) {
                            if (dArray3[n2] / d3 < this.fsvdCutOff || dArray3[n2] < 1.0E-16) {
                                if (!this.fisSilent) {
                                    System.out.println("drop singular eigenvalue " + n2);
                                }
                                matrixD.set(n2, n2, 0.0);
                                continue;
                            }
                            matrixD.set(n2, n2, 1.0 / dArray3[n2]);
                        }
                        singularValueDecomposition.rank();
                    }
                }
                this.inverseMatrix = singularValueDecomposition.getV().times(matrixD).times(singularValueDecomposition.getU().transpose());
            } else {
                this.inverseMatrix = this.forwardMatrix.inverse();
            }
            this.errorMatrix = (MatrixD)this.inverseMatrix.clone();
            this.errorMatrix.squareElements();
        }
        this.function.setFitterMode(false);
        this.flastFitResult = this.inverseMatrix.times(new MatrixD(dArray2, dArray2.length));
        if (this.flastFitResult == null) {
            throw new IllegalArgumentException("could not generate fit results: null-vector");
        }
        this.chiSquared = 0.0;
        object = new double[this.yValuesRef.length];
        MatrixD matrixD = this.forwardMatrix.times(this.flastFitResult);
        for (int i4 = 0; i4 < this.yValuesRef.length; ++i4) {
            object[i4] = (double[])matrixD.get(i4, 0);
            this.chiSquared += Math.pow((double)object[i4], 2.0) / Math.abs(this.yValuesRef[i4]);
        }
        MatrixD matrixD2 = new MatrixD((double[])object, ((double[][])object).length);
        this.flastFitError = this.errorMatrix.times(matrixD2);
        this.isConverged = true;
        long l3 = System.currentTimeMillis();
        this.lastPrepareDuration = l3 - l2;
        this.lastFitDuration = l3 - l2;
        if (!this.fisSilent) {
            for (int i5 = 0; i5 < this.function.getParameterCount(); ++i5) {
                System.out.printf("parameter %d (orig. vs. fit.): %+f vs. %+f ( %+f <-> %+f) \n", i5, this.function.getParameterValue(i5), this.flastFitResult.get(i5, 0), Math.abs(this.function.getParameterValue(i5) - this.flastFitResult.get(i5, 0)) / this.function.getParameterValue(i5), this.flastFitError.get(i5, 0) / this.function.getParameterValue(i5));
            }
        }
    }

    public synchronized double[] getBestEstimates() {
        if (this.flastFitResult == null) {
            throw new InvalidParameterException("LinearRegressionFitter::getBestEstimates() - function pointer is null/is not defined or fit hasn't been run yet");
        }
        double[] dArray = new double[this.flastFitResult.getRowDimension()];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = this.flastFitResult.get(i2, 0);
        }
        return dArray;
    }

    public synchronized double[] getBestEstimatesErrors() {
        if (this.flastFitError == null) {
            throw new InvalidParameterException("LinearRegressionFitter::getBestEstimatesErrors() - function pointer is null/is not defined or fit hasn't been run yet");
        }
        double[] dArray = new double[this.flastFitError.getRowDimension()];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray[i2] = this.flastFitError.get(i2, 0);
        }
        return dArray;
    }

    public synchronized double getChiSquared() {
        return this.chiSquared;
    }

    public synchronized long getLastFitDuration() {
        return this.lastFitDuration;
    }

    public synchronized long getLastPrepareDuration() {
        return this.lastPrepareDuration;
    }

    public synchronized double getParameter(int n2) {
        if (this.flastFitResult == null) {
            throw new InvalidParameterException("LinearRegressionFitter::getParameter(int) - function pointer is null/is not defined or fit hasn't been run yet");
        }
        if (n2 < 0 || n2 >= this.flastFitResult.getRowDimension()) {
            throw new InvalidParameterException("LinearRegressionFitter::getParameter(" + n2 + ") - requested invalid parameter index [0," + this.flastFitResult.getRowDimension() + "]");
        }
        return this.flastFitResult.get(n2, 0);
    }

    public synchronized double getParError(int n2) {
        if (this.flastFitError == null) {
            throw new InvalidParameterException("LinearRegressionFitter::getParameter(int) - function pointer is null/is not defined or fit hasn't been run yet");
        }
        if (n2 < 0 || n2 >= this.flastFitError.getRowDimension()) {
            throw new InvalidParameterException("LinearRegressionFitter::getParameter(" + n2 + ") - requested invalid parameter index [0," + this.flastFitError.getRowDimension() + "]");
        }
        return this.flastFitError.get(n2, 0);
    }

    public synchronized REG_METHOD getRegularisationMethod() {
        return this.fregularisationMethod;
    }

    public synchronized double getSVDCutOff() {
        return this.fsvdCutOff;
    }

    public synchronized double getTikhonovRegularisation() {
        return this.ftikhonov;
    }

    public synchronized boolean isConverged() {
        return this.isConverged;
    }

    public synchronized boolean isErrorWeighting() {
        return this.useErrors;
    }

    public synchronized boolean isSilent() {
        return this.fisSilent;
    }

    private synchronized void reinitialise() {
        this.forwardMatrix = null;
        this.errorMatrix = null;
        this.inverseMatrix = null;
        this.errorPropagationMatrix = null;
        this.function = null;
        this.xValuesRef = null;
        this.yValuesRef = null;
        this.useErrors = false;
        this.isConverged = false;
        this.lastPrepareDuration = -1L;
        this.lastFitDuration = -1L;
        this.chiSquared = -1.0;
    }

    public synchronized void setErrorWeighting(boolean bl2) {
        this.useErrors = bl2;
    }

    public synchronized void setRegularisationMethod(REG_METHOD rEG_METHOD) {
        this.fregularisationMethod = rEG_METHOD;
    }

    public synchronized void setSVDCutOff(double d2) {
        this.fsvdCutOff = d2;
    }

    public synchronized void setTikhonovRegularisation(double d2) {
        this.ftikhonov = d2;
    }

    public synchronized void setVerbosity(boolean bl2) {
        this.fisSilent = !bl2;
    }

    public static void main(String[] stringArray) {
        PolynomialFunction polynomialFunction = new PolynomialFunction("poly1", new double[]{0.5, 1.0, 2.0, 0.6, 1.0E-4});
        double[] dArray = new double[20];
        double[] dArray2 = new double[20];
        Random random = new Random();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d2 = random.nextGaussian();
            dArray[i2] = (double)i2 - (double)dArray.length / 2.0;
            dArray2[i2] = polynomialFunction.getValue(dArray[i2]) + 0.1 * d2;
        }
        polynomialFunction.fixParameter(0, true);
        LinearRegressionFitter linearRegressionFitter = new LinearRegressionFitter();
        linearRegressionFitter.fit(polynomialFunction, dArray, dArray2);
        System.out.println("elapsed time " + linearRegressionFitter.getLastFitDuration() + " ms,  ch2 = " + linearRegressionFitter.getChiSquared());
    }

    public static enum REG_METHOD {
        STANDARD,
        TIKHONOV;

    }
}

