/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math;

public class Spline {
    private final int fnPoints;
    private final double[] fx;
    private final double[] fy;
    private final double[] fA;
    private final double[] fB;
    private final double[] fC;
    private final double[] fBoundCond1 = new double[2];
    private final double[] fBoundCondN = new double[2];

    public Spline(double[] dArray, double[] dArray2) {
        this(dArray, dArray2, dArray.length, 0);
    }

    public Spline(double[] dArray, double[] dArray2, int n2, int n3) {
        this.fnPoints = n2;
        this.fx = new double[n2];
        this.fy = new double[n2];
        this.fA = new double[n2 - 1];
        this.fB = new double[n2 - 1];
        this.fC = new double[n2 - 1];
        System.arraycopy(dArray, n3, this.fx, 0, n2);
        System.arraycopy(dArray2, n3, this.fy, 0, n2);
        this.SetupBoundaryConditions();
        this.CalcCoefficients();
    }

    private void CalcCoefficients() {
        double d2;
        int n2;
        double d3 = this.fx[1] - this.fx[0];
        double d4 = this.fy[1] - this.fy[0];
        for (n2 = 1; n2 < this.fnPoints - 1; ++n2) {
            double d5 = this.fx[n2 + 1] - this.fx[n2];
            d2 = this.fy[n2 + 1] - this.fy[n2];
            this.fC[n2] = d5 / (d3 + d5);
            this.fB[n2] = 1.0 - this.fC[n2];
            this.fA[n2] = 6.0 * (d2 / d5 - d4 / d3) / (d3 + d5);
            d3 = d5;
            d4 = d2;
        }
        this.fC[0] = -this.fBoundCond1[0] / 2.0;
        this.fB[0] = this.fBoundCond1[1] / 2.0;
        this.fA[0] = 0.0;
        for (n2 = 1; n2 < this.fnPoints - 1; ++n2) {
            double d6 = this.fB[n2] * this.fC[n2 - 1] + 2.0;
            this.fC[n2] = -this.fC[n2] / d6;
            this.fB[n2] = (this.fA[n2] - this.fB[n2] * this.fB[n2 - 1]) / d6;
        }
        d4 = (this.fBoundCondN[1] - this.fBoundCondN[0] * this.fB[this.fnPoints - 2]) / (this.fBoundCondN[0] * this.fC[this.fnPoints - 2] + 2.0);
        for (n2 = this.fnPoints - 2; n2 >= 0; --n2) {
            d3 = this.fx[n2 + 1] - this.fx[n2];
            d2 = this.fC[n2] * d4 + this.fB[n2];
            this.fA[n2] = (d4 - d2) / (6.0 * d3);
            this.fB[n2] = d2 / 2.0;
            this.fC[n2] = (this.fy[n2 + 1] - this.fy[n2]) / d3 - d3 * (this.fB[n2] + d3 * this.fA[n2]);
            d4 = d2;
        }
    }

    public double getValue(double d2) {
        int n2;
        if (this.fnPoints < 2) {
            return 0.0;
        }
        int n3 = 0;
        int n4 = this.fnPoints - 1;
        while (n3 + 1 < n4) {
            n2 = n3 + n4 >> 1;
            if (this.fx[n2] <= d2) {
                n3 = n2;
                continue;
            }
            n4 = n2;
        }
        n2 = n3;
        double d3 = d2 - this.fx[n2];
        double d4 = d3 * d3;
        double d5 = d4 * d3;
        return this.fy[n2] + this.fA[n2] * d5 + this.fB[n2] * d4 + this.fC[n2] * d3;
    }

    public void printCoefficients() {
        for (int i2 = 0; i2 < this.fnPoints - 1; ++i2) {
            System.out.println("(x,y)[" + i2 + "] = (" + this.fx[i2] + "," + this.fy[i2] + ")");
            System.out.println("(a,b,c) = (" + this.fA[i2] + "," + this.fB[i2] + "," + this.fC[i2] + ")");
        }
    }

    private void SetupBoundaryConditions() {
        this.fBoundCond1[0] = 0.0;
        this.fBoundCond1[1] = 0.0;
        this.fBoundCondN[0] = 0.0;
        this.fBoundCondN[1] = 0.0;
    }

    public String toString() {
        return "Spline-" + this.fnPoints + "-points";
    }
}

