/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePerformanceMeter
extends Region {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplePerformanceMeter.class);
    private static final int MIN_UPDATE_PERIOD = 40;
    private static final int MAX_UPDATE_PERIOD = 10000;
    private static final OperatingSystemMXBean OS_BEAN = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private static final int N_CORES = OS_BEAN.getAvailableProcessors();
    private final DoubleProperty averageFactor = new SimpleDoubleProperty((Object)this, "averageFactor", 0.01);
    private final DoubleProperty pulseRate = new SimpleDoubleProperty((Object)this, "pulseRate", 0.0);
    private final DoubleProperty pulseRateAvg = new SimpleDoubleProperty((Object)this, "pulseRateAvg", 0.0);
    private final DoubleProperty trackerFrameRate = new SimpleDoubleProperty((Object)this, "trackerFrameRate", 0.0);
    private final DoubleProperty avgTrackerFrameRate = new SimpleDoubleProperty((Object)this, "avgTrackerFrameRate", 0.0);
    private final DoubleProperty processCpuLoad = new SimpleDoubleProperty((Object)this, "processCpuLoad", 0.0);
    private final DoubleProperty avgProcessCpuLoad = new SimpleDoubleProperty((Object)this, "avgProcessCpuLoad", -1.0);
    private final DoubleProperty systemCpuLoad = new SimpleDoubleProperty((Object)this, "systemCpuLoad", 0.0);
    private final DoubleProperty avgSystemCpuLoad = new SimpleDoubleProperty((Object)this, "avgSystemCpuLoad", -1.0);
    private double pulseRateInternal;
    private double pulseRateAvgInternal = -1.0;
    private double frameRateInternal;
    private double frameRateAvgInternal = -1.0;
    private double cpuLoadProcessInternal;
    private double cpuLoadProcessAvgInternal;
    private double cpuLoadSystemInternal;
    private double cpuLoadSystemAvgInternal = -1.0;
    private final Method isCleanMethod;
    private final Field dirtyNodesSize;
    private final long updateDuration;
    private Timer timer;
    private final AnimationTimer animationTimer;
    private long timerIterationLast = System.currentTimeMillis();
    private final AtomicInteger pulseCounter = new AtomicInteger(0);
    private final AtomicInteger frameCounter = new AtomicInteger(0);
    private final Runnable pulseListener = () -> {
        if (this.isSceneDirty()) {
            this.frameCounter.getAndIncrement();
        }
    };

    public SimplePerformanceMeter(long l2) {
        this.updateDuration = Math.max(40L, Math.min(l2, 10000L));
        this.animationTimer = new AnimationTimer(){

            public void handle(long l2) {
                SimplePerformanceMeter.this.pulseCounter.getAndIncrement();
                SimplePerformanceMeter.this.updateProperties();
            }
        };
        Method method = null;
        Field field = null;
        try {
            method = Node.class.getDeclaredMethod("isDirtyEmpty", new Class[0]);
            method.setAccessible(true);
            field = Scene.class.getDeclaredField("dirtyNodesSize");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException | SecurityException exception) {
            LOGGER.atError().setCause(exception).log("cannot access scene root's dirtyBits field");
        }
        this.isCleanMethod = method;
        this.dirtyNodesSize = field;
        this.setManaged(false);
        this.setVisible(false);
        this.sceneProperty().addListener((observableValue, scene, scene2) -> {
            if (scene != null) {
                this.deregisterListener((Scene)scene);
            }
            if (scene2 != null) {
                this.registerListener((Scene)scene2);
            }
        });
    }

    public ReadOnlyDoubleProperty actualFrameRateProperty() {
        return this.trackerFrameRate;
    }

    public DoubleProperty averageFactorProperty() {
        return this.averageFactor;
    }

    public ReadOnlyDoubleProperty averageFrameRateProperty() {
        return this.avgTrackerFrameRate;
    }

    public ReadOnlyDoubleProperty averageFxFrameRateProperty() {
        return this.pulseRateAvg;
    }

    public ReadOnlyDoubleProperty averageProcessCpuLoadProperty() {
        return this.avgProcessCpuLoad;
    }

    public ReadOnlyDoubleProperty averageSystemCpuLoadProperty() {
        return this.avgSystemCpuLoad;
    }

    public void deregisterListener(Scene scene) {
        this.animationTimer.stop();
        scene.removePostLayoutPulseListener(this.pulseListener);
        this.timer.cancel();
    }

    public ReadOnlyDoubleProperty fxFrameRateProperty() {
        return this.pulseRate;
    }

    public double getActualFrameRate() {
        return this.actualFrameRateProperty().get();
    }

    public double getAverageFrameRate() {
        return this.averageFrameRateProperty().get();
    }

    public double getAverageFxFrameRate() {
        return this.averageFxFrameRateProperty().get();
    }

    public double getAverageProcessCpuLoad() {
        return this.averageProcessCpuLoadProperty().get();
    }

    public double getAverageSystemCpuLoad() {
        return this.averageSystemCpuLoadProperty().get();
    }

    public double getFxFrameRate() {
        return this.fxFrameRateProperty().get();
    }

    public double getProcessCpuLoad() {
        return this.processCpuLoadProperty().get();
    }

    public double getSystemCpuLoad() {
        return this.systemCpuLoadProperty().get();
    }

    public ReadOnlyDoubleProperty processCpuLoadProperty() {
        return this.processCpuLoad;
    }

    public void registerListener(Scene scene) {
        this.animationTimer.start();
        this.timer = new Timer("SimplePerformanceMeter-timer", true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                long l2 = System.currentTimeMillis();
                int n2 = SimplePerformanceMeter.this.pulseCounter.getAndSet(0);
                int n3 = SimplePerformanceMeter.this.frameCounter.getAndSet(0);
                double d2 = (double)(l2 - SimplePerformanceMeter.this.timerIterationLast) * 0.001;
                SimplePerformanceMeter.this.timerIterationLast = l2;
                SimplePerformanceMeter.this.pulseRateInternal = d2 > 0.0 ? (double)n2 / d2 : -1.0;
                SimplePerformanceMeter.this.frameRateInternal = d2 > 0.0 ? (double)n3 / d2 : -1.0;
                SimplePerformanceMeter.this.cpuLoadProcessInternal = OS_BEAN.getProcessCpuLoad() * 100.0 * (double)N_CORES;
                SimplePerformanceMeter.this.cpuLoadSystemInternal = OS_BEAN.getSystemCpuLoad() * 100.0 * (double)N_CORES;
                double d3 = SimplePerformanceMeter.this.averageFactor.get();
                SimplePerformanceMeter.this.pulseRateAvgInternal = SimplePerformanceMeter.computeAverage(SimplePerformanceMeter.this.pulseRateInternal, SimplePerformanceMeter.this.pulseRateAvgInternal, d3);
                SimplePerformanceMeter.this.frameRateAvgInternal = SimplePerformanceMeter.computeAverage(SimplePerformanceMeter.this.frameRateInternal, SimplePerformanceMeter.this.frameRateAvgInternal, d3);
                SimplePerformanceMeter.this.cpuLoadProcessAvgInternal = SimplePerformanceMeter.computeAverage(SimplePerformanceMeter.this.cpuLoadProcessInternal, SimplePerformanceMeter.this.cpuLoadProcessAvgInternal, d3);
                SimplePerformanceMeter.this.cpuLoadSystemAvgInternal = SimplePerformanceMeter.computeAverage(SimplePerformanceMeter.this.cpuLoadSystemInternal, SimplePerformanceMeter.this.cpuLoadSystemAvgInternal, d3);
            }
        }, 0L, this.updateDuration);
        scene.addPostLayoutPulseListener(this.pulseListener);
    }

    public void resetAverages() {
        this.pulseRateInternal = -1.0;
        this.pulseRateAvgInternal = -1.0;
        this.frameRateInternal = -1.0;
        this.frameRateAvgInternal = -1.0;
        this.cpuLoadProcessInternal = -1.0;
        this.cpuLoadProcessAvgInternal = -1.0;
        this.cpuLoadSystemInternal = -1.0;
        this.cpuLoadSystemAvgInternal = -1.0;
    }

    public ReadOnlyDoubleProperty systemCpuLoadProperty() {
        return this.systemCpuLoad;
    }

    private void updateProperties() {
        this.pulseRate.set(this.pulseRateInternal);
        this.pulseRateAvg.set(this.pulseRateAvgInternal);
        this.trackerFrameRate.set(this.frameRateInternal);
        this.avgTrackerFrameRate.set(this.frameRateAvgInternal);
        this.processCpuLoad.set(this.cpuLoadProcessInternal);
        this.avgProcessCpuLoad.set(this.cpuLoadProcessAvgInternal);
        this.systemCpuLoad.set(this.cpuLoadSystemInternal);
        this.avgSystemCpuLoad.set(this.cpuLoadSystemAvgInternal);
    }

    public boolean isSceneDirty() {
        if (this.getScene().getRoot() == null) {
            return false;
        }
        try {
            return this.isDirty(this.getScene()) || this.isDirty((Node)this.getScene().getRoot());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            LOGGER.atError().setCause(exception).log("cannot access scene root's dirtyBits field");
            return true;
        }
    }

    private boolean isDirty(Scene scene) throws IllegalAccessException {
        return this.dirtyNodesSize.getInt(scene) != 0;
    }

    private boolean isDirty(Node node) throws InvocationTargetException, IllegalAccessException {
        return (Boolean)this.isCleanMethod.invoke((Object)node, new Object[0]) == false;
    }

    protected static double computeAverage(double d2, double d3, double d4) {
        if (d3 < 0.0) {
            return d2;
        }
        return (1.0 - d4) * d3 + d4 * d2;
    }

    public static double getProcessCpuLoadInternal() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList attributeList = mBeanServer.getAttributes(objectName, new String[]{"ProcessCpuLoad"});
            if (attributeList.isEmpty()) {
                return Double.NaN;
            }
            Attribute attribute = (Attribute)attributeList.get(0);
            Double d2 = (Double)attribute.getValue();
            if (d2 == -1.0) {
                return Double.NaN;
            }
            return (double)((int)(d2 * 1000.0)) / 10.0;
        }
        catch (NullPointerException | InstanceNotFoundException | MalformedObjectNameException | ReflectionException exception) {
            return Double.NaN;
        }
    }
}

