/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui.css;

import io.fair_acc.dataset.utils.StyleBuilder;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.scene.paint.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStyleParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStyleParser.class);
    boolean usedAtLeastOneKey = false;
    private String currentKey;

    public boolean tryParse(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        return this.parse(string);
    }

    protected boolean parse(String string) {
        this.clear();
        this.currentKey = null;
        this.usedAtLeastOneKey = false;
        StyleBuilder.forEachProperty(string, this::onEntry);
        return this.usedAtLeastOneKey;
    }

    private void onEntry(String string, String string2) {
        this.currentKey = string;
        this.usedAtLeastOneKey |= this.parseEntry(string, string2);
    }

    protected abstract void clear();

    protected abstract boolean parseEntry(String var1, String var2);

    protected double parseDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.error("could not parse double value of \"" + this.currentKey + ": " + string + ";\"", numberFormatException);
            return Double.NaN;
        }
    }

    protected double[] parseDoubleArray(String string) {
        return this.parse(string, string3 -> Arrays.stream(string.split("[\\s+|,?]")).filter(string -> !string.isBlank()).mapToDouble(Double::parseDouble).toArray());
    }

    protected Color parseColor(String string) {
        try {
            return Color.web((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error("could not parse color value of \"" + this.currentKey + ": " + string + ";\"", illegalArgumentException);
            return null;
        }
    }

    protected boolean parseColor(String string, Consumer<Color> consumer) {
        Color color = this.parseColor(string);
        if (this.isValid(color)) {
            consumer.accept(color);
            return true;
        }
        return false;
    }

    protected <T> T parse(String string, Function<String, T> function) {
        try {
            return function.apply(string);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("could not parse value of \"" + this.currentKey + ": " + string + ";\"", runtimeException);
            return null;
        }
    }

    protected boolean isValid(Object object) {
        return object != null;
    }

    protected boolean isValid(double d2) {
        return !Double.isNaN(d2);
    }

    protected <T> Optional<T> optional(T t2) {
        return Optional.ofNullable(t2);
    }

    protected OptionalDouble optional(double d2) {
        return this.isValid(d2) ? OptionalDouble.of(d2) : OptionalDouble.empty();
    }
}

