/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui;

import io.fair_acc.chartfx.ui.HiddenSidesPane;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class HiddenSidesPaneSkin
extends SkinBase<HiddenSidesPane> {
    private final StackPane stackPane;
    private final EventHandler<MouseEvent> exitedHandler;
    private boolean mousePressed;
    private final DoubleProperty[] visibility = new SimpleDoubleProperty[Side.values().length];
    private Timeline showTimeline;
    private Timeline hideTimeline;
    private Node lastHideBlockingNode = null;
    private long blockedSince = 0L;

    public HiddenSidesPaneSkin(HiddenSidesPane hiddenSidesPane) {
        super((Control)hiddenSidesPane);
        this.exitedHandler = mouseEvent -> {
            if (this.isMouseEnabled() && ((HiddenSidesPane)this.getSkinnable()).getPinnedSide() == null && !this.mousePressed) {
                this.hide();
            }
        };
        this.stackPane = new StackPane();
        this.stackPane.setId("HiddenSidesPaneSkin::StackPane");
        this.getChildren().add((Object)this.stackPane);
        this.updateStackPane();
        InvalidationListener invalidationListener = observable -> this.updateStackPane();
        hiddenSidesPane.contentProperty().addListener(invalidationListener);
        hiddenSidesPane.topProperty().addListener(invalidationListener);
        hiddenSidesPane.rightProperty().addListener(invalidationListener);
        hiddenSidesPane.bottomProperty().addListener(invalidationListener);
        hiddenSidesPane.leftProperty().addListener(invalidationListener);
        hiddenSidesPane.addEventFilter(MouseEvent.MOUSE_MOVED, mouseEvent -> {
            if (this.isMouseEnabled() && ((HiddenSidesPane)this.getSkinnable()).getPinnedSide() == null) {
                Side side = this.getSide((MouseEvent)mouseEvent);
                if (side == null) {
                    if (this.isMouseMovedOutsideSides((MouseEvent)mouseEvent)) {
                        this.hide();
                    }
                } else {
                    this.show(side);
                }
            }
        });
        hiddenSidesPane.addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        hiddenSidesPane.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            this.mousePressed = true;
        });
        hiddenSidesPane.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            this.mousePressed = false;
            if (this.isMouseEnabled() && ((HiddenSidesPane)this.getSkinnable()).getPinnedSide() == null) {
                Side side = this.getSide((MouseEvent)mouseEvent);
                if (side == null) {
                    this.hide();
                } else {
                    this.show(side);
                }
            }
        });
        for (Side side : Side.values()) {
            this.visibility[side.ordinal()] = new SimpleDoubleProperty(0.0);
            this.visibility[side.ordinal()].addListener(observable -> ((HiddenSidesPane)this.getSkinnable()).requestLayout());
        }
        Side side = ((HiddenSidesPane)this.getSkinnable()).getPinnedSide();
        if (side != null) {
            this.show(side);
        }
        hiddenSidesPane.pinnedSideProperty().addListener(observable -> this.show(((HiddenSidesPane)this.getSkinnable()).getPinnedSide()));
        Rectangle rectangle = new Rectangle();
        rectangle.setX(0.0);
        rectangle.setY(0.0);
        rectangle.widthProperty().bind((ObservableValue)((HiddenSidesPane)this.getSkinnable()).widthProperty());
        rectangle.heightProperty().bind((ObservableValue)((HiddenSidesPane)this.getSkinnable()).heightProperty());
        ((HiddenSidesPane)this.getSkinnable()).setClip((Node)rectangle);
    }

    private double getPrefAlignmentH(Node node, double d2) {
        Pos pos = StackPane.getAlignment((Node)node);
        if (pos == null) {
            return 0.0;
        }
        switch (pos.getHpos()) {
            case RIGHT: {
                return d2 - node.getLayoutBounds().getWidth();
            }
            case CENTER: {
                return 0.5 * (d2 - node.getLayoutBounds().getWidth());
            }
        }
        return 0.0;
    }

    private double getPrefAlignmentV(Node node, double d2) {
        Pos pos = StackPane.getAlignment((Node)node);
        if (pos == null) {
            return 0.0;
        }
        switch (pos.getVpos()) {
            case BOTTOM: {
                return d2 - node.getLayoutBounds().getHeight();
            }
            case CENTER: {
                return 0.5 * (d2 - node.getLayoutBounds().getHeight());
            }
        }
        return 0.0;
    }

    private Side getSide(MouseEvent mouseEvent) {
        if (this.stackPane.getBoundsInLocal().contains(mouseEvent.getX(), mouseEvent.getY())) {
            double d2 = ((HiddenSidesPane)this.getSkinnable()).getTriggerDistance();
            if (mouseEvent.getX() <= d2 && ((HiddenSidesPane)this.getSkinnable()).getLeft() != null) {
                return Side.LEFT;
            }
            if (mouseEvent.getX() > ((HiddenSidesPane)this.getSkinnable()).getWidth() - d2 && ((HiddenSidesPane)this.getSkinnable()).getRight() != null) {
                return Side.RIGHT;
            }
            if (mouseEvent.getY() <= d2 && ((HiddenSidesPane)this.getSkinnable()).getTop() != null) {
                return Side.TOP;
            }
            if (mouseEvent.getY() > ((HiddenSidesPane)this.getSkinnable()).getHeight() - d2 && ((HiddenSidesPane)this.getSkinnable()).getBottom() != null) {
                return Side.BOTTOM;
            }
        }
        return null;
    }

    private boolean hasShowingChild(Node node) {
        if (node == null) {
            return false;
        }
        if (node.isHover()) {
            this.lastHideBlockingNode = node;
            return true;
        }
        try {
            Method method = HiddenSidesPaneSkin.getMethod(node.getClass(), "isShowing");
            if (method != null && ((Boolean)method.invoke((Object)node, new Object[0])).booleanValue()) {
                this.lastHideBlockingNode = node;
                return true;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        if (node instanceof Parent) {
            return ((Parent)node).getChildrenUnmodifiable().stream().anyMatch(this::hasShowingChild);
        }
        return false;
    }

    private void hide() {
        if (this.showTimeline != null) {
            this.showTimeline.stop();
        }
        if (this.hideTimeline != null && this.hideTimeline.getStatus() == Animation.Status.RUNNING) {
            return;
        }
        Side side = null;
        Object object = Side.values();
        int n2 = ((Side[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Side side2 = object[i2];
            if (!(this.visibility[side2.ordinal()].get() > 0.0)) continue;
            side = side2;
            break;
        }
        if (side == null) {
            return;
        }
        if (this.hasShowingChild(this.lastHideBlockingNode) || this.hasShowingChild(this.getSidePane(side))) {
            long l2 = System.currentTimeMillis();
            if (this.blockedSince == 0L) {
                this.blockedSince = l2;
            }
            if ((double)(l2 - this.blockedSince) < ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay().toMillis()) {
                return;
            }
        }
        this.blockedSince = 0L;
        if (this.hasShowingChild(this.lastHideBlockingNode) && (object = HiddenSidesPaneSkin.getMethod(this.lastHideBlockingNode.getClass(), "hide")) != null) {
            try {
                ((Method)object).invoke((Object)this.lastHideBlockingNode, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        object = new KeyValue[Side.values().length];
        for (Side side3 : Side.values()) {
            object[side3.ordinal()] = new KeyValue((WritableValue)this.visibility[side3.ordinal()], (Object)0);
        }
        Duration duration = ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay() == null ? Duration.millis((double)300.0) : ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay();
        Duration duration2 = ((HiddenSidesPane)this.getSkinnable()).getAnimationDuration() == null ? Duration.millis((double)300.0) : ((HiddenSidesPane)this.getSkinnable()).getAnimationDuration();
        KeyFrame keyFrame = new KeyFrame(duration2, (KeyValue[])object);
        this.hideTimeline = new Timeline(new KeyFrame[]{keyFrame});
        this.hideTimeline.setDelay(duration);
        this.hideTimeline.play();
    }

    private boolean isMouseEnabled() {
        return ((HiddenSidesPane)this.getSkinnable()).getTriggerDistance() > 0.0;
    }

    private boolean isMouseMovedOutsideSides(MouseEvent mouseEvent) {
        return !(((HiddenSidesPane)this.getSkinnable()).getLeft() != null && ((HiddenSidesPane)this.getSkinnable()).getLeft().getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY()) || ((HiddenSidesPane)this.getSkinnable()).getTop() != null && ((HiddenSidesPane)this.getSkinnable()).getTop().getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY()) || ((HiddenSidesPane)this.getSkinnable()).getRight() != null && ((HiddenSidesPane)this.getSkinnable()).getRight().getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY()) || ((HiddenSidesPane)this.getSkinnable()).getBottom() != null && ((HiddenSidesPane)this.getSkinnable()).getBottom().getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY()));
    }

    private void show(Side side) {
        if (this.hideTimeline != null) {
            this.hideTimeline.stop();
        }
        if (this.showTimeline != null && this.showTimeline.getStatus() == Animation.Status.RUNNING) {
            return;
        }
        KeyValue[] keyValueArray = new KeyValue[Side.values().length];
        for (Side side2 : Side.values()) {
            keyValueArray[side2.ordinal()] = new KeyValue((WritableValue)this.visibility[side2.ordinal()], (Object)(side2.equals((Object)side) ? 1 : 0));
        }
        Duration duration = ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay() == null ? Duration.millis((double)300.0) : ((HiddenSidesPane)this.getSkinnable()).getAnimationDelay();
        Duration duration2 = ((HiddenSidesPane)this.getSkinnable()).getAnimationDuration() == null ? Duration.millis((double)200.0) : ((HiddenSidesPane)this.getSkinnable()).getAnimationDuration();
        KeyFrame keyFrame = new KeyFrame(duration2, keyValueArray);
        this.showTimeline = new Timeline(new KeyFrame[]{keyFrame});
        this.showTimeline.setDelay(duration);
        this.showTimeline.play();
    }

    private void updateStackPane() {
        this.stackPane.getChildren().clear();
        if (((HiddenSidesPane)this.getSkinnable()).getContent() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getContent());
        }
        if (((HiddenSidesPane)this.getSkinnable()).getTop() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getTop());
            ((HiddenSidesPane)this.getSkinnable()).getTop().setManaged(false);
            ((HiddenSidesPane)this.getSkinnable()).getTop().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((HiddenSidesPane)this.getSkinnable()).getTop().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((HiddenSidesPane)this.getSkinnable()).getRight() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getRight());
            ((HiddenSidesPane)this.getSkinnable()).getRight().setManaged(false);
            ((HiddenSidesPane)this.getSkinnable()).getRight().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((HiddenSidesPane)this.getSkinnable()).getRight().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((HiddenSidesPane)this.getSkinnable()).getBottom() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getBottom());
            ((HiddenSidesPane)this.getSkinnable()).getBottom().setManaged(false);
            ((HiddenSidesPane)this.getSkinnable()).getBottom().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((HiddenSidesPane)this.getSkinnable()).getBottom().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
        if (((HiddenSidesPane)this.getSkinnable()).getLeft() != null) {
            this.stackPane.getChildren().add((Object)((HiddenSidesPane)this.getSkinnable()).getLeft());
            ((HiddenSidesPane)this.getSkinnable()).getLeft().setManaged(false);
            ((HiddenSidesPane)this.getSkinnable()).getLeft().removeEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
            ((HiddenSidesPane)this.getSkinnable()).getLeft().addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedHandler);
        }
    }

    protected Node getSidePane(Side side) {
        if (this.getSkinnable() == null) {
            return null;
        }
        switch (side) {
            case BOTTOM: {
                return ((HiddenSidesPane)this.getSkinnable()).getBottom();
            }
            case LEFT: {
                return ((HiddenSidesPane)this.getSkinnable()).getLeft();
            }
            case RIGHT: {
                return ((HiddenSidesPane)this.getSkinnable()).getRight();
            }
            case TOP: {
                return ((HiddenSidesPane)this.getSkinnable()).getTop();
            }
        }
        return null;
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        Node node;
        Node node2;
        double d6;
        double d7;
        Node node3;
        double d8;
        double d9;
        Node node4;
        super.layoutChildren(d2, d3, d4, d5);
        if (((HiddenSidesPane)this.getSkinnable()).getContent() != null) {
            ((HiddenSidesPane)this.getSkinnable()).getContent().resizeRelocate(d2, d3, d4, d5);
        }
        if ((node4 = ((HiddenSidesPane)this.getSkinnable()).getBottom()) != null) {
            double d10 = node4.prefHeight(-1.0);
            d9 = d10 * this.visibility[Side.BOTTOM.ordinal()].get();
            d8 = this.getPrefAlignmentH(node4, d4);
            node4.resizeRelocate(d2 + d8, d3 + d5 - d9, d4, d10);
            node4.setVisible(this.visibility[Side.BOTTOM.ordinal()].get() > 0.0);
        }
        if ((node3 = ((HiddenSidesPane)this.getSkinnable()).getLeft()) != null) {
            double d11 = node3.prefWidth(-1.0);
            d7 = d11 * this.visibility[Side.LEFT.ordinal()].get();
            d6 = this.getPrefAlignmentV(node3, d5);
            node3.resizeRelocate(d2 - (d11 - d7), d3 + d6, d11, d5);
            node3.setVisible(this.visibility[Side.LEFT.ordinal()].get() > 0.0);
        }
        if ((node2 = ((HiddenSidesPane)this.getSkinnable()).getRight()) != null) {
            d9 = node2.prefWidth(-1.0);
            d8 = d9 * this.visibility[Side.RIGHT.ordinal()].get();
            double d12 = this.getPrefAlignmentV(node2, d5);
            node2.resizeRelocate(d2 + d4 - d8, d3 + d12, d9, d5);
            node2.setVisible(this.visibility[Side.RIGHT.ordinal()].get() > 0.0);
        }
        if ((node = ((HiddenSidesPane)this.getSkinnable()).getTop()) != null) {
            d7 = node.prefHeight(-1.0);
            d6 = d7 * this.visibility[Side.TOP.ordinal()].get();
            double d13 = this.getPrefAlignmentH(node, d4);
            node.resizeRelocate(d2 + d13, d3 - (d7 - d6), d4, d7);
            node.setVisible(this.visibility[Side.TOP.ordinal()].get() > 0.0);
        }
    }

    public static Method getMethod(Class<?> clazz, String string) {
        try {
            return clazz.getMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return null;
        }
    }
}

