/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi.financial;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.renderer.spi.AbstractRendererXY;
import io.fair_acc.chartfx.renderer.spi.financial.FinancialDataSetNode;
import io.fair_acc.chartfx.renderer.spi.financial.service.OhlcvRendererEpData;
import io.fair_acc.chartfx.renderer.spi.financial.service.PaintBarMarker;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.css.StyleUtil;
import io.fair_acc.dataset.DataSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Paint;

public abstract class AbstractFinancialRenderer<R extends AbstractRendererXY<R>>
extends AbstractRendererXY<R>
implements Renderer {
    protected PaintBarMarker paintBarMarker;
    private final BooleanProperty computeLocalYRange = new SimpleBooleanProperty((Object)this, "computeLocalYRange", true);

    protected AbstractFinancialRenderer() {
        StyleUtil.addStyles(this, "financial");
    }

    @Override
    protected FinancialDataSetNode createNode(DataSet dataSet) {
        for (DataSetNode dataSetNode : this.getDatasetNodes()) {
            if (dataSetNode.getDataSet() != dataSet) continue;
            return (FinancialDataSetNode)dataSetNode;
        }
        return new FinancialDataSetNode(this, dataSet);
    }

    @Override
    public FinancialDataSetNode getStyleableNode(DataSet dataSet) {
        return (FinancialDataSetNode)super.getStyleableNode(dataSet);
    }

    @Override
    public FinancialDataSetNode addDataSet(DataSet dataSet) {
        return (FinancialDataSetNode)super.addDataSet(dataSet);
    }

    public BooleanProperty computeLocalRangeProperty() {
        return this.computeLocalYRange;
    }

    public boolean computeLocalRange() {
        return this.computeLocalRangeProperty().get();
    }

    public void setComputeLocalRange(boolean bl2) {
        this.computeLocalRangeProperty().set(bl2);
    }

    public void setPaintBarMarker(PaintBarMarker paintBarMarker) {
        this.paintBarMarker = paintBarMarker;
    }

    protected double[] findAreaDistances(FindAreaDistances findAreaDistances, DataSet dataSet, Axis axis, Axis axis2, double d2, double d3) {
        return findAreaDistances.findAreaDistances(dataSet, axis, axis2, d2, d3);
    }

    protected Paint getPaintBarColor(OhlcvRendererEpData ohlcvRendererEpData) {
        if (this.paintBarMarker != null && ohlcvRendererEpData != null) {
            return this.paintBarMarker.getPaintBy(ohlcvRendererEpData);
        }
        return null;
    }

    protected void paintVolume(GraphicsContext graphicsContext, DataSet dataSet, int n2, Paint paint, Paint paint2, Axis axis, double[] dArray, double d2, double d3, double d4) {
        double d5 = dataSet.get(5, n2);
        double d6 = dataSet.get(1, n2);
        double d7 = dataSet.get(4, n2);
        double d8 = dArray[1];
        double d9 = d5 / d8 * 0.3;
        double d10 = axis.getDisplayPosition(axis.getMin());
        double d11 = axis.getDisplayPosition(axis.getMax());
        double d12 = d9 * (d11 - d10);
        graphicsContext.setFill(d6 < d7 ? paint : paint2);
        graphicsContext.fillRect(d4 - d3, d10 + d12, d2, -d12);
    }

    protected void applyLocalYRange(DataSet dataSet, Axis axis, double d2, double d3) {
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MIN_VALUE;
        for (int i2 = dataSet.getIndex(0, d2) + 1; i2 < Math.min(dataSet.getIndex(0, d3) + 1, dataSet.getDataCount()); ++i2) {
            double d6 = dataSet.get(3, i2);
            double d7 = dataSet.get(2, i2);
            if (d4 > d6) {
                d4 = d6;
            }
            if (!(d5 < d7)) continue;
            d5 = d7;
        }
        double d8 = (d5 - d4) * 0.05;
        axis.set(d4 - d8, d5 + d8);
    }

    protected static Double getMostPopularElement(List<Double> list) {
        Double d2;
        int n2 = 0;
        int n3 = -1;
        Double d3 = d2 = list.get(0);
        for (Double d4 : list) {
            if (Math.abs(d2 - d4) < 1.0E-10) {
                ++n2;
                continue;
            }
            if (n2 > n3) {
                n3 = n2;
                d3 = d2;
            }
            n2 = 0;
            d2 = d4;
        }
        if (n2 > n3) {
            d3 = d2;
        }
        return d3;
    }

    @FunctionalInterface
    protected static interface FindAreaDistances {
        public double[] findAreaDistances(DataSet var1, Axis var2, Axis var3, double var4, double var6);
    }

    protected static class XMinVolumeMaxAreaDistances
    implements FindAreaDistances {
        protected XMinVolumeMaxAreaDistances() {
        }

        @Override
        public double[] findAreaDistances(DataSet dataSet, Axis axis, Axis axis2, double d2, double d3) {
            double[] dArray = new XMinAreaDistances().findAreaDistances(dataSet, axis, axis2, d2, d3);
            double d4 = Double.MIN_VALUE;
            int n2 = dataSet.getIndex(0, d2) + 1;
            int n3 = Math.min(dataSet.getIndex(0, d3) + 1, dataSet.getDataCount());
            for (int i2 = n2; i2 < n3; ++i2) {
                double d5 = dataSet.get(5, i2);
                if (!(d4 < d5)) continue;
                d4 = d5;
            }
            return new double[]{dArray[0], d4};
        }
    }

    protected static class XMinAreaDistances
    implements FindAreaDistances {
        protected XMinAreaDistances() {
        }

        @Override
        public double[] findAreaDistances(DataSet dataSet, Axis axis, Axis axis2, double d2, double d3) {
            int n2 = dataSet.getIndex(0, d2) + 1;
            int n3 = Math.min(dataSet.getIndex(0, d3) + 1, dataSet.getDataCount());
            int n4 = n3 - n2;
            int n5 = n4 > 30 ? (int)Math.round(Math.floor((double)n4 / 30.0)) : 1;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (int i2 = n2; i2 < n3; i2 += n5) {
                double d4;
                double d5 = axis.getDisplayPosition(dataSet.get(0, i2 - 1));
                if (d5 == (d4 = axis.getDisplayPosition(dataSet.get(0, i2)))) continue;
                arrayList.add(Math.abs(d4 - d5));
            }
            double d6 = 0.0;
            if (!arrayList.isEmpty()) {
                Collections.sort(arrayList);
                d6 = AbstractFinancialRenderer.getMostPopularElement(arrayList);
            }
            return new double[]{d6};
        }
    }
}

