/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer;

import io.fair_acc.bench.Measurable;
import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.dataset.DataSet;
import javafx.beans.property.BooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;

public interface Renderer
extends Measurable.EmptyDefault {
    default public boolean drawLegendSymbol(DataSetNode dataSetNode, Canvas canvas) {
        boolean bl2 = true;
        double d2 = canvas.getWidth() - 2.0;
        double d3 = canvas.getHeight() / 2.0;
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.save();
        graphicsContext.setLineWidth(dataSetNode.getLineWidth());
        graphicsContext.setLineDashes(dataSetNode.getLineDashes());
        graphicsContext.setStroke(dataSetNode.getLineColor());
        graphicsContext.strokeLine((double)bl2, d3, d2, d3);
        graphicsContext.restore();
        return true;
    }

    public ObservableList<Axis> getAxes();

    public ObservableList<DataSet> getDatasets();

    public ObservableList<DataSetNode> getDatasetNodes();

    default public DataSetNode getStyleableNode(DataSet dataSet) {
        for (DataSetNode dataSetNode : this.getDatasetNodes()) {
            if (dataSetNode.getDataSet() != dataSet) continue;
            return dataSetNode;
        }
        throw new IllegalArgumentException("dataset does not have a styleable node");
    }

    default public DataSetNode addDataSet(DataSet dataSet) {
        this.getDatasets().add((Object)dataSet);
        return this.getStyleableNode(dataSet);
    }

    default public Renderer addDataSets(DataSet ... dataSetArray) {
        this.getDatasets().addAll((Object[])dataSetArray);
        return this;
    }

    default public Renderer addAxes(Axis ... axisArray) {
        this.getAxes().addAll((Object[])axisArray);
        return this;
    }

    default public void runPreLayout() {
    }

    default public void runPostLayout() {
    }

    default public void updateAxes() {
    }

    public void updateAxisRange(Axis var1, AxisRange var2);

    public void render();

    public Renderer setShowInLegend(boolean var1);

    public boolean showInLegend();

    public BooleanProperty showInLegendProperty();

    public void setGlobalIndexOffset(int var1);

    public int getGlobalIndexOffset();

    default public void setChart(Chart chart) {
    }

    default public Node getNode() {
        return null;
    }
}

