/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.renderer.spi.utils.ColorGradient;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class ColormapSelector
extends ChartPlugin {
    private final BooleanProperty showInToolbar = new SimpleBooleanProperty((Object)this, "show in toolbar", true);
    private final ComboBox<ColorGradient> dropdown = new ColormapComboBox();

    public ColormapSelector() {
        this.chartProperty().addListener((observableValue, chart, chart2) -> {
            if (chart != null) {
                chart.getToolBar().getChildren().remove(this.dropdown);
            }
            if (chart2 != null && this.isShowInToolbar()) {
                chart2.getToolBar().getChildren().add(this.dropdown);
            }
        });
        this.showInToolbar.addListener((observableValue, bl2, bl3) -> {
            if (Boolean.TRUE.equals(bl3)) {
                this.getChart().getToolBar().getChildren().add(this.dropdown);
            } else {
                this.getChart().getToolBar().getChildren().remove(this.dropdown);
            }
        });
    }

    public ObjectProperty<ColorGradient> colormapProperty() {
        return this.dropdown.valueProperty();
    }

    public ColorGradient getColormap() {
        return (ColorGradient)this.dropdown.getValue();
    }

    public ObservableList<ColorGradient> getGradientsList() {
        return this.dropdown.getItems();
    }

    public boolean isShowInToolbar() {
        return this.showInToolbar.get();
    }

    public void setColormap(ColorGradient colorGradient) {
        if (!this.getGradientsList().contains((Object)colorGradient)) {
            this.getGradientsList().add((Object)colorGradient);
        }
        this.dropdown.setValue((Object)colorGradient);
    }

    public void setShowInToolbar(boolean bl2) {
        this.showInToolbar.set(bl2);
    }

    public BooleanProperty showInToolbarProperty() {
        return this.showInToolbar;
    }

    public static class ColormapComboBox
    extends ComboBox<ColorGradient> {
        public ColormapComboBox() {
            this.setCellFactory(listView -> new ColormapListCell());
            this.setButtonCell(new ColormapListCell());
            this.getItems().addAll(ColorGradient.colorGradients());
            this.setValue(ColorGradient.DEFAULT);
        }
    }

    public static class ColormapListCell
    extends ListCell<ColorGradient> {
        private static final double COLORMAP_WIDTH = 30.0;
        private static final double COLORMAP_HEIGHT = 10.0;
        private final Rectangle rect = new Rectangle(30.0, 10.0);

        public ColormapListCell() {
            this.setContentDisplay(ContentDisplay.LEFT);
        }

        protected void updateItem(ColorGradient colorGradient, boolean bl2) {
            super.updateItem((Object)colorGradient, bl2);
            if (colorGradient == null || bl2) {
                this.setGraphic(null);
                this.setText("-");
            } else {
                this.rect.setFill((Paint)new LinearGradient(0.0, 0.0, 30.0, 0.0, false, CycleMethod.NO_CYCLE, colorGradient.getStops()));
                this.setGraphic((Node)this.rect);
                this.setText(colorGradient.toString());
            }
        }
    }
}

