/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.XYChart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.spi.MetricPrefix;
import io.fair_acc.chartfx.plugins.ChartPlugin;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.ui.geometry.Side;
import io.fair_acc.dataset.spi.utils.Tuple;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Orientation;
import javafx.util.StringConverter;

public abstract class AbstractDataFormattingPlugin
extends ChartPlugin {
    private final ObjectProperty<StringConverter<Number>> xValueFormatter = new SimpleObjectProperty((Object)this, "xValueFormatter");
    private final ObjectProperty<StringConverter<Number>> yValueFormatter = new SimpleObjectProperty((Object)this, "yValueFormatter");
    private StringConverter<Number> defaultXValueFormatter;
    private StringConverter<Number> defaultYValueFormatter;

    protected AbstractDataFormattingPlugin() {
        this.chartProperty().addListener((observableValue, chart, chart2) -> {
            if (chart2 != null) {
                if (!(chart2 instanceof XYChart)) {
                    throw new IllegalArgumentException("cannot use chart of type '" + chart2.getClass().getSimpleName() + "' for this plug-ing");
                }
                this.defaultXValueFormatter = AbstractDataFormattingPlugin.createDefaultFormatter(chart2.getFirstAxis(Orientation.HORIZONTAL));
                this.defaultYValueFormatter = AbstractDataFormattingPlugin.createDefaultFormatter(chart2.getFirstAxis(Orientation.VERTICAL));
            }
        });
    }

    public final StringConverter<Number> getXValueFormatter() {
        return (StringConverter)this.xValueFormatterProperty().get();
    }

    public final StringConverter<Number> getYValueFormatter() {
        return (StringConverter)this.yValueFormatterProperty().get();
    }

    public final void setXValueFormatter(StringConverter<Number> stringConverter) {
        this.xValueFormatterProperty().set(stringConverter);
    }

    public final void setYValueFormatter(StringConverter<Number> stringConverter) {
        this.yValueFormatterProperty().set(stringConverter);
    }

    public final ObjectProperty<StringConverter<Number>> xValueFormatterProperty() {
        return this.xValueFormatter;
    }

    public final ObjectProperty<StringConverter<Number>> yValueFormatterProperty() {
        return this.yValueFormatter;
    }

    private StringConverter<Number> getValueFormatter(Axis axis, StringConverter<Number> stringConverter, StringConverter<Number> stringConverter2) {
        StringConverter<Number> stringConverter3 = stringConverter;
        if (stringConverter3 == null) {
            stringConverter3 = axis.getTickLabelFormatter();
        }
        if (stringConverter3 == null) {
            stringConverter3 = stringConverter2;
        }
        return stringConverter3;
    }

    private StringConverter<Number> getXValueFormatter(Axis axis) {
        return this.getValueFormatter(axis, this.getXValueFormatter(), this.defaultXValueFormatter);
    }

    private StringConverter<Number> getYValueFormatter(Axis axis) {
        return this.getValueFormatter(axis, this.getYValueFormatter(), this.defaultYValueFormatter);
    }

    protected String formatData(Chart chart, Tuple<Number, Number> tuple) {
        if (chart.getAxes().size() == 2) {
            Axis axis = chart.getFirstAxis(Orientation.HORIZONTAL);
            Axis axis2 = chart.getFirstAxis(Orientation.VERTICAL);
            return this.getXValueFormatter(axis).toString((Object)tuple.getXValue()) + ", " + this.getYValueFormatter(axis2).toString((Object)tuple.getYValue());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Axis axis : chart.getAxes()) {
            Side side = axis.getSide();
            if (side == null) continue;
            String string = axis.getName();
            String string2 = axis.getUnit();
            String string3 = MetricPrefix.getShortPrefix(axis.getUnitScaling());
            boolean bl2 = axis.isAutoUnitScaling();
            if (bl2 && string2 == null) {
                string2 = " a.u.";
            }
            stringBuilder.append(string).append(" = ");
            stringBuilder.append(side.isHorizontal() ? this.getXValueFormatter(axis).toString((Object)tuple.getXValue()) : this.getYValueFormatter(axis).toString((Object)tuple.getYValue()));
            if (string2 != null) {
                stringBuilder.append(string).append(" [").append(string3).append(string2).append(']');
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    protected String formatData(Renderer renderer, Tuple<Number, Number> tuple) {
        if (renderer.getAxes().size() == 2) {
            Axis axis2 = renderer.getAxes().stream().filter(axis -> axis.getSide().isHorizontal()).findFirst().orElse(null);
            Axis axis3 = renderer.getAxes().stream().filter(axis -> axis.getSide().isVertical()).findFirst().orElse(null);
            if (axis2 == null || axis3 == null) {
                return String.format("DataPoint@(%.3f,%.3f)", tuple.getXValue().doubleValue(), tuple.getYValue().doubleValue());
            }
            return this.getXValueFormatter(axis2).toString((Object)tuple.getXValue()) + ", " + this.getYValueFormatter(axis3).toString((Object)tuple.getYValue());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Axis axis4 : renderer.getAxes()) {
            Side side = axis4.getSide();
            if (side == null) continue;
            String string = axis4.getName();
            String string2 = axis4.getUnit();
            String string3 = MetricPrefix.getShortPrefix(axis4.getUnitScaling());
            boolean bl2 = axis4.isAutoUnitScaling();
            if (bl2 && string2 == null) {
                string2 = " a.u.";
            }
            stringBuilder.append(string).append(" = ");
            stringBuilder.append(side.isHorizontal() ? this.getXValueFormatter(axis4).toString((Object)tuple.getXValue()) : this.getYValueFormatter(axis4).toString((Object)tuple.getYValue()));
            if (string2 != null) {
                stringBuilder.append(string).append(" [").append(string3).append(string2).append(']');
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private static StringConverter<Number> createDefaultFormatter(Axis axis) {
        return new DefaultFormatter<Number>();
    }

    private static class DefaultFormatter<T>
    extends StringConverter<T> {
        private DefaultFormatter() {
        }

        public final T fromString(String string) {
            throw new UnsupportedOperationException();
        }

        public String toString(T t2) {
            return String.valueOf(t2);
        }
    }
}

