/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi.format;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.TickUnitSupplier;
import io.fair_acc.chartfx.axes.spi.format.AbstractFormatter;
import io.fair_acc.chartfx.axes.spi.format.DefaultTickUnitSupplier;
import io.fair_acc.chartfx.utils.NumberFormatterImpl;
import io.fair_acc.chartfx.utils.Schubfach;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public class DefaultFormatter
extends AbstractFormatter {
    private static final TickUnitSupplier DEFAULT_TICK_UNIT_SUPPLIER = new DefaultTickUnitSupplier();
    private final WeakHashMap<Integer, WeakHashMap<Number, String>> numberFormatCache = new WeakHashMap();
    protected NumberFormatterImpl formatter = new NumberFormatterImpl();
    private final List<Schubfach.DecomposedDouble> decompositions = new ArrayList<Schubfach.DecomposedDouble>();
    protected int rangeIndex = 0;
    protected int oldRangeIndex = 0;
    private String prefix;
    private String suffix;
    protected DisplayFormat displayFormat = DisplayFormat.Auto;

    public DisplayFormat getDisplayFormat() {
        return this.displayFormat;
    }

    public DefaultFormatter setDisplayFormat(DisplayFormat displayFormat) {
        if (displayFormat == null) {
            throw new NullPointerException("displayFormat");
        }
        this.displayFormat = displayFormat;
        return this;
    }

    public DefaultFormatter() {
        this.setTickUnitSupplier(DEFAULT_TICK_UNIT_SUPPLIER);
    }

    public DefaultFormatter(Axis axis) {
        super(axis);
    }

    public DefaultFormatter(Axis axis, String string, String string2) {
        this(axis);
        this.prefix = string;
        this.suffix = string2;
    }

    @Override
    public Number fromString(String string) {
        int n2 = this.prefix == null ? 0 : this.prefix.length();
        int n3 = this.suffix == null ? 0 : this.suffix.length();
        String string2 = string.substring(n2, string.length() - n3);
        try {
            return this.formatter.fromString(string2);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException(throwable);
        }
    }

    @Override
    protected void rangeUpdated() {
        if (this.majorTickMarks.size() > 0) {
            boolean bl2 = this.formatter.isExponentialForm();
            int n2 = this.formatter.getDecimalPlaces();
            this.configureFormatter(this.getRange(), this.majorTickMarks);
            if (this.formatter.isExponentialForm() != bl2 || this.formatter.getDecimalPlaces() != n2) {
                this.labelCache.clear();
            }
            if (this.oldRangeIndex != this.rangeIndex) {
                this.labelCache.clear();
                this.oldRangeIndex = this.rangeIndex;
            }
        }
    }

    protected boolean shouldUseExponentialForm(double d2, int n2, int n3) {
        return n2 < -3 || n3 > 4;
    }

    void configureFormatter(double d2, DoubleArrayList doubleArrayList) {
        int n2;
        int n3;
        int n4;
        int n5;
        long l2;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = doubleArrayList.size();
        while (this.decompositions.size() < n10) {
            this.decompositions.add(new Schubfach.DecomposedDouble());
        }
        for (n9 = 0; n9 < n10; ++n9) {
            double d3 = doubleArrayList.getDouble(n9) / this.unitScaling;
            if (Math.abs(d3) < 1.0E-14 && d2 > 1.0E-12) {
                d3 = 0.0;
            }
            Schubfach.decomposeDouble(d3, this.decompositions.get(n9));
        }
        int n11 = n9 = this.decompositions.get(0).getExponent();
        for (n8 = 1; n8 < n10; ++n8) {
            n7 = this.decompositions.get(n8).getExponent();
            n9 = Math.min(n9, n7);
            n11 = Math.max(n11, n7);
        }
        n8 = this.displayFormat == DisplayFormat.Auto ? (int)(this.shouldUseExponentialForm(d2, n9, n11) ? 1 : 0) : (this.displayFormat == DisplayFormat.Scientific ? 1 : 0);
        this.formatter.setExponentialForm(n8 != 0);
        if (n10 == 1) {
            this.formatter.setDecimalPlaces(-1);
            return;
        }
        if (n8 == 0 && n9 != n11) {
            for (n7 = 0; n7 < n10; ++n7) {
                this.decompositions.get(n7).shiftExponentTo(n11);
            }
        }
        long l3 = 10000000000000000L;
        long l4 = 0L;
        for (n6 = 0; n6 < n10 - 1; ++n6) {
            long l5 = this.decompositions.get(n6).getSignificand();
            long l6 = l5 < (l2 = this.decompositions.get(n6 + 1).getSignificand()) ? l2 - l5 : l5 - l2;
            l3 = Math.min(l3, l6);
            l4 = Math.max(l4, l6);
        }
        if (l3 == 0L) {
            this.formatter.setDecimalPlaces(-1);
            return;
        }
        n6 = Schubfach.getDecimalLength(l3);
        int n12 = 17 - n6 + 1;
        int n13 = Schubfach.getDecimalLength(l3 + Schubfach.getRoundingOffset(n12));
        if (n13 > n6) {
            --n12;
        }
        if ((n5 = (n4 = ((n3 = (int)(l3 / (l2 = Schubfach.pow10(17 - n12 - 2)))) + 5) / 10) - (n2 = n4 / 10) * 10) != 0) {
            ++n12;
        }
        int n14 = n8 != 0 ? n12 - 1 : n12 - n11;
        this.formatter.setDecimalPlaces(Math.max(n14, 0));
    }

    @Override
    public String toString(Number number) {
        return this.labelCache.get(this.formatter, number.doubleValue());
    }

    public static enum DisplayFormat {
        Auto,
        Scientific,
        Plain;

    }
}

