/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi;

import io.fair_acc.chartfx.axes.spi.DefaultNumericAxis;
import io.fair_acc.chartfx.renderer.spi.utils.ColorGradient;
import io.fair_acc.chartfx.ui.geometry.Side;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorGradientAxis
extends DefaultNumericAxis {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColorGradientAxis.class);
    protected final Rectangle gradientRect = new Rectangle();
    private final ObjectProperty<ColorGradient> colorGradient = new SimpleObjectProperty((Object)this, "colorGradient", (Object)ColorGradient.DEFAULT);
    private final DoubleProperty gradientWidth = new SimpleDoubleProperty((Object)this, "gradientWidth", 20.0);

    public ColorGradientAxis(double d2, double d3, double d4) {
        super(d2, d3, d4);
        this.gradientWidth.addListener((observableValue, number, number2) -> this.requestAxisLayout());
        this.colorGradient.addListener((observableValue, colorGradient, colorGradient2) -> this.forceRedraw());
        this.getProperties().put((Object)"OmitAxisZoom", (Object)Boolean.TRUE);
    }

    public ColorGradientAxis(double d2, double d3, double d4, ColorGradient colorGradient) {
        this(d2, d3, d4);
        this.colorGradient.set((Object)colorGradient);
    }

    public ColorGradientAxis(String string) {
        super(string);
        this.gradientWidth.addListener((observableValue, number, number2) -> this.requestAxisLayout());
        this.colorGradient.addListener((observableValue, colorGradient, colorGradient2) -> this.forceRedraw());
        this.getProperties().put((Object)"OmitAxisZoom", (Object)Boolean.TRUE);
    }

    public ColorGradientAxis(String string, ColorGradient colorGradient) {
        this(string);
        this.colorGradient.set((Object)colorGradient);
    }

    public ColorGradientAxis(String string, double d2, double d3, double d4) {
        super(string, d2, d3, d4);
        this.gradientWidth.addListener((observableValue, number, number2) -> this.requestAxisLayout());
        this.colorGradient.addListener((observableValue, colorGradient, colorGradient2) -> this.forceRedraw());
        this.getProperties().put((Object)"OmitAxisZoom", (Object)Boolean.TRUE);
    }

    public ColorGradientAxis(String string, double d2, double d3, double d4, ColorGradient colorGradient) {
        this(string, d2, d3, d4);
        this.colorGradient.set((Object)colorGradient);
    }

    public ColorGradientAxis(String string, String string2) {
        super(string, string2);
        this.gradientWidth.addListener((observableValue, number, number2) -> this.requestAxisLayout());
        this.colorGradient.addListener((observableValue, colorGradient, colorGradient2) -> this.forceRedraw());
        this.getProperties().put((Object)"OmitAxisZoom", (Object)Boolean.TRUE);
    }

    public ColorGradientAxis(String string, String string2, ColorGradient colorGradient) {
        this(string, string2);
        this.colorGradient.set((Object)colorGradient);
    }

    public ObjectProperty<ColorGradient> colorGradientProperty() {
        return this.colorGradient;
    }

    @Override
    protected double computePrefHeight(double d2) {
        Side side = this.getSide();
        if (side == null || side == Side.CENTER_HOR || side.isVertical()) {
            return super.computePrefHeight(d2);
        }
        return super.computePrefHeight(d2) + this.getGradientWidth();
    }

    @Override
    protected double computePrefWidth(double d2) {
        Side side = this.getSide();
        if (side == null || side == Side.CENTER_VER || side.isHorizontal()) {
            return super.computePrefWidth(d2);
        }
        return super.computePrefWidth(d2) + this.getGradientWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawAxis(GraphicsContext graphicsContext, double d2, double d3) {
        if (graphicsContext == null || this.getSide() == null) {
            return;
        }
        double d4 = this.getSide().isHorizontal() ? d2 : d3;
        this.drawGradient(graphicsContext, d4, d2, d3);
        double d5 = this.getGradientWidth();
        double d6 = 0.0;
        double d7 = 0.0;
        switch (this.getSide()) {
            case LEFT: 
            case CENTER_VER: {
                d6 = -d5;
                break;
            }
            case RIGHT: 
            case CENTER_HOR: {
                d6 = d5;
                break;
            }
            case TOP: {
                d7 = -d5;
                break;
            }
            case BOTTOM: {
                d7 = d5;
                break;
            }
        }
        try {
            graphicsContext.translate(d6, d7);
            super.drawAxis(graphicsContext, d2 - Math.abs(d6), d3 - Math.abs(d7));
        }
        finally {
            graphicsContext.translate(-d6, -d7);
        }
    }

    private void drawGradient(GraphicsContext graphicsContext, double d2, double d3, double d4) {
        graphicsContext.save();
        this.getMajorTickStyle().copyStyleTo(graphicsContext);
        if (this.getSide().isHorizontal()) {
            graphicsContext.setFill((Paint)new LinearGradient(0.0, 0.0, d2, 0.0, false, CycleMethod.NO_CYCLE, this.getColorGradient().getStops()));
        } else {
            graphicsContext.setFill((Paint)new LinearGradient(0.0, d2, 0.0, 0.0, false, CycleMethod.NO_CYCLE, this.getColorGradient().getStops()));
        }
        double d5 = this.getGradientWidth();
        double d6 = this.getAxisCenterPosition();
        switch (this.getSide()) {
            case LEFT: {
                graphicsContext.fillRect(ColorGradientAxis.snap(d3 - d5), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(d3), ColorGradientAxis.snap(d2));
                graphicsContext.strokeRect(ColorGradientAxis.snap(d3 - d5), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(d3), ColorGradientAxis.snap(d2));
                break;
            }
            case RIGHT: {
                graphicsContext.fillRect(ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(d5), ColorGradientAxis.snap(d2));
                graphicsContext.strokeRect(ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(d5), ColorGradientAxis.snap(d2));
                break;
            }
            case TOP: {
                graphicsContext.fillRect(ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(d4 - d5), ColorGradientAxis.snap(d2), ColorGradientAxis.snap(d4));
                graphicsContext.strokeRect(ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(d4 - d5), ColorGradientAxis.snap(d2), ColorGradientAxis.snap(d4));
                break;
            }
            case BOTTOM: {
                graphicsContext.rect(ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(d2), ColorGradientAxis.snap(d5));
                break;
            }
            case CENTER_HOR: {
                graphicsContext.fillRect(ColorGradientAxis.snap(0.0), d6 * d4 - 0.5 * d5, ColorGradientAxis.snap(d2), ColorGradientAxis.snap(d6 * d4 + 0.5 * d5));
                graphicsContext.strokeRect(ColorGradientAxis.snap(0.0), d6 * d4 - 0.5 * d5, ColorGradientAxis.snap(d2), ColorGradientAxis.snap(d6 * d4 + 0.5 * d5));
                break;
            }
            case CENTER_VER: {
                graphicsContext.fillRect(ColorGradientAxis.snap(d6 * d3 - 0.5 * d5), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(d6 * d3 + 0.5 * d5), ColorGradientAxis.snap(d2));
                graphicsContext.strokeRect(ColorGradientAxis.snap(d6 * d3 - 0.5 * d5), ColorGradientAxis.snap(0.0), ColorGradientAxis.snap(d6 * d3 + 0.5 * d5), ColorGradientAxis.snap(d2));
                break;
            }
        }
        graphicsContext.restore();
    }

    public Color getColor(double d2) {
        double d3 = (d2 - this.getRange().getLowerBound()) / (this.getRange().getUpperBound() - this.getRange().getLowerBound());
        double d4 = 0.0;
        double d5 = 1.0;
        Color color = Color.TRANSPARENT;
        Color color2 = Color.TRANSPARENT;
        for (Stop stop : this.getColorGradient().getStops()) {
            double d6 = stop.getOffset();
            if (d6 == d3) {
                return stop.getColor();
            }
            if (d6 < d3) {
                d4 = d6;
                color = stop.getColor();
                continue;
            }
            d5 = d6;
            color2 = stop.getColor();
            break;
        }
        double d7 = (d3 - d4) / (d5 - d4);
        return color.interpolate(color2, d7);
    }

    public ColorGradient getColorGradient() {
        return (ColorGradient)this.colorGradientProperty().get();
    }

    public double getGradientWidth() {
        return this.gradientWidth.get();
    }

    public int getIntColor(double d2) {
        Color color = this.getColor(d2);
        return ((byte)(color.getOpacity() * 255.0) << 24) + ((byte)(color.getRed() * 255.0) << 16) + ((byte)(color.getGreen() * 255.0) << 8) + (byte)(color.getBlue() * 255.0);
    }

    public DoubleProperty gradientWidthProperty() {
        return this.gradientWidth;
    }

    public void setColorGradient(ColorGradient colorGradient) {
        this.colorGradientProperty().set((Object)colorGradient);
    }

    public void setGradientWidth(double d2) {
        this.gradientWidth.set(d2);
    }
}

