/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ErrorCode;
import io.aeron.command.ClientTimeoutFlyweight;
import io.aeron.command.CounterUpdateFlyweight;
import io.aeron.command.ErrorResponseFlyweight;
import io.aeron.command.ImageBuffersReadyFlyweight;
import io.aeron.command.ImageMessageFlyweight;
import io.aeron.command.OperationSucceededFlyweight;
import io.aeron.command.PublicationBuffersReadyFlyweight;
import io.aeron.command.SubscriptionReadyFlyweight;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.broadcast.BroadcastTransmitter;

final class ClientProxy {
    private final MutableDirectBuffer buffer = new ExpandableArrayBuffer(1024);
    private final BroadcastTransmitter transmitter;
    private final ErrorResponseFlyweight errorResponse = new ErrorResponseFlyweight();
    private final PublicationBuffersReadyFlyweight publicationReady = new PublicationBuffersReadyFlyweight();
    private final SubscriptionReadyFlyweight subscriptionReady = new SubscriptionReadyFlyweight();
    private final ImageBuffersReadyFlyweight imageReady = new ImageBuffersReadyFlyweight();
    private final OperationSucceededFlyweight operationSucceeded = new OperationSucceededFlyweight();
    private final ImageMessageFlyweight imageMessage = new ImageMessageFlyweight();
    private final CounterUpdateFlyweight counterUpdate = new CounterUpdateFlyweight();
    private final ClientTimeoutFlyweight clientTimeout = new ClientTimeoutFlyweight();

    ClientProxy(BroadcastTransmitter broadcastTransmitter) {
        this.transmitter = broadcastTransmitter;
        this.errorResponse.wrap(this.buffer, 0);
        this.imageReady.wrap(this.buffer, 0);
        this.publicationReady.wrap(this.buffer, 0);
        this.subscriptionReady.wrap(this.buffer, 0);
        this.operationSucceeded.wrap(this.buffer, 0);
        this.imageMessage.wrap(this.buffer, 0);
        this.counterUpdate.wrap(this.buffer, 0);
        this.clientTimeout.wrap(this.buffer, 0);
    }

    void onError(long l2, ErrorCode errorCode, String string) {
        this.errorResponse.offendingCommandCorrelationId(l2).errorCode(errorCode).errorMessage(string);
        this.transmit(3841, this.buffer, 0, this.errorResponse.length());
    }

    void onAvailableImage(long l2, int n2, int n3, long l3, int n4, String string, String string2) {
        this.imageReady.correlationId(l2).sessionId(n3).streamId(n2).subscriptionRegistrationId(l3).subscriberPositionId(n4).logFileName(string).sourceIdentity(string2);
        this.transmit(3842, this.buffer, 0, this.imageReady.length());
    }

    void onPublicationReady(long l2, long l3, int n2, int n3, String string, int n4, int n5, boolean bl2) {
        this.publicationReady.correlationId(l2).registrationId(l3).sessionId(n3).streamId(n2).publicationLimitCounterId(n4).channelStatusCounterId(n5).logFileName(string);
        int n6 = bl2 ? 3846 : 3843;
        this.transmit(n6, this.buffer, 0, this.publicationReady.length());
    }

    void onSubscriptionReady(long l2, int n2) {
        this.subscriptionReady.correlationId(l2).channelStatusCounterId(n2);
        this.transmit(3847, this.buffer, 0, 12);
    }

    void operationSucceeded(long l2) {
        this.operationSucceeded.correlationId(l2);
        this.transmit(3844, this.buffer, 0, 8);
    }

    void onUnavailableImage(long l2, long l3, int n2, String string) {
        this.imageMessage.correlationId(l2).subscriptionRegistrationId(l3).streamId(n2).channel(string);
        this.transmit(3845, this.buffer, 0, this.imageMessage.length());
    }

    void onCounterReady(long l2, int n2) {
        this.counterUpdate.correlationId(l2).counterId(n2);
        this.transmit(3848, this.buffer, 0, 12);
    }

    void onUnavailableCounter(long l2, int n2) {
        this.counterUpdate.correlationId(l2).counterId(n2);
        this.transmit(3849, this.buffer, 0, 12);
    }

    void onClientTimeout(long l2) {
        this.clientTimeout.clientId(l2);
        this.transmit(3850, this.buffer, 0, 8);
    }

    private void transmit(int n2, DirectBuffer directBuffer, int n3, int n4) {
        this.transmitter.transmit(n2, directBuffer, n3, n4);
    }

    public String toString() {
        return "ClientProxy{}";
    }
}

