/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.tableview2;

import impl.org.controlsfx.tableview2.RowHeader;
import impl.org.controlsfx.tableview2.TableRow2;
import impl.org.controlsfx.tableview2.TableView2Skin;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.skin.CellSkinBase;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.Pane;
import javafx.util.Callback;
import org.controlsfx.control.tableview2.TableView2;

public class TableRow2Skin<S>
extends CellSkinBase<TableRow<S>> {
    private static final PseudoClass SELECTED = PseudoClass.getPseudoClass((String)"selected");
    private static final PseudoClass LEFT_CELL = PseudoClass.getPseudoClass((String)"left");
    private static final PseudoClass RIGHT_CELL = PseudoClass.getPseudoClass((String)"right");
    private static final PseudoClass SINGLE_CELL = PseudoClass.getPseudoClass((String)"single");
    private static final PseudoClass FIXED_CELL = PseudoClass.getPseudoClass((String)"fixed");
    private final TableView2<S> tableView;
    private final TableView2Skin<S> skin;
    private Reference<HashMap<TableColumnBase, TableCell<S, ?>>> cellsMap;
    private final List<TableCell<S, ?>> cells = new ArrayList();
    private final TableView2<S> parentTableView;

    public TableRow2Skin(TableView2<S> tableView2, TableRow<S> tableRow) {
        super(tableRow);
        this.tableView = tableView2;
        ((TableRow)this.getSkinnable()).setPickOnBounds(false);
        this.registerChangeListener((ObservableValue)tableRow.itemProperty(), observableValue -> this.requestCellUpdate());
        this.registerChangeListener((ObservableValue)tableRow.indexProperty(), observableValue -> {
            if (((TableRow)this.getSkinnable()).isEmpty()) {
                this.requestCellUpdate();
            }
        });
        if (tableView2.getParent() != null && tableView2.getParent() instanceof RowHeader) {
            this.parentTableView = ((RowHeader)tableView2.getParent()).getParentTableView();
            this.skin = (TableView2Skin)this.parentTableView.getSkin();
        } else {
            this.parentTableView = null;
            this.skin = (TableView2Skin)tableView2.getSkin();
        }
    }

    private void requestCellUpdate() {
        ((TableRow)this.getSkinnable()).requestLayout();
        int n2 = ((TableRow)this.getSkinnable()).getIndex();
        int n3 = this.cells.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            this.cells.get(i2).updateIndex(n2);
        }
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        TableColumn tableColumn;
        boolean bl2;
        int n2;
        ObservableList observableList = this.tableView.getVisibleLeafColumns();
        if (observableList.isEmpty()) {
            super.layoutChildren(d2, d3, d4, d5);
            return;
        }
        TableRow2 tableRow2 = (TableRow2)this.getSkinnable();
        int n3 = tableRow2.getIndex();
        if (n3 < 0) {
            this.getChildren().clear();
            this.putCellsInCache();
            return;
        }
        this.getChildren().removeIf(node -> node.getId() != null && node.getId().equals("pane-fixed-cell"));
        Object object = tableRow2.getProperties().get((Object)"fixed");
        boolean bl3 = Boolean.TRUE.equals(object);
        ObservableList observableList2 = this.tableView.getVisibleLeafColumns();
        ((TableRow)this.getSkinnable()).setVisible(true);
        double d6 = 0.0;
        double d7 = this.snappedTopInset() + this.snappedBottomInset();
        double d8 = this.snappedLeftInset() + this.snappedRightInset();
        double d9 = this.skin.getRowHeight(tableRow2.getIndex());
        this.skin.hBarValue.set(n3, true);
        double d10 = this.tableView.getWidth();
        double d11 = this.parentTableView != null ? 0.0 : this.skin.getHBar().getValue();
        tableRow2.verticalShift.setValue((Number)(this.tableView.isRowFixingEnabled() ? this.getFixedRowShift(n3) : 0.0));
        double d12 = 0.0;
        ArrayList arrayList = new ArrayList();
        this.putCellsInCache();
        boolean bl4 = false;
        TableCell<S, ?> tableCell = null;
        boolean bl5 = false;
        boolean bl6 = false;
        block5: for (int i2 = 0; i2 < observableList2.size(); ++i2) {
            TableCell<S, ?> tableCell2;
            TableColumn tableColumn2 = (TableColumn)observableList2.get(i2);
            if (!tableColumn2.isVisible()) continue;
            TablePosition tablePosition2 = new TablePosition(this.tableView, n3, tableColumn2);
            double d13 = this.snapSizeX(tableColumn2.getWidth()) - this.snapSizeX(d8);
            bl2 = !this.isInvisible(d2, d13, d11, d10, n2 = this.tableView.getColumnSpan(tablePosition2));
            tableColumn = tableColumn2;
            while (tableColumn.getParentColumn() != null) {
                tableColumn = (TableColumn)tableColumn.getParentColumn();
            }
            if (this.tableView.isColumnFixingEnabled() && this.tableView.getFixedColumns().contains((Object)tableColumn)) {
                bl2 = true;
            }
            if (!bl2) {
                tableCell2 = this.getCellsMap().remove(tableColumn2);
                if (tableCell2 != null) {
                    this.getChildren().remove(tableCell2);
                }
                if (bl4) break;
                d2 += d13;
                continue;
            }
            tableCell2 = this.getCell((TableColumnBase)tableColumn2);
            if (!bl6) {
                tableCell2.pseudoClassStateChanged(LEFT_CELL, true);
                bl6 = true;
            }
            this.cells.add(0, tableCell2);
            tableCell2.setManaged(true);
            double d14 = 0.0;
            boolean bl7 = false;
            if (this.tableView.isColumnFixingEnabled() && this.tableView.getFixedColumns().contains((Object)tableColumn2) && d11 + d12 > d2) {
                bl7 = true;
                d14 = Math.abs(d11 - d2 + d12);
                d12 += d13;
                arrayList.add(tableCell2);
            }
            TableView2.SpanType spanType = this.tableView.getSpanType(n3, i2);
            switch (spanType) {
                case ROW_SPAN_INVISIBLE: 
                case BOTH_INVISIBLE: {
                    arrayList.remove(tableCell2);
                    this.getChildren().remove(tableCell2);
                    d2 += d13;
                    continue block5;
                }
                case COLUMN_SPAN_INVISIBLE: {
                    arrayList.remove(tableCell2);
                    this.getChildren().remove(tableCell2);
                    continue block5;
                }
                case ROW_VISIBLE: 
                case NORMAL_CELL: {
                    if (tableCell2.getIndex() != n3) {
                        tableCell2.updateIndex(n3);
                    } else {
                        tableCell2.updateIndex(n3);
                        tableCell2.requestLayout();
                    }
                    if (!tableCell2.isEditing() && tableCell2.getParent() != this.getSkinnable()) {
                        this.getChildren().add(0, tableCell2);
                    }
                }
                default: {
                    int n4;
                    int n5;
                    int n6;
                    if (this.tableView.getSelectionModel() != null && this.tableView.getSelectionModel().isCellSelectionEnabled()) {
                        n6 = i2;
                        n5 = !this.tableView.getSelectionModel().getSelectedCells().stream().noneMatch(tablePosition -> tablePosition.getRow() == n3 && tablePosition.getColumn() == n6) ? 1 : 0;
                        tableCell2.pseudoClassStateChanged(SELECTED, n5 != 0);
                    }
                    if (n2 > 1) {
                        n6 = this.skin.getViewColumn(i2);
                        n5 = this.tableView.getVisibleLeafColumns().size() - n6;
                        int n7 = n2;
                        for (n4 = 1; n4 < n7 && n4 < n5; ++n4) {
                            double d15 = this.snapSize(this.tableView.getVisibleLeafColumn(n6 + n4).getWidth());
                            d13 += d15;
                            if (!bl7) continue;
                            d12 += d15;
                        }
                    }
                    if (!tableCell2.isEditing()) {
                        double d16 = tableCell2.prefHeight(d13) + tableCell2.snappedTopInset() + tableCell2.snappedBottomInset();
                        if (this.parentTableView != null && tableRow2.getIndex() < this.skin.getItemCount()) {
                            d16 = (Double)this.skin.rowHeightMap.getOrDefault((Object)tableRow2.getIndex(), (Object)d16);
                        }
                        if (d16 > d9) {
                            bl5 = true;
                            this.skin.rowHeightMap.put((Object)tableRow2.getIndex(), (Object)d16);
                            for (TableCell<S, ?> tableCell3 : this.cells) {
                                tableCell3.resize(tableCell3.getWidth(), tableCell3.getHeight() + (d16 - d9));
                            }
                            d9 = d16;
                            if (this.parentTableView != null) {
                                ((TableView2Skin)this.tableView.getSkin()).getFlow().layoutChildren();
                            } else {
                                this.skin.getFlow().layoutChildren();
                            }
                        }
                    }
                    d6 = d9;
                    d6 = this.snapSize(d6) - this.snapSize(d7);
                    n6 = this.tableView.getRowSpan(tablePosition2, n3);
                    if (n6 > 1) {
                        d6 = 0.0;
                        n5 = n3 + n6;
                        for (n4 = n3; n4 < n5; ++n4) {
                            d6 += this.snapSize(this.skin.getRowHeight(n4));
                        }
                    }
                    boolean bl8 = false;
                    if (tableCell != null && !this.hasRightBorder(tableCell) && !this.hasLeftBorder(tableCell2)) {
                        tableCell2.resize(d13 + 1.0, d6);
                        bl8 = true;
                    } else {
                        tableCell2.resize(d13, d6);
                    }
                    tableCell = tableCell2;
                    double d17 = 0.0;
                    tableCell2.relocate(d2 + d14 + (double)(bl8 ? -1 : 0), this.snappedTopInset() - d17 + tableRow2.verticalShift.get());
                    d2 += d13;
                }
            }
        }
        double d18 = this.tableView.getWidth() - d2 - this.tableView.snappedLeftInset() - this.tableView.snappedRightInset();
        if (this.tableView.isRowHeaderVisible()) {
            d18 -= this.tableView.getRowHeaderWidth();
        }
        if (this.skin.getVBar().isVisible()) {
            d18 -= this.skin.getVBar().getWidth();
        }
        boolean bl9 = true;
        n2 = d18 > 1.0 ? 1 : 0;
        boolean bl10 = bl2 = observableList2.size() == 1;
        if (bl3 && d18 >= 0.0 && this.parentTableView == null) {
            tableColumn = new Pane();
            tableColumn.setId("pane-fixed-cell");
            tableColumn.getStyleClass().add((Object)"tableview2-cell");
            tableColumn.pseudoClassStateChanged(RIGHT_CELL, n2 != 0);
            tableColumn.resizeRelocate(d2, this.snappedTopInset() + tableRow2.verticalShift.get(), d18, d6);
            this.getChildren().add((Object)tableColumn);
        }
        if (tableCell != null) {
            tableCell.pseudoClassStateChanged(RIGHT_CELL, !bl2 && n2 == 0);
            tableCell.pseudoClassStateChanged(SINGLE_CELL, bl2 && n2 == 0);
            if (this.parentTableView != null) {
                tableCell.pseudoClassStateChanged(FIXED_CELL, bl3 && tableRow2.getIndex() < this.skin.getItemCount());
            }
        }
        this.skin.fixedColumnWidth = d12;
        this.handleFixedCell(arrayList, n3);
        this.removeUselessCell(n3);
        if (this.skin.lastRowLayout.get()) {
            this.skin.lastRowLayout.setValue(Boolean.valueOf(false));
        }
        if (bl5 && this.tableView.getFixedRows().contains((Object)n3)) {
            this.skin.computeFixedRowHeight();
        }
    }

    private boolean hasRightBorder(TableCell<S, ?> tableCell) {
        return tableCell.getBorder() != null && !tableCell.getBorder().isEmpty() && ((BorderStroke)tableCell.getBorder().getStrokes().get(0)).getWidths().getRight() > 0.0;
    }

    private boolean hasLeftBorder(TableCell<S, ?> tableCell) {
        return tableCell.getBorder() != null && !tableCell.getBorder().isEmpty() && ((BorderStroke)tableCell.getBorder().getStrokes().get(0)).getWidths().getLeft() > 0.0;
    }

    private void removeUselessCell(int n2) {
        this.getChildren().removeIf(node -> {
            if (node instanceof TableCell) {
                return !this.cells.contains((TableCell)node) && ((TableCell)node).getIndex() == n2;
            }
            return false;
        });
    }

    private void removeDeportedCells() {
        for (Map.Entry entry : this.skin.deportedCells.entrySet()) {
            ArrayList arrayList = new ArrayList();
            for (TableCell tableCell : entry.getValue()) {
                if (tableCell.isEditing() || tableCell.getTableRow() != this.getSkinnable() || entry.getKey() == this.getSkinnable()) continue;
                entry.getKey().removeCell(tableCell);
                arrayList.add(tableCell);
            }
            entry.getValue().removeAll(arrayList);
        }
    }

    private void handleFixedCell(List<TableCell<S, ?>> list, int n2) {
        block7: {
            block6: {
                this.removeDeportedCells();
                if (list.isEmpty()) {
                    return;
                }
                if (!this.skin.rowToLayout.get(n2)) break block6;
                TableRow tableRow = (TableRow)this.getSkinnable();
                if (tableRow == null || !(tableRow instanceof TableRow2)) break block7;
                TableRow2 tableRow2 = (TableRow2)tableRow;
                for (TableCell<S, ?> tableCell : list) {
                    if (!tableCell.isEditing()) {
                        tableRow2.removeCell(tableCell);
                        tableRow2.addCell(tableCell);
                    }
                    double d2 = ((TableRow)this.getSkinnable()).getLayoutY() + tableCell.getLayoutY();
                    if (this.skin.deportedCells.containsKey((Object)tableRow2)) {
                        this.skin.deportedCells.get((Object)tableRow2).add(tableCell);
                    } else {
                        HashSet hashSet = new HashSet();
                        hashSet.add(tableCell);
                        this.skin.deportedCells.put(tableRow2, hashSet);
                    }
                    tableCell.relocate(tableCell.getLayoutX(), d2 - tableRow.getLayoutY());
                }
                break block7;
            }
            for (TableCell<S, ?> tableCell : list) {
                tableCell.toFront();
            }
        }
    }

    private HashMap<TableColumnBase, TableCell<S, ?>> getCellsMap() {
        if (this.cellsMap == null || this.cellsMap.get() == null) {
            HashMap hashMap = new HashMap();
            this.cellsMap = new WeakReference(hashMap);
            return hashMap;
        }
        return this.cellsMap.get();
    }

    private void putCellsInCache() {
        for (TableCell<S, ?> tableCell : this.cells) {
            this.getCellsMap().put((TableColumnBase)tableCell.getTableColumn(), tableCell);
        }
        this.cells.clear();
    }

    private TableCell<S, ?> getCell(TableColumnBase tableColumnBase) {
        TableCell tableCell;
        TableColumn tableColumn = (TableColumn)tableColumnBase;
        if (this.getCellsMap().containsKey(tableColumn)) {
            tableCell = this.getCellsMap().remove(tableColumn);
        } else {
            Callback callback = tableColumn.getCellFactory();
            if (callback == null) {
                callback = TableColumn.DEFAULT_CELL_FACTORY;
            }
            if (!(tableCell = (TableCell)callback.call((Object)tableColumn)).getStyleClass().contains((Object)"tableview2-cell")) {
                tableCell.getStyleClass().add((Object)"tableview2-cell");
            }
            tableCell.updateTableColumn(tableColumn);
            tableCell.updateTableView(tableColumn.getTableView());
            tableCell.updateTableRow((TableRow)this.getSkinnable());
            if (this.parentTableView != null) {
                tableCell.setOnContextMenuRequested(contextMenuEvent -> {
                    BiFunction<Integer, S, ContextMenu> biFunction = this.parentTableView.getRowHeaderContextMenuFactory();
                    if (this.tableView.getItems() != null && biFunction != null) {
                        ContextMenu contextMenu = biFunction.apply(((TableRow)this.getSkinnable()).getIndex(), ((TableRow)this.getSkinnable()).getItem());
                        contextMenu.show(this.tableView.getScene().getWindow(), contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
                    }
                });
            }
        }
        tableCell.pseudoClassStateChanged(LEFT_CELL, false);
        tableCell.pseudoClassStateChanged(RIGHT_CELL, false);
        tableCell.pseudoClassStateChanged(SINGLE_CELL, false);
        return tableCell;
    }

    private double getFixedRowShift(int n2) {
        double d2 = 0.0;
        int n3 = this.tableView.getFixedRows().indexOf((Object)n2);
        double d3 = 0.0;
        for (int i2 = 0; i2 < n3; ++i2) {
            d3 += this.skin.getRowHeight((Integer)this.tableView.getFixedRows().get(i2));
        }
        if (n3 != -1 && ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy() <= d3) {
            d2 = d3 - ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy();
            this.skin.getCurrentlyFixedRow().add((Object)n2);
        } else {
            this.skin.getCurrentlyFixedRow().remove((Object)n2);
        }
        return d2;
    }

    private boolean isInvisible(double d2, double d3, double d4, double d5, int n2) {
        return d2 + d3 < d4 && n2 == 1 || d2 > d4 + d5;
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        ObservableList observableList = this.tableView.getVisibleLeafColumns();
        int n2 = observableList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            d7 += ((TableColumnBase)observableList.get(i2)).getWidth();
        }
        return d7;
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        if (this.parentTableView != null) {
            return this.skin.getRow(((TableRow)this.getSkinnable()).getIndex()).getPrefHeight();
        }
        return ((TableRow)this.getSkinnable()).getPrefHeight();
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        if (this.parentTableView != null) {
            return this.skin.getRow(((TableRow)this.getSkinnable()).getIndex()).getPrefHeight();
        }
        return ((TableRow)this.getSkinnable()).getPrefHeight();
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return super.computeMaxHeight(d2, d3, d4, d5, d6);
    }
}

