/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.control.Skin;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class SpreadsheetGridView
extends TableView<ObservableList<SpreadsheetCell>> {
    private final SpreadsheetHandle handle;

    public SpreadsheetGridView(SpreadsheetHandle spreadsheetHandle) {
        this.handle = spreadsheetHandle;
    }

    public String getUserAgentStylesheet() {
        return this.handle.getView().getUserAgentStylesheet();
    }

    protected Skin<?> createDefaultSkin() {
        return new GridViewSkin(this.handle);
    }

    public GridViewSkin getGridViewSkin() {
        return this.handle.getCellsViewSkin();
    }

    public boolean resizeColumn(TableColumn<ObservableList<SpreadsheetCell>, ?> tableColumn, double d2) {
        boolean bl2 = super.resizeColumn(tableColumn, d2);
        if (bl2) {
            Event.fireEvent((EventTarget)this.handle.getView(), (Event)new SpreadsheetView.ColumnWidthEvent(this.getColumns().indexOf(tableColumn), tableColumn.getWidth()));
        }
        return bl2;
    }
}

