/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.TableViewSpanSelectionModel;
import java.util.List;
import java.util.TreeSet;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.spreadsheet.ClipboardCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class RectangleSelection
extends Rectangle {
    private final GridViewSkin skin;
    private final TableViewSpanSelectionModel sm;
    private final SelectionRange selectionRange;
    private final InvalidationListener selectedCellListener;
    private final InvalidationListener layoutListener = observable -> this.updateRectangle();
    private final EventHandler<MouseEvent> mouseDraggedListener = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            RectangleSelection.this.skin.getVBar().valueProperty().removeListener(RectangleSelection.this.layoutListener);
            RectangleSelection.this.setVisible(false);
            RectangleSelection.this.skin.getVBar().addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    RectangleSelection.this.skin.getVBar().removeEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)this);
                    RectangleSelection.this.skin.getVBar().valueProperty().addListener(RectangleSelection.this.layoutListener);
                    RectangleSelection.this.updateRectangle();
                }
            });
        }
    };

    public RectangleSelection(GridViewSkin gridViewSkin, TableViewSpanSelectionModel tableViewSpanSelectionModel) {
        this.skin = gridViewSkin;
        this.sm = tableViewSpanSelectionModel;
        this.getStyleClass().add((Object)"selection-rectangle");
        this.setMouseTransparent(true);
        this.selectionRange = new SelectionRange();
        this.selectedCellListener = observable -> {
            gridViewSkin.getHorizontalHeader().clearSelectedColumns();
            gridViewSkin.verticalHeader.clearSelectedRows();
            this.selectionRange.fill((List<TablePosition>)tableViewSpanSelectionModel.getSelectedCells(), gridViewSkin.spreadsheetView);
            this.updateRectangle();
        };
        gridViewSkin.getVBar().valueProperty().addListener(this.layoutListener);
        gridViewSkin.getVBar().addEventFilter(MouseEvent.MOUSE_DRAGGED, this.mouseDraggedListener);
        gridViewSkin.spreadsheetView.hiddenRowsProperty().addListener(this.selectedCellListener);
        gridViewSkin.spreadsheetView.hiddenColumnsProperty().addListener(this.selectedCellListener);
        gridViewSkin.getHBar().valueProperty().addListener(this.layoutListener);
        tableViewSpanSelectionModel.getSelectedCells().addListener(this.selectedCellListener);
    }

    public final void updateRectangle() {
        if (this.sm.getSelectedCells().isEmpty() || this.skin.getSelectedRows().isEmpty() || this.skin.getSelectedColumns().isEmpty() || this.selectionRange.range == null) {
            this.setVisible(false);
            return;
        }
        GridRow gridRow = this.skin.getFlow().getTopRow();
        if (gridRow == null) {
            return;
        }
        int n2 = gridRow.getIndex();
        IndexedCell indexedCell = (IndexedCell)this.skin.getFlow().getCells().get(this.skin.getFlow().getCells().size() - 1);
        if (indexedCell == null) {
            return;
        }
        int n3 = indexedCell.getIndex();
        int n4 = this.selectionRange.range.getTop();
        if (n4 > n3) {
            this.setVisible(false);
            return;
        }
        n4 = Math.max(n4, n2);
        int n5 = this.selectionRange.range.getBottom();
        if (n5 < n2) {
            this.setVisible(false);
            return;
        }
        n5 = Math.min(n5, n3);
        int n6 = this.selectionRange.range.getLeft();
        int n7 = this.selectionRange.range.getRight();
        GridRow gridRow2 = this.skin.getRowIndexed(n4);
        if (gridRow2 == null) {
            this.setVisible(false);
            return;
        }
        if (n5 >= this.skin.getItemCount() || n7 >= ((TableView)this.skin.getSkinnable()).getVisibleLeafColumns().size() || n6 < 0) {
            this.setVisible(false);
            return;
        }
        SpreadsheetCell spreadsheetCell = (SpreadsheetCell)((ObservableList)((TableView)this.skin.getSkinnable()).getItems().get(n5)).get(this.skin.spreadsheetView.getModelColumn(n7));
        this.handleHorizontalPositioning(n6, this.skin.spreadsheetView.getViewColumn(spreadsheetCell.getColumn()) + this.skin.spreadsheetView.getColumnSpan(spreadsheetCell) - 1);
        if (this.getX() + this.getWidth() < 0.0) {
            this.setVisible(false);
            return;
        }
        GridRow gridRow3 = this.skin.getRowIndexed(n5);
        if (gridRow3 == null) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        this.handleVerticalPositioning(n4, n5, gridRow2, gridRow3);
    }

    private void handleVerticalPositioning(int n2, int n3, GridRow gridRow, GridRow gridRow2) {
        double d2 = 0.0;
        for (int i2 = n3; i2 <= n3; ++i2) {
            d2 += this.skin.getRowHeight(i2);
        }
        if (!this.skin.getCurrentlyFixedRow().contains((Object)n2)) {
            this.yProperty().unbind();
            if (gridRow.getLayoutY() < this.skin.getFixedRowHeight()) {
                this.setY(this.skin.getFixedRowHeight());
            } else {
                this.yProperty().bind((ObservableValue)gridRow.layoutYProperty());
            }
        } else {
            this.yProperty().bind((ObservableValue)gridRow.layoutYProperty().add((ObservableNumberValue)gridRow.verticalShift));
        }
        this.heightProperty().bind((ObservableValue)gridRow2.layoutYProperty().add((ObservableNumberValue)gridRow2.verticalShift).subtract((ObservableNumberValue)this.yProperty()).add(d2));
    }

    private void handleHorizontalPositioning(int n2, int n3) {
        int n4;
        double d2 = 0.0;
        ObservableList observableList = this.skin.handle.getGridView().getVisibleLeafColumns();
        ObservableList observableList2 = this.skin.handle.getGridView().getColumns();
        ObservableList<SpreadsheetColumn> observableList3 = this.skin.spreadsheetView.getColumns();
        if (observableList.size() <= n2 || observableList.size() <= n3) {
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            d2 += this.snapSize(((TableColumn)observableList.get(i2)).getWidth());
        }
        d2 -= this.skin.getHBar().getValue();
        double d3 = 0.0;
        for (n4 = n2; n4 <= n3; ++n4) {
            d3 += this.snapSize(((TableColumn)observableList.get(n4)).getWidth());
        }
        n4 = this.skin.spreadsheetView.getModelColumn(n2);
        if (n4 < observableList3.size() && !this.skin.spreadsheetView.getFixedColumns().contains(observableList3.get(n4))) {
            if (d2 < this.skin.fixedColumnWidth) {
                d3 -= this.skin.fixedColumnWidth - d2;
                d2 = this.skin.fixedColumnWidth;
            }
        } else if (d2 + d3 < this.skin.fixedColumnWidth) {
            d2 = 0.0;
            d3 = 0.0;
            for (SpreadsheetColumn spreadsheetColumn : this.skin.spreadsheetView.getFixedColumns()) {
                int n5 = this.skin.spreadsheetView.getViewColumn(observableList3.indexOf(spreadsheetColumn));
                if (n5 < n2 && n5 != n2) {
                    d2 += this.snapSize(spreadsheetColumn.getWidth());
                }
                if (n5 < n2 || n5 > n3) continue;
                d3 += this.snapSize(spreadsheetColumn.getWidth());
            }
        } else if (d2 < this.skin.fixedColumnWidth) {
            double d4 = 0.0;
            for (SpreadsheetColumn spreadsheetColumn : this.skin.spreadsheetView.getFixedColumns()) {
                int n6 = this.skin.spreadsheetView.getViewColumn(observableList3.indexOf(spreadsheetColumn));
                if (n6 >= n2 || n6 == n2) continue;
                d4 += this.snapSize(spreadsheetColumn.getWidth());
            }
            d3 -= d4 - d2;
            d2 = d4;
        }
        this.setX(d2);
        this.setWidth(d3);
    }

    private double snapSize(double d2) {
        return Math.ceil(d2);
    }

    public static class GridRange {
        private final int top;
        private final int bottom;
        private final int left;
        private final int right;

        public GridRange(int n2, int n3, int n4, int n5) {
            this.top = n2;
            this.bottom = n3;
            this.left = n4;
            this.right = n5;
        }

        public int getTop() {
            return this.top;
        }

        public int getBottom() {
            return this.bottom;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }
    }

    public static class SelectionRange {
        private final TreeSet<Long> set = new TreeSet();
        private GridRange range;

        public void fill(List<TablePosition> list) {
            this.set.clear();
            for (TablePosition tablePosition : list) {
                long l2 = SelectionRange.key(tablePosition.getRow(), tablePosition.getColumn());
                this.set.add(l2);
            }
            this.computeRange();
        }

        public void fill(List<TablePosition> list, SpreadsheetView spreadsheetView) {
            this.set.clear();
            this.range = null;
            for (TablePosition tablePosition : list) {
                long l2 = SelectionRange.key(tablePosition.getRow(), tablePosition.getColumn());
                this.set.add(l2);
                if (spreadsheetView.getGrid().isCellDisplaySelection(spreadsheetView.getModelRow(tablePosition.getRow()), spreadsheetView.getModelColumn(tablePosition.getColumn()))) continue;
                return;
            }
            this.computeRange();
        }

        public void fillClipboardRange(List<ClipboardCell> list) {
            this.set.clear();
            this.range = null;
            for (ClipboardCell clipboardCell : list) {
                this.set.add(SelectionRange.key(clipboardCell.getRow(), clipboardCell.getColumn()));
            }
            this.computeRange();
        }

        public GridRange getRange() {
            return this.range;
        }

        public static Long key(int n2, int n3) {
            return (long)n2 << 32 | (long)n3;
        }

        private int getRow(Long l2) {
            return (int)(l2 >> 32);
        }

        private int getColumn(Long l2) {
            return (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
        }

        private void computeRange() {
            this.range = null;
            while (!this.set.isEmpty()) {
                if (this.range != null) {
                    this.range = null;
                    return;
                }
                long l2 = this.set.first();
                this.set.remove(l2);
                int n2 = this.getRow(l2);
                int n3 = this.getColumn(l2);
                while (this.set.contains(SelectionRange.key(n2, n3 + 1))) {
                    this.set.remove(SelectionRange.key(n2, ++n3));
                }
                boolean bl2 = true;
                while (bl2) {
                    int n4;
                    ++n2;
                    for (n4 = this.getColumn(l2); n4 <= n3; ++n4) {
                        if (this.set.contains(SelectionRange.key(n2, n4))) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2) {
                        for (n4 = this.getColumn(l2); n4 <= n3; ++n4) {
                            this.set.remove(SelectionRange.key(n2, n4));
                        }
                        continue;
                    }
                    --n2;
                }
                this.range = new GridRange(this.getRow(l2), n2, this.getColumn(l2), n3);
            }
        }
    }
}

