/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.TranslateTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.SizeConverter;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.controlsfx.control.ToggleSwitch;

public class ToggleSwitchSkin
extends SkinBase<ToggleSwitch> {
    private final StackPane thumb = new StackPane();
    private final StackPane thumbArea = new StackPane();
    private final Label label = new Label();
    private final StackPane labelContainer = new StackPane();
    private final TranslateTransition transition = new TranslateTransition(Duration.millis((double)this.getThumbMoveAnimationTime()), (Node)this.thumb);
    private DoubleProperty thumbMoveAnimationTime;
    private static final CssMetaData<ToggleSwitch, Number> THUMB_MOVE_ANIMATION_TIME = new CssMetaData<ToggleSwitch, Number>("-thumb-move-animation-time", SizeConverter.getInstance(), (Number)200){

        public boolean isSettable(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin toggleSwitchSkin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return toggleSwitchSkin.thumbMoveAnimationTime == null || !toggleSwitchSkin.thumbMoveAnimationTime.isBound();
        }

        public StyleableProperty<Number> getStyleableProperty(ToggleSwitch toggleSwitch) {
            ToggleSwitchSkin toggleSwitchSkin = (ToggleSwitchSkin)toggleSwitch.getSkin();
            return (StyleableProperty)toggleSwitchSkin.thumbMoveAnimationTimeProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public ToggleSwitchSkin(ToggleSwitch toggleSwitch) {
        super((Control)toggleSwitch);
        this.transition.setFromX(0.0);
        this.label.textProperty().bind((ObservableValue)toggleSwitch.textProperty());
        this.getChildren().addAll((Object[])new Node[]{this.labelContainer, this.thumbArea, this.thumb});
        this.labelContainer.getChildren().addAll((Object[])new Node[]{this.label});
        StackPane.setAlignment((Node)this.label, (Pos)Pos.CENTER_LEFT);
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.thumbArea.getStyleClass().setAll((Object[])new String[]{"thumb-area"});
        toggleSwitch.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (keyEvent.getCode() == KeyCode.SPACE) {
                this.toggle(toggleSwitch);
            }
        });
        this.thumbArea.setOnMouseReleased(mouseEvent -> this.toggle(toggleSwitch));
        this.thumb.setOnMouseReleased(mouseEvent -> this.toggle(toggleSwitch));
        toggleSwitch.selectedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue() != bl2.booleanValue()) {
                this.selectedStateChanged();
            }
        });
    }

    private void selectedStateChanged() {
        this.transition.stop();
        if (((ToggleSwitch)this.getSkinnable()).isSelected()) {
            this.transition.setRate(1.0);
            this.transition.jumpTo(Duration.ZERO);
        } else {
            this.transition.setRate(-1.0);
            this.transition.jumpTo(this.transition.getDuration());
        }
        this.transition.play();
    }

    private void toggle(ToggleSwitch toggleSwitch) {
        toggleSwitch.setSelected(!toggleSwitch.isSelected());
    }

    private DoubleProperty thumbMoveAnimationTimeProperty() {
        if (this.thumbMoveAnimationTime == null) {
            this.thumbMoveAnimationTime = new StyleableDoubleProperty(200.0){

                protected void invalidated() {
                    double d2 = this.get();
                    if (d2 <= 0.0) {
                        d2 = 1.0;
                    }
                    ToggleSwitchSkin.this.transition.setDuration(Duration.millis((double)d2));
                }

                public Object getBean() {
                    return ToggleSwitchSkin.this;
                }

                public String getName() {
                    return "thumbMoveAnimationTime";
                }

                public CssMetaData<ToggleSwitch, Number> getCssMetaData() {
                    return THUMB_MOVE_ANIMATION_TIME;
                }
            };
        }
        return this.thumbMoveAnimationTime;
    }

    private double getThumbMoveAnimationTime() {
        return this.thumbMoveAnimationTime == null ? 200.0 : this.thumbMoveAnimationTime.get();
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        ToggleSwitch toggleSwitch = (ToggleSwitch)this.getSkinnable();
        double d6 = this.snapSizeX(this.thumb.prefWidth(-1.0));
        double d7 = this.snapSizeY(this.thumb.prefHeight(-1.0));
        this.thumb.resize(d6, d7);
        double d8 = this.snapSizeX(this.thumbArea.prefWidth(-1.0));
        double d9 = this.snapSizeY(this.thumbArea.prefHeight(-1.0));
        double d10 = this.snapPositionY(d3 + d5 / 2.0 - d9 / 2.0);
        this.thumbArea.resize(d8, d9);
        this.thumbArea.setLayoutX(d4 - d8);
        this.thumbArea.setLayoutY(d10);
        this.labelContainer.resize(d4 - d8, d9);
        this.labelContainer.setLayoutY(d10);
        this.thumb.setLayoutX(this.thumbArea.getLayoutX());
        this.thumb.setLayoutY(d10 + (d9 - d7) / 2.0);
        double d11 = d8 - d6;
        this.transition.setToX(d11);
        if (this.transition.getStatus() == Animation.Status.RUNNING) {
            Duration duration = this.transition.getCurrentTime();
            this.transition.stop();
            this.transition.playFrom(duration);
        } else {
            this.thumb.setTranslateX(toggleSwitch.isSelected() ? d11 : 0.0);
        }
    }

    protected double computeMinWidth(double d2, double d3, double d4, double d5, double d6) {
        return d6 + this.label.prefWidth(-1.0) + this.thumbArea.prefWidth(-1.0) + d4;
    }

    protected double computeMinHeight(double d2, double d3, double d4, double d5, double d6) {
        return d3 + Math.max(this.thumb.prefHeight(-1.0), this.label.prefHeight(-1.0)) + d5;
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        return d6 + this.label.prefWidth(-1.0) + 20.0 + this.thumbArea.prefWidth(-1.0) + d4;
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        return d3 + Math.max(this.thumb.prefHeight(-1.0), this.label.prefHeight(-1.0)) + d5;
    }

    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return ((ToggleSwitch)this.getSkinnable()).prefWidth(d2);
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return ((ToggleSwitch)this.getSkinnable()).prefHeight(d2);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ToggleSwitchSkin.getClassCssMetaData();
    }

    static {
        ArrayList<CssMetaData<ToggleSwitch, Number>> arrayList = new ArrayList<CssMetaData<ToggleSwitch, Number>>(SkinBase.getClassCssMetaData());
        arrayList.add(THUMB_MOVE_ANIMATION_TIME);
        STYLEABLES = Collections.unmodifiableList(arrayList);
    }
}

