/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.Duration;
import org.controlsfx.control.InfoOverlay;

public class InfoOverlaySkin
extends SkinBase<InfoOverlay> {
    private final ImageView EXPAND_IMAGE = new ImageView(new Image(InfoOverlay.class.getResource("expand.png").toExternalForm()));
    private final ImageView COLLAPSE_IMAGE = new ImageView(new Image(InfoOverlay.class.getResource("collapse.png").toExternalForm()));
    private static final Duration TRANSITION_DURATION = new Duration(350.0);
    private Node content;
    private Label infoLabel;
    private HBox infoPanel;
    private ToggleButton expandCollapseButton;
    private Timeline timeline;
    private DoubleProperty transition = new SimpleDoubleProperty((Object)this, "transition", 0.0){

        protected void invalidated() {
            ((InfoOverlay)InfoOverlaySkin.this.getSkinnable()).requestLayout();
        }
    };

    public InfoOverlaySkin(final InfoOverlay infoOverlay) {
        super((Control)infoOverlay);
        this.content = infoOverlay.getContent();
        infoOverlay.hoverProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl2, Boolean bl3) {
                if (infoOverlay.isShowOnHover() && (bl3.booleanValue() && !InfoOverlaySkin.this.isExpanded() || !bl3.booleanValue() && InfoOverlaySkin.this.isExpanded())) {
                    InfoOverlaySkin.this.doToggle();
                }
            }
        });
        this.infoLabel = new Label();
        this.infoLabel.setWrapText(true);
        this.infoLabel.setAlignment(Pos.TOP_LEFT);
        this.infoLabel.getStyleClass().add((Object)"info");
        this.infoLabel.textProperty().bind((ObservableValue)infoOverlay.textProperty());
        this.expandCollapseButton = new ToggleButton();
        this.expandCollapseButton.setMouseTransparent(true);
        this.expandCollapseButton.visibleProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)infoOverlay.showOnHoverProperty()));
        this.expandCollapseButton.managedProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)infoOverlay.showOnHoverProperty()));
        this.updateToggleButton();
        this.infoPanel = new HBox(new Node[]{this.infoLabel, this.expandCollapseButton});
        this.infoPanel.setAlignment(Pos.TOP_LEFT);
        this.infoPanel.setFillHeight(true);
        this.infoPanel.getStyleClass().add((Object)"info-panel");
        this.infoPanel.setCursor(Cursor.HAND);
        this.infoPanel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (!infoOverlay.isShowOnHover()) {
                    InfoOverlaySkin.this.doToggle();
                }
            }
        });
        this.getChildren().addAll((Object[])new Node[]{this.content, this.infoPanel});
        this.registerChangeListener((ObservableValue)infoOverlay.contentProperty(), observableValue -> {
            this.getChildren().remove(0);
            this.getChildren().add(0, (Object)((InfoOverlay)this.getSkinnable()).getContent());
            ((InfoOverlay)this.getSkinnable()).requestLayout();
        });
    }

    private void doToggle() {
        this.expandCollapseButton.setSelected(!this.expandCollapseButton.isSelected());
        this.toggleInfoPanel();
        this.updateToggleButton();
    }

    private boolean isExpanded() {
        return this.expandCollapseButton.isSelected();
    }

    protected void layoutChildren(double d2, double d3, double d4, double d5) {
        double d6 = this.content.prefHeight(d4);
        double d7 = this.expandCollapseButton.prefWidth(-1.0);
        this.expandCollapseButton.setMinWidth(d7);
        Insets insets = this.infoPanel.getPadding();
        double d8 = this.snapSize(d4 - d7 - insets.getLeft() - insets.getRight());
        double d9 = (this.snapSize(this.infoLabel.prefHeight(d8)) + this.snapSpace(this.infoPanel.getPadding().getTop()) + this.snapSpace(this.infoPanel.getPadding().getBottom())) * this.transition.get();
        this.infoLabel.setMaxWidth(d8);
        this.infoLabel.setMaxHeight(d9);
        this.layoutInArea(this.content, d2, d3, d4, d5, -1.0, HPos.CENTER, VPos.TOP);
        this.layoutInArea((Node)this.infoPanel, d2, this.snapPosition(d6 - d9), d4, d9, 0.0, HPos.CENTER, VPos.BOTTOM);
    }

    private void updateToggleButton() {
        if (this.expandCollapseButton.isSelected()) {
            this.expandCollapseButton.getStyleClass().setAll((Object[])new String[]{"collapse-button"});
            this.expandCollapseButton.setGraphic((Node)this.COLLAPSE_IMAGE);
        } else {
            this.expandCollapseButton.getStyleClass().setAll((Object[])new String[]{"expand-button"});
            this.expandCollapseButton.setGraphic((Node)this.EXPAND_IMAGE);
        }
    }

    protected double computePrefHeight(double d2, double d3, double d4, double d5, double d6) {
        double d7 = d3 + d5;
        return d7 + (this.content == null ? 0.0 : this.content.prefHeight(d2));
    }

    protected double computePrefWidth(double d2, double d3, double d4, double d5, double d6) {
        double d7 = d6 + d4;
        return d7 + (this.content == null ? 0.0 : this.content.prefWidth(d2));
    }

    protected double computeMaxHeight(double d2, double d3, double d4, double d5, double d6) {
        return this.computePrefHeight(d2, d3, d4, d5, d6);
    }

    protected double computeMaxWidth(double d2, double d3, double d4, double d5, double d6) {
        return this.computePrefWidth(d2, d3, d4, d5, d6);
    }

    private void toggleInfoPanel() {
        KeyFrame keyFrame;
        KeyFrame keyFrame2;
        Duration duration;
        if (this.content == null) {
            return;
        }
        if (this.timeline != null && this.timeline.getStatus() != Animation.Status.STOPPED) {
            duration = this.timeline.getCurrentTime();
            this.timeline.stop();
        } else {
            duration = TRANSITION_DURATION;
        }
        this.timeline = new Timeline();
        this.timeline.setCycleCount(1);
        if (this.isExpanded()) {
            keyFrame2 = new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)0)});
            keyFrame = new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)1, Interpolator.LINEAR)});
        } else {
            keyFrame2 = new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)1)});
            keyFrame = new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)0, Interpolator.LINEAR)});
        }
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{keyFrame2, keyFrame});
        this.timeline.play();
    }
}

