/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2;

import com.sun.xml.bind.Util;
import com.sun.xml.bind.v2.Messages;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClassFactory {
    private static final Class[] emptyClass = new Class[0];
    private static final Object[] emptyObject = new Object[0];
    private static final Logger logger = Util.getClassLogger();
    private static final ThreadLocal<Map<Class, WeakReference<Constructor>>> tls = new ThreadLocal<Map<Class, WeakReference<Constructor>>>(){

        @Override
        public Map<Class, WeakReference<Constructor>> initialValue() {
            return new WeakHashMap<Class, WeakReference<Constructor>>();
        }
    };

    public static void cleanCache() {
        if (tls != null) {
            try {
                tls.remove();
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, "Unable to clean Thread Local cache of classes used in Unmarshaller: {0}", exception.getLocalizedMessage());
            }
        }
    }

    public static <T> T create0(final Class<T> clazz) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Map<Class, WeakReference<Constructor>> map = tls.get();
        Constructor constructor = null;
        WeakReference<Constructor> weakReference = map.get(clazz);
        if (weakReference != null) {
            constructor = (Constructor)weakReference.get();
        }
        if (constructor == null) {
            constructor = System.getSecurityManager() == null ? ClassFactory.tryGetDeclaredConstructor(clazz) : (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<T>>(){

                @Override
                public Constructor<T> run() {
                    return ClassFactory.tryGetDeclaredConstructor(clazz);
                }
            });
            int n2 = clazz.getModifiers();
            if (!Modifier.isPublic(n2) || !Modifier.isPublic(constructor.getModifiers())) {
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    logger.log(Level.FINE, "Unable to make the constructor of " + clazz + " accessible", securityException);
                    throw securityException;
                }
            }
            map.put(clazz, new WeakReference<Constructor>(constructor));
        }
        return constructor.newInstance(emptyObject);
    }

    private static <T> Constructor<T> tryGetDeclaredConstructor(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(emptyClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.log(Level.INFO, "No default constructor found on " + clazz, noSuchMethodException);
            NoSuchMethodError noSuchMethodError = clazz.getDeclaringClass() != null && !Modifier.isStatic(clazz.getModifiers()) ? new NoSuchMethodError(Messages.NO_DEFAULT_CONSTRUCTOR_IN_INNER_CLASS.format(clazz.getName())) : new NoSuchMethodError(noSuchMethodException.getMessage());
            noSuchMethodError.initCause(noSuchMethodException);
            throw noSuchMethodError;
        }
    }

    public static <T> T create(Class<T> clazz) {
        try {
            return ClassFactory.create0(clazz);
        }
        catch (InstantiationException instantiationException) {
            logger.log(Level.INFO, "failed to create a new instance of " + clazz, instantiationException);
            throw new InstantiationError(instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.INFO, "failed to create a new instance of " + clazz, illegalAccessException);
            throw new IllegalAccessError(illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new IllegalStateException(throwable);
        }
    }

    public static Object create(Method method) {
        Throwable throwable;
        try {
            return method.invoke(null, emptyObject);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable2 = invocationTargetException.getTargetException();
            if (throwable2 instanceof RuntimeException) {
                throw (RuntimeException)throwable2;
            }
            if (throwable2 instanceof Error) {
                throw (Error)throwable2;
            }
            throw new IllegalStateException(throwable2);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.INFO, "failed to create a new instance of " + method.getReturnType().getName(), illegalAccessException);
            throw new IllegalAccessError(illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.log(Level.INFO, "failed to create a new instance of " + method.getReturnType().getName(), illegalArgumentException);
            throwable = illegalArgumentException;
        }
        catch (NullPointerException nullPointerException) {
            logger.log(Level.INFO, "failed to create a new instance of " + method.getReturnType().getName(), nullPointerException);
            throwable = nullPointerException;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            logger.log(Level.INFO, "failed to create a new instance of " + method.getReturnType().getName(), exceptionInInitializerError);
            throwable = exceptionInInitializerError;
        }
        NoSuchMethodError noSuchMethodError = new NoSuchMethodError(throwable.getMessage());
        noSuchMethodError.initCause(throwable);
        throw noSuchMethodError;
    }

    public static <T> Class<? extends T> inferImplClass(Class<T> clazz, Class[] classArray) {
        if (!clazz.isInterface()) {
            return clazz;
        }
        for (Class clazz2 : classArray) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return clazz2.asSubclass(clazz);
        }
        return null;
    }
}

