/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.animation.alert;

import com.jfoenix.animation.alert.CenterTransition;
import com.jfoenix.animation.alert.HorizontalTransition;
import com.jfoenix.animation.alert.VerticalTransition;
import com.jfoenix.transitions.CachedTransition;
import java.util.function.Function;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.util.Duration;

public interface JFXAlertAnimation {
    public static final Function<Transition, Transition> inverseAnimation = transition -> {
        transition.jumpTo(transition.getCycleDuration());
        transition.setRate(-1.0);
        return transition;
    };
    public static final JFXAlertAnimation LEFT_ANIMATION = new JFXAlertAnimation(){

        @Override
        public void initAnimation(Node node, Node node2) {
            node2.setOpacity(0.0);
            node.setTranslateX(-(node.getLayoutX() + node.getLayoutBounds().getMaxX()));
        }

        @Override
        public Animation createShowingAnimation(Node node, Node node2) {
            return new HorizontalTransition(true, node, node2);
        }

        @Override
        public Animation createHidingAnimation(Node node, Node node2) {
            return (Animation)inverseAnimation.apply(new HorizontalTransition(true, node, node2));
        }
    };
    public static final JFXAlertAnimation RIGHT_ANIMATION = new JFXAlertAnimation(){

        @Override
        public void initAnimation(Node node, Node node2) {
            node2.setOpacity(0.0);
            node.setTranslateX(node.getLayoutX() + node.getLayoutBounds().getMaxX());
        }

        @Override
        public Animation createShowingAnimation(Node node, Node node2) {
            return new HorizontalTransition(false, node, node2);
        }

        @Override
        public Animation createHidingAnimation(Node node, Node node2) {
            return (Animation)inverseAnimation.apply(new HorizontalTransition(false, node, node2));
        }
    };
    public static final JFXAlertAnimation TOP_ANIMATION = new JFXAlertAnimation(){

        @Override
        public void initAnimation(Node node, Node node2) {
            node2.setOpacity(0.0);
            node.setTranslateY(-(node.getLayoutY() + node.getLayoutBounds().getMaxY()));
        }

        @Override
        public Animation createShowingAnimation(Node node, Node node2) {
            return new VerticalTransition(true, node, node2);
        }

        @Override
        public Animation createHidingAnimation(Node node, Node node2) {
            return (Animation)inverseAnimation.apply(new VerticalTransition(true, node, node2));
        }
    };
    public static final JFXAlertAnimation BOTTOM_ANIMATION = new JFXAlertAnimation(){

        @Override
        public void initAnimation(Node node, Node node2) {
            node2.setOpacity(0.0);
            node.setTranslateY(node.getLayoutY() + node.getLayoutBounds().getMaxY());
        }

        @Override
        public Animation createShowingAnimation(Node node, Node node2) {
            return new VerticalTransition(false, node, node2);
        }

        @Override
        public Animation createHidingAnimation(Node node, Node node2) {
            return (Animation)inverseAnimation.apply(new VerticalTransition(false, node, node2));
        }
    };
    public static final JFXAlertAnimation CENTER_ANIMATION = new JFXAlertAnimation(){

        @Override
        public void initAnimation(Node node, Node node2) {
            node2.setOpacity(0.0);
            node.setScaleX(0.0);
            node.setScaleY(0.0);
        }

        @Override
        public Animation createShowingAnimation(Node node, Node node2) {
            return new CenterTransition(node, node2);
        }

        @Override
        public Animation createHidingAnimation(Node node, Node node2) {
            return (Animation)inverseAnimation.apply(new CenterTransition(node, node2));
        }
    };
    public static final JFXAlertAnimation NO_ANIMATION = new JFXAlertAnimation(){

        @Override
        public void initAnimation(Node node, Node node2) {
        }

        @Override
        public Animation createShowingAnimation(Node node, Node node2) {
            return null;
        }

        @Override
        public Animation createHidingAnimation(Node node, Node node2) {
            return null;
        }
    };
    public static final JFXAlertAnimation SMOOTH = new JFXAlertAnimation(){

        @Override
        public void initAnimation(Node node, Node node2) {
            node2.setOpacity(0.0);
            node.setScaleX(0.8);
            node.setScaleY(0.8);
        }

        @Override
        public Animation createShowingAnimation(Node node, Node node2) {
            return new CachedTransition(node, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)node.scaleXProperty(), (Object)1, Interpolator.EASE_OUT), new KeyValue((WritableValue)node.scaleYProperty(), (Object)1, Interpolator.EASE_OUT), new KeyValue((WritableValue)node2.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)})})){
                {
                    this.setCycleDuration(Duration.millis((double)160.0));
                    this.setDelay(Duration.seconds((double)0.0));
                }
            };
        }

        @Override
        public Animation createHidingAnimation(Node node, Node node2) {
            return new CachedTransition(node, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)node2.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)})})){
                {
                    this.setCycleDuration(Duration.millis((double)160.0));
                    this.setDelay(Duration.seconds((double)0.0));
                }
            };
        }
    };

    public void initAnimation(Node var1, Node var2);

    public Animation createShowingAnimation(Node var1, Node var2);

    public Animation createHidingAnimation(Node var1, Node var2);
}

