/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.utils;

import com.github.scribejava.core.utils.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;

public abstract class StreamUtils {
    public static String getStreamContents(InputStream inputStream) throws IOException {
        Preconditions.checkNotNull(inputStream, "Cannot get String from a null object");
        char[] cArray = new char[65536];
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");){
            int n2;
            do {
                if ((n2 = ((Reader)inputStreamReader).read(cArray, 0, cArray.length)) <= 0) continue;
                stringBuilder.append(cArray, 0, n2);
            } while (n2 >= 0);
        }
        return stringBuilder.toString();
    }

    public static String getGzipStreamContents(InputStream inputStream) throws IOException {
        Preconditions.checkNotNull(inputStream, "Cannot get String from a null object");
        GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
        return StreamUtils.getStreamContents(gZIPInputStream);
    }
}

