/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class Response {
    private final int code;
    private final String message;
    private final Map<String, String> headers;
    private String body;
    private InputStream stream;

    private Response(int n2, String string, Map<String, String> map) {
        this.code = n2;
        this.message = string;
        this.headers = map;
    }

    public Response(int n2, String string, Map<String, String> map, InputStream inputStream) {
        this(n2, string, map);
        this.stream = inputStream;
    }

    public Response(int n2, String string, Map<String, String> map, String string2) {
        this(n2, string, map);
        this.body = string2;
    }

    private String parseBodyContents() throws IOException {
        if (this.stream == null) {
            return null;
        }
        this.body = "gzip".equals(this.getHeader("Content-Encoding")) ? StreamUtils.getGzipStreamContents(this.stream) : StreamUtils.getStreamContents(this.stream);
        return this.body;
    }

    public final boolean isSuccessful() {
        return this.code >= 200 && this.code < 400;
    }

    public String getBody() throws IOException {
        return this.body == null ? this.parseBodyContents() : this.body;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public final int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String string) {
        return this.headers.get(string);
    }

    public String toString() {
        return "Response{code=" + this.code + ", message='" + this.message + '\'' + ", body='" + this.body + '\'' + ", headers=" + this.headers + '}';
    }
}

