/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.introspect.ConcreteBeanPropertyBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ExternalTypeHandler {
    private final JavaType _beanType;
    private final ExtTypedProperty[] _properties;
    private final Map<String, Object> _nameToPropertyIndex;
    private final String[] _typeIds;
    private final TokenBuffer[] _tokens;

    protected ExternalTypeHandler(JavaType javaType, ExtTypedProperty[] extTypedPropertyArray, Map<String, Object> map, String[] stringArray, TokenBuffer[] tokenBufferArray) {
        this._beanType = javaType;
        this._properties = extTypedPropertyArray;
        this._nameToPropertyIndex = map;
        this._typeIds = stringArray;
        this._tokens = tokenBufferArray;
    }

    protected ExternalTypeHandler(ExternalTypeHandler externalTypeHandler) {
        this._beanType = externalTypeHandler._beanType;
        this._properties = externalTypeHandler._properties;
        this._nameToPropertyIndex = externalTypeHandler._nameToPropertyIndex;
        int n2 = this._properties.length;
        this._typeIds = new String[n2];
        this._tokens = new TokenBuffer[n2];
    }

    public static Builder builder(JavaType javaType) {
        return new Builder(javaType);
    }

    public ExternalTypeHandler start() {
        return new ExternalTypeHandler(this);
    }

    public boolean handleTypePropertyValue(JsonParser jsonParser, DeserializationContext deserializationContext, String string, Object object) throws IOException {
        Object object2 = this._nameToPropertyIndex.get(string);
        if (object2 == null) {
            return false;
        }
        String string2 = jsonParser.getText();
        if (object2 instanceof List) {
            boolean bl2 = false;
            for (Integer n2 : (List)object2) {
                if (!this._handleTypePropertyValue(jsonParser, deserializationContext, string, object, string2, n2)) continue;
                bl2 = true;
            }
            return bl2;
        }
        return this._handleTypePropertyValue(jsonParser, deserializationContext, string, object, string2, (Integer)object2);
    }

    private final boolean _handleTypePropertyValue(JsonParser jsonParser, DeserializationContext deserializationContext, String string, Object object, String string2, int n2) throws IOException {
        boolean bl2;
        ExtTypedProperty extTypedProperty = this._properties[n2];
        if (!extTypedProperty.hasTypePropertyName(string)) {
            return false;
        }
        boolean bl3 = bl2 = object != null && this._tokens[n2] != null;
        if (bl2) {
            this._deserializeAndSet(jsonParser, deserializationContext, object, n2, string2);
            this._tokens[n2] = null;
        } else {
            this._typeIds[n2] = string2;
        }
        return true;
    }

    public boolean handlePropertyValue(JsonParser jsonParser, DeserializationContext deserializationContext, String string, Object object) throws IOException {
        Object object2;
        boolean bl2;
        Object object3 = this._nameToPropertyIndex.get(string);
        if (object3 == null) {
            return false;
        }
        if (object3 instanceof List) {
            Iterator iterator = ((List)object3).iterator();
            Integer n2 = (Integer)iterator.next();
            ExtTypedProperty extTypedProperty = this._properties[n2];
            if (extTypedProperty.hasTypePropertyName(string)) {
                String string2 = jsonParser.getText();
                jsonParser.skipChildren();
                this._typeIds[n2.intValue()] = string2;
                while (iterator.hasNext()) {
                    this._typeIds[((Integer)iterator.next()).intValue()] = string2;
                }
            } else {
                TokenBuffer tokenBuffer;
                this._tokens[n2.intValue()] = tokenBuffer = deserializationContext.bufferAsCopyOfValue(jsonParser);
                while (iterator.hasNext()) {
                    this._tokens[((Integer)iterator.next()).intValue()] = tokenBuffer;
                }
            }
            return true;
        }
        int n3 = (Integer)object3;
        ExtTypedProperty extTypedProperty = this._properties[n3];
        if (extTypedProperty.hasTypePropertyName(string)) {
            this._typeIds[n3] = jsonParser.getValueAsString();
            jsonParser.skipChildren();
            bl2 = object != null && this._tokens[n3] != null;
        } else {
            object2 = deserializationContext.bufferAsCopyOfValue(jsonParser);
            this._tokens[n3] = object2;
            boolean bl3 = bl2 = object != null && this._typeIds[n3] != null;
        }
        if (bl2) {
            object2 = this._typeIds[n3];
            this._typeIds[n3] = null;
            this._deserializeAndSet(jsonParser, deserializationContext, object, n3, (String)object2);
            this._tokens[n3] = null;
        }
        return true;
    }

    public Object complete(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) throws IOException {
        int n2 = this._properties.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2;
            String string = this._typeIds[i2];
            ExtTypedProperty extTypedProperty = this._properties[i2];
            if (string == null) {
                object2 = this._tokens[i2];
                if (object2 == null) continue;
                JsonToken jsonToken = ((TokenBuffer)object2).firstToken();
                if (jsonToken.isScalarValue()) {
                    JsonParser jsonParser2 = ((TokenBuffer)object2).asParser(jsonParser);
                    jsonParser2.nextToken();
                    SettableBeanProperty settableBeanProperty = extTypedProperty.getProperty();
                    Object object3 = TypeDeserializer.deserializeIfNatural(jsonParser2, deserializationContext, settableBeanProperty.getType());
                    if (object3 != null) {
                        settableBeanProperty.set(object, object3);
                        continue;
                    }
                }
                if (!extTypedProperty.hasDefaultType()) {
                    deserializationContext.reportPropertyInputMismatch(this._beanType, extTypedProperty.getProperty().getName(), "Missing external type id property '%s' (and no 'defaultImpl' specified)", extTypedProperty.getTypePropertyName());
                } else {
                    string = extTypedProperty.getDefaultTypeId();
                    if (string == null) {
                        deserializationContext.reportPropertyInputMismatch(this._beanType, extTypedProperty.getProperty().getName(), "Invalid default type id for property '%s': `null` returned by TypeIdResolver", extTypedProperty.getTypePropertyName());
                    }
                }
            } else if (this._tokens[i2] == null) {
                object2 = extTypedProperty.getProperty();
                if (((ConcreteBeanPropertyBase)object2).isRequired() || deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY)) {
                    deserializationContext.reportPropertyInputMismatch(object.getClass(), ((SettableBeanProperty)object2).getName(), "Missing property '%s' for external type id '%s'", ((SettableBeanProperty)object2).getName(), extTypedProperty.getTypePropertyName());
                }
                return object;
            }
            this._deserializeAndSet(jsonParser, deserializationContext, object, i2, string);
        }
        return object;
    }

    public Object complete(JsonParser jsonParser, DeserializationContext deserializationContext, PropertyValueBuffer propertyValueBuffer, PropertyBasedCreator propertyBasedCreator) throws IOException {
        Object object;
        int n2 = this._properties.length;
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2;
            Object object3;
            String string = this._typeIds[i2];
            object = this._properties[i2];
            if (string == null) {
                object3 = this._tokens[i2];
                if (object3 == null || ((TokenBuffer)object3).firstToken() == JsonToken.VALUE_NULL) continue;
                if (!((ExtTypedProperty)object).hasDefaultType()) {
                    deserializationContext.reportPropertyInputMismatch(this._beanType, ((ExtTypedProperty)object).getProperty().getName(), "Missing external type id property '%s'", ((ExtTypedProperty)object).getTypePropertyName());
                } else {
                    string = ((ExtTypedProperty)object).getDefaultTypeId();
                }
            }
            if (this._tokens[i2] != null) {
                objectArray[i2] = this._deserialize(jsonParser, deserializationContext, i2, string);
            } else {
                if (deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY)) {
                    object3 = ((ExtTypedProperty)object).getProperty();
                    deserializationContext.reportPropertyInputMismatch(this._beanType, ((SettableBeanProperty)object3).getName(), "Missing property '%s' for external type id '%s'", ((SettableBeanProperty)object3).getName(), this._properties[i2].getTypePropertyName());
                }
                objectArray[i2] = this._deserializeMissingToken(jsonParser, deserializationContext, i2, string);
            }
            object3 = ((ExtTypedProperty)object).getProperty();
            if (((SettableBeanProperty)object3).getCreatorIndex() < 0) continue;
            propertyValueBuffer.assignParameter((SettableBeanProperty)object3, objectArray[i2]);
            SettableBeanProperty settableBeanProperty = ((ExtTypedProperty)object).getTypeProperty();
            if (settableBeanProperty == null || settableBeanProperty.getCreatorIndex() < 0) continue;
            if (settableBeanProperty.getType().hasRawClass(String.class)) {
                object2 = string;
            } else {
                TokenBuffer tokenBuffer = deserializationContext.bufferForInputBuffering(jsonParser);
                tokenBuffer.writeString(string);
                object2 = settableBeanProperty.getValueDeserializer().deserialize(tokenBuffer.asParserOnFirstToken(), deserializationContext);
                tokenBuffer.close();
            }
            propertyValueBuffer.assignParameter(settableBeanProperty, object2);
        }
        Object object4 = propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        for (int i3 = 0; i3 < n2; ++i3) {
            object = this._properties[i3].getProperty();
            if (((SettableBeanProperty)object).getCreatorIndex() >= 0) continue;
            ((SettableBeanProperty)object).set(object4, objectArray[i3]);
        }
        return object4;
    }

    protected final Object _deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, int n2, String string) throws IOException {
        JsonParser jsonParser2 = this._tokens[n2].asParser(jsonParser);
        JsonToken jsonToken = jsonParser2.nextToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        TokenBuffer tokenBuffer = deserializationContext.bufferForInputBuffering(jsonParser);
        tokenBuffer.writeStartArray();
        tokenBuffer.writeString(string);
        tokenBuffer.copyCurrentStructure(jsonParser2);
        tokenBuffer.writeEndArray();
        JsonParser jsonParser3 = tokenBuffer.asParser(jsonParser);
        jsonParser3.nextToken();
        return this._properties[n2].getProperty().deserialize(jsonParser3, deserializationContext);
    }

    protected final Object _deserializeMissingToken(JsonParser jsonParser, DeserializationContext deserializationContext, int n2, String string) throws IOException {
        TokenBuffer tokenBuffer = deserializationContext.bufferForInputBuffering(jsonParser);
        tokenBuffer.writeStartArray();
        tokenBuffer.writeString(string);
        tokenBuffer.writeEndArray();
        JsonParser jsonParser2 = tokenBuffer.asParser(jsonParser);
        jsonParser2.nextToken();
        return this._properties[n2].getProperty().deserialize(jsonParser2, deserializationContext);
    }

    protected final void _deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, int n2, String string) throws IOException {
        JsonParser jsonParser2;
        JsonToken jsonToken;
        if (string == null) {
            deserializationContext.reportInputMismatch(this._beanType, "Internal error in external Type Id handling: `null` type id passed", new Object[0]);
        }
        if ((jsonToken = (jsonParser2 = this._tokens[n2].asParser(jsonParser)).nextToken()) == JsonToken.VALUE_NULL) {
            this._properties[n2].getProperty().set(object, null);
            return;
        }
        TokenBuffer tokenBuffer = deserializationContext.bufferForInputBuffering(jsonParser);
        tokenBuffer.writeStartArray();
        tokenBuffer.writeString(string);
        tokenBuffer.copyCurrentStructure(jsonParser2);
        tokenBuffer.writeEndArray();
        JsonParser jsonParser3 = tokenBuffer.asParser(jsonParser);
        jsonParser3.nextToken();
        this._properties[n2].getProperty().deserializeAndSet(jsonParser3, deserializationContext, object);
    }

    private static final class ExtTypedProperty {
        private final SettableBeanProperty _property;
        private final TypeDeserializer _typeDeserializer;
        private final String _typePropertyName;
        private SettableBeanProperty _typeProperty;

        public ExtTypedProperty(SettableBeanProperty settableBeanProperty, TypeDeserializer typeDeserializer) {
            this._property = settableBeanProperty;
            this._typeDeserializer = typeDeserializer;
            this._typePropertyName = typeDeserializer.getPropertyName();
        }

        public void linkTypeProperty(SettableBeanProperty settableBeanProperty) {
            this._typeProperty = settableBeanProperty;
        }

        public boolean hasTypePropertyName(String string) {
            return string.equals(this._typePropertyName);
        }

        public boolean hasDefaultType() {
            return this._typeDeserializer.hasDefaultImpl();
        }

        public String getDefaultTypeId() {
            Class<?> clazz = this._typeDeserializer.getDefaultImpl();
            if (clazz == null) {
                return null;
            }
            return this._typeDeserializer.getTypeIdResolver().idFromValueAndType(null, clazz);
        }

        public String getTypePropertyName() {
            return this._typePropertyName;
        }

        public SettableBeanProperty getProperty() {
            return this._property;
        }

        public SettableBeanProperty getTypeProperty() {
            return this._typeProperty;
        }
    }

    public static class Builder {
        private final JavaType _beanType;
        private final List<ExtTypedProperty> _properties = new ArrayList<ExtTypedProperty>();
        private final Map<String, Object> _nameToPropertyIndex = new HashMap<String, Object>();

        protected Builder(JavaType javaType) {
            this._beanType = javaType;
        }

        public void addExternal(SettableBeanProperty settableBeanProperty, TypeDeserializer typeDeserializer) {
            Integer n2 = this._properties.size();
            this._properties.add(new ExtTypedProperty(settableBeanProperty, typeDeserializer));
            this._addPropertyIndex(settableBeanProperty.getName(), n2);
            this._addPropertyIndex(typeDeserializer.getPropertyName(), n2);
        }

        private void _addPropertyIndex(String string, Integer n2) {
            Object object = this._nameToPropertyIndex.get(string);
            if (object == null) {
                this._nameToPropertyIndex.put(string, n2);
            } else if (object instanceof List) {
                List list = (List)object;
                list.add(n2);
            } else {
                LinkedList<Object> linkedList = new LinkedList<Object>();
                linkedList.add(object);
                linkedList.add(n2);
                this._nameToPropertyIndex.put(string, linkedList);
            }
        }

        public ExternalTypeHandler build(BeanPropertyMap beanPropertyMap) {
            int n2 = this._properties.size();
            ExtTypedProperty[] extTypedPropertyArray = new ExtTypedProperty[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                ExtTypedProperty extTypedProperty = this._properties.get(i2);
                String string = extTypedProperty.getTypePropertyName();
                SettableBeanProperty settableBeanProperty = beanPropertyMap.find(string);
                if (settableBeanProperty != null) {
                    extTypedProperty.linkTypeProperty(settableBeanProperty);
                }
                extTypedPropertyArray[i2] = extTypedProperty;
            }
            return new ExternalTypeHandler(this._beanType, extTypedPropertyArray, this._nameToPropertyIndex, null, null);
        }
    }
}

