/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.theme;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.stream.Stream;
import javafx.css.Stylesheet;

public class ThemeCompiler {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                throw new IllegalArgumentException("You must provide the source directory path");
            }
            if (stringArray.length > 1) {
                throw new IllegalArgumentException("Unexpected arguments were found: " + Arrays.toString(Arrays.copyOfRange(stringArray, 1, stringArray.length)));
            }
            Path path = Paths.get(stringArray[0], new String[0]);
            new ThemeCompiler().convertToBinary(path);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    public void convertToBinary(Path path2) throws IOException {
        if (path2 == null || !Files.exists(path2, new LinkOption[0]) || !Files.isDirectory(path2, new LinkOption[0])) {
            throw new IllegalArgumentException("Invalid directory: " + path2);
        }
        try (Stream<Path> stream = Files.list(path2);){
            stream.filter(path -> path.toString().endsWith(".css")).forEach(path -> {
                try {
                    this.convertToBinary((Path)path, path.resolveSibling(this.getFilename((Path)path) + ".bss"));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            });
        }
    }

    public void convertToBinary(Path path, Path path2) throws IOException {
        if (path == null || path2 == null) {
            throw new IllegalArgumentException("Both input and output files must be specified.");
        }
        if (path.equals(path2)) {
            throw new IllegalArgumentException("Input file and output file cannot be the same.");
        }
        Stylesheet.convertToBinary((File)path.toFile(), (File)path2.toFile());
    }

    private String getFilename(Path path) {
        String string = path.getFileName().toString();
        return string.substring(0, string.lastIndexOf(46));
    }
}

