function [className] = hebi_load(simpleClassName)
%HEBI_LOAD loads HEBI libraries
%
%   This function loads the necessary binaries into the MATLAB path. It is
%   used internally and should generally not be called by users.

%   Copyright 2014-2016 HEBI Robotics, LLC.

if nargin < 1
   simpleClassName = 'HebiLookup'; 
end

% Load the library if the required class is not yet in the classpath
className = ['us.hebi.sdk.matlab.' simpleClassName];
if ~exist(className,'class')
    
    % Get default paths
    config = hebi_config('hebi_load');
    javaaddpath(fullfile(config.libraryPath, [config.libraryVersion '.jar']));

    % Check for version mismatches
    if(~exist(className,'class'))
        error(['Implementation for ' simpleClassName ' was not found. Please check library version']);
    end
end

end
