/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.sdk.lib;

import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicReference;
import us.hebi.sdk.lib.by;
import us.hebi.sdk.lib.cw;
import us.hebi.sdk.lib.de;
import us.hebi.sdk.lib.dp;
import us.hebi.sdk.lib.gy;
import us.hebi.sdk.lib.gz;
import us.hebi.sdk.lib.ho;

public final class gx {
    public static final int HASH_MULT = 33;
    private static final int DEFAULT_T_SIZE = 64;
    private static final int MAX_T_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    static final int MAX_COLL_CHAIN_LENGTH = 150;
    protected final gx _parent;
    protected final AtomicReference<gz> _tableInfo;
    protected final cw _streamReadConstraints;
    protected final int _seed;
    protected final int _factoryFeatures;
    protected boolean _canonicalize;
    protected String[] _symbols;
    protected gy[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected int _longestCollisionList;
    protected boolean _hashShared;
    protected BitSet _overflows;

    private gx(cw cw2, int n2, int n3) {
        this._parent = null;
        this._seed = n3;
        this._streamReadConstraints = cw2;
        this._canonicalize = true;
        this._factoryFeatures = n2;
        this._hashShared = false;
        this._longestCollisionList = 0;
        this._tableInfo = new AtomicReference<gz>(gz.createInitial(64));
    }

    private gx(gx gx2, cw cw2, int n2, int n3, gz gz2) {
        this._parent = gx2;
        this._streamReadConstraints = cw2;
        this._seed = n3;
        this._tableInfo = null;
        this._factoryFeatures = n2;
        this._canonicalize = by.CANONICALIZE_FIELD_NAMES.enabledIn(n2);
        this._symbols = gz2.symbols;
        this._buckets = gz2.buckets;
        this._size = gz2.size;
        this._longestCollisionList = gz2.longestCollisionList;
        int n4 = this._symbols.length;
        this._sizeThreshold = gx._thresholdSize(n4);
        this._indexMask = n4 - 1;
        this._hashShared = true;
    }

    private static int _thresholdSize(int n2) {
        int n3 = n2;
        return n3 - (n3 >> 2);
    }

    @Deprecated
    public static gx createRoot() {
        return gx.createRoot(null);
    }

    @Deprecated
    public static gx createRoot(int n2) {
        return gx.createRoot(null, n2);
    }

    public static gx createRoot(de de2) {
        return gx.createRoot(de2, 0);
    }

    public static gx createRoot(de de2, int n2) {
        int n3;
        cw cw2;
        if (n2 == 0) {
            n2 = System.identityHashCode(de2);
        }
        if (de2 == null) {
            cw2 = cw.defaults();
            n3 = 0;
        } else {
            cw2 = de2.streamReadConstraints();
            n3 = de2.getFactoryFeatures();
        }
        return new gx(cw2, n3, n2);
    }

    public final gx makeChild() {
        gx gx2 = this;
        return new gx(gx2, gx2._streamReadConstraints, this._factoryFeatures, this._seed, this._tableInfo.get());
    }

    @Deprecated
    public final gx makeChild(int n2) {
        return this.makeChild();
    }

    public final void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null && this._canonicalize) {
            this._parent.mergeChild(new gz(this));
            this._hashShared = true;
        }
    }

    private void mergeChild(gz gz2) {
        int n2 = gz2.size;
        gz gz3 = this._tableInfo.get();
        if (n2 == gz3.size) {
            return;
        }
        if (n2 > 12000) {
            gz2 = gz.createInitial(64);
        }
        this._tableInfo.compareAndSet(gz3, gz2);
    }

    public final int size() {
        if (this._tableInfo != null) {
            return this._tableInfo.get().size;
        }
        return this._size;
    }

    public final int bucketCount() {
        return this._symbols.length;
    }

    public final boolean maybeDirty() {
        return !this._hashShared;
    }

    public final int hashSeed() {
        return this._seed;
    }

    public final int collisionCount() {
        int n2 = 0;
        gy[] gyArray = this._buckets;
        int n3 = this._buckets.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            gy gy2 = gyArray[i2];
            if (gy2 == null) continue;
            n2 += gy2.length;
        }
        return n2;
    }

    public final int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public final String findSymbol(char[] cArray, int n2, int n3, int n4) throws IOException {
        if (n3 <= 0) {
            return "";
        }
        if (!this._canonicalize) {
            this._streamReadConstraints.validateNameLength(n3);
            return new String(cArray, n2, n3);
        }
        int n5 = this._hashToIndex(n4);
        String string = this._symbols[n5];
        if (string != null) {
            gy gy2;
            if (string.length() == n3) {
                int n6 = 0;
                while (string.charAt(n6) == cArray[n2 + n6]) {
                    if (++n6 != n3) continue;
                    return string;
                }
            }
            if ((gy2 = this._buckets[n5 >> 1]) != null) {
                string = gy2.has(cArray, n2, n3);
                if (string != null) {
                    return string;
                }
                string = this._findSymbol2(cArray, n2, n3, gy2.next);
                if (string != null) {
                    return string;
                }
            }
        }
        this._streamReadConstraints.validateNameLength(n3);
        return this._addSymbol(cArray, n2, n3, n4, n5);
    }

    private String _findSymbol2(char[] cArray, int n2, int n3, gy gy2) {
        while (gy2 != null) {
            String string = gy2.has(cArray, n2, n3);
            if (string != null) {
                return string;
            }
            gy2 = gy2.next;
        }
        return null;
    }

    private String _addSymbol(char[] cArray, int n2, int n3, int n4, int n5) throws IOException {
        if (this._hashShared) {
            this.copyArrays();
            this._hashShared = false;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            gx gx2 = this;
            n5 = gx2._hashToIndex(gx2.calcHash(cArray, n2, n3));
        }
        String string = new String(cArray, n2, n3);
        if (by.INTERN_FIELD_NAMES.enabledIn(this._factoryFeatures)) {
            string = ho.instance.intern(string);
        }
        ++this._size;
        if (this._symbols[n5] == null) {
            this._symbols[n5] = string;
        } else {
            int n6 = n5 >> 1;
            gy gy2 = new gy(string, this._buckets[n6]);
            int n7 = gy2.length;
            if (n7 > 150) {
                this._handleSpillOverflow(n6, gy2, n5);
            } else {
                this._buckets[n6] = gy2;
                this._longestCollisionList = Math.max(n7, this._longestCollisionList);
            }
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private void _handleSpillOverflow(int var1_1, gy var2_2, int var3_3) throws IOException {
        block3: {
            if (this._overflows != null) break block3;
            this._overflows = new BitSet();
            ** GOTO lbl-1000
        }
        if (this._overflows.get(var1_1)) {
            if (by.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(this._factoryFeatures)) {
                this._reportTooManyCollisions(150);
            }
            this._canonicalize = false;
        } else lbl-1000:
        // 2 sources

        {
            this._overflows.set(var1_1);
        }
        this._symbols[var3_3] = var2_2.symbol;
        this._buckets[var1_1] = null;
        this._size -= var2_2.length;
        this._longestCollisionList = -1;
    }

    public final int _hashToIndex(int n2) {
        int n3 = n2;
        n2 = n3 + (n3 >>> 15);
        n2 ^= n2 << 7;
        return n2 + (n2 >>> 3) & this._indexMask;
    }

    public final int calcHash(char[] cArray, int n2, int n3) {
        int n4 = this._seed;
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; ++i2) {
            n4 = n4 * 33 + cArray[i2];
        }
        if (n4 == 0) {
            return 1;
        }
        return n4;
    }

    public final int calcHash(String string) {
        int n2 = string.length();
        int n3 = this._seed;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = n3 * 33 + string.charAt(i2);
        }
        if (n3 == 0) {
            return 1;
        }
        return n3;
    }

    private void copyArrays() {
        String[] stringArray = this._symbols;
        this._symbols = Arrays.copyOf(stringArray, stringArray.length);
        gy[] gyArray = this._buckets;
        this._buckets = Arrays.copyOf(gyArray, gyArray.length);
    }

    private void rehash() throws IOException {
        int n2;
        int n3 = this._symbols.length;
        int n4 = n3 + n3;
        if (n4 > 65536) {
            this._size = 0;
            this._canonicalize = false;
            this._symbols = new String[64];
            this._buckets = new gy[32];
            this._indexMask = 63;
            this._hashShared = false;
            return;
        }
        String[] stringArray = this._symbols;
        gy[] gyArray = this._buckets;
        this._symbols = new String[n4];
        this._buckets = new gy[n4 >> 1];
        this._indexMask = n4 - 1;
        this._sizeThreshold = gx._thresholdSize(n4);
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            gy gy2;
            String string = stringArray[n2];
            if (string == null) continue;
            ++n5;
            gx gx2 = this;
            int n7 = gx2._hashToIndex(gx2.calcHash(string));
            if (this._symbols[n7] == null) {
                this._symbols[n7] = string;
                continue;
            }
            int n8 = n7 >> 1;
            this._buckets[n8] = gy2 = new gy(string, this._buckets[n8]);
            n6 = Math.max(n6, gy2.length);
        }
        n2 = n3 >> 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            gy gy3 = gyArray[i2];
            while (gy3 != null) {
                ++n5;
                String string = gy3.symbol;
                gx gx3 = this;
                int n9 = gx3._hashToIndex(gx3.calcHash(string));
                if (this._symbols[n9] == null) {
                    this._symbols[n9] = string;
                } else {
                    gy gy4;
                    int n10 = n9 >> 1;
                    this._buckets[n10] = gy4 = new gy(string, this._buckets[n10]);
                    n6 = Math.max(n6, gy4.length);
                }
                gy3 = gy3.next;
            }
        }
        this._longestCollisionList = n6;
        this._overflows = null;
        if (n5 != this._size) {
            throw new IllegalStateException(String.format("Internal error on SymbolTable.rehash(): had %d entries; now have %d", this._size, n5));
        }
    }

    protected final void _reportTooManyCollisions(int n2) throws dp {
        throw new dp("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + n2 + " -- suspect a DoS attack based on hash collisions");
    }

    protected final void verifyInternalConsistency() {
        int n2;
        int n3 = 0;
        int n4 = this._symbols.length;
        for (n2 = 0; n2 < n4; ++n2) {
            if (this._symbols[n2] == null) continue;
            ++n3;
        }
        n2 = n4 >> 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            gy gy2 = this._buckets[i2];
            while (gy2 != null) {
                ++n3;
                gy2 = gy2.next;
            }
        }
        if (n3 != this._size) {
            throw new IllegalStateException(String.format("Internal error: expected internal size %d vs calculated count %d", this._size, n3));
        }
    }
}

