/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.sdk.lib;

import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import us.hebi.sdk.lib.bw;
import us.hebi.sdk.lib.by;
import us.hebi.sdk.lib.cg;
import us.hebi.sdk.lib.cs;
import us.hebi.sdk.lib.dy;
import us.hebi.sdk.lib.ea;
import us.hebi.sdk.lib.eh;
import us.hebi.sdk.lib.el;
import us.hebi.sdk.lib.er;
import us.hebi.sdk.lib.gm;
import us.hebi.sdk.lib.gp;
import us.hebi.sdk.lib.gv;
import us.hebi.sdk.lib.gx;
import us.hebi.sdk.lib.iu;

public final class gd {
    public static final byte UTF8_BOM_1 = -17;
    public static final byte UTF8_BOM_2 = -69;
    public static final byte UTF8_BOM_3 = -65;
    private static final int STRING_READER_BYTE_ARRAY_LENGTH_LIMIT = 8192;
    private final eh _context;
    private final InputStream _in;
    private final byte[] _inputBuffer;
    private int _inputPtr;
    private int _inputEnd;
    private final boolean _bufferRecyclable;
    private boolean _bigEndian = true;
    private int _bytesPerChar;

    public gd(eh eh2, InputStream inputStream) {
        this._context = eh2;
        this._in = inputStream;
        this._inputBuffer = eh2.allocReadIOBuffer();
        gd gd2 = this;
        gd2._inputPtr = 0;
        gd2._inputEnd = 0;
        this._bufferRecyclable = true;
    }

    public gd(eh eh2, byte[] byArray, int n2, int n3) {
        this._context = eh2;
        this._in = null;
        this._inputBuffer = byArray;
        this._inputPtr = n2;
        this._inputEnd = n2 + n3;
        this._bufferRecyclable = false;
    }

    public final bw detectEncoding() throws IOException {
        bw bw2;
        int n2;
        boolean bl2 = false;
        if (this.ensureLoaded(4)) {
            n2 = this._inputBuffer[this._inputPtr] << 24 | (this._inputBuffer[this._inputPtr + 1] & 0xFF) << 16 | (this._inputBuffer[this._inputPtr + 2] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 3] & 0xFF;
            if (this.handleBOM(n2)) {
                bl2 = true;
            } else if (this.checkUTF32(n2)) {
                bl2 = true;
            } else if (this.checkUTF16(n2 >>> 16)) {
                bl2 = true;
            }
        } else if (this.ensureLoaded(2) && this.checkUTF16(n2 = (this._inputBuffer[this._inputPtr] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 1] & 0xFF)) {
            bl2 = true;
        }
        if (!bl2) {
            bw2 = bw.UTF8;
        } else {
            switch (this._bytesPerChar) {
                case 1: {
                    bw2 = bw.UTF8;
                    break;
                }
                case 2: {
                    bw2 = this._bigEndian ? bw.UTF16_BE : bw.UTF16_LE;
                    break;
                }
                case 4: {
                    bw2 = this._bigEndian ? bw.UTF32_BE : bw.UTF32_LE;
                    break;
                }
                default: {
                    return (bw)((Object)iu.throwInternalReturnAny());
                }
            }
        }
        this._context.setEncoding(bw2);
        return bw2;
    }

    public static int skipUTF8BOM(DataInput dataInput) throws IOException {
        int n2 = dataInput.readUnsignedByte();
        if (n2 != 239) {
            return n2;
        }
        n2 = dataInput.readUnsignedByte();
        if (n2 != 187) {
            throw new IOException("Unexpected byte 0x" + Integer.toHexString(n2) + " following 0xEF; should get 0xBB as part of UTF-8 BOM");
        }
        n2 = dataInput.readUnsignedByte();
        if (n2 != 191) {
            throw new IOException("Unexpected byte 0x" + Integer.toHexString(n2) + " following 0xEF 0xBB; should get 0xBF as part of UTF-8 BOM");
        }
        return dataInput.readUnsignedByte();
    }

    public final Reader constructReader() throws IOException {
        bw bw2 = this._context.getEncoding();
        switch (bw2.bits()) {
            case 8: 
            case 16: {
                InputStream inputStream = this._in;
                if (inputStream == null) {
                    int n2 = this._inputEnd - this._inputPtr;
                    if (n2 <= 8192) {
                        return new StringReader(new String(this._inputBuffer, this._inputPtr, n2, bw2.getJavaName()));
                    }
                    inputStream = new ByteArrayInputStream(this._inputBuffer, this._inputPtr, this._inputEnd);
                } else if (this._inputPtr < this._inputEnd) {
                    inputStream = new el(this._context, inputStream, this._inputBuffer, this._inputPtr, this._inputEnd);
                }
                return new InputStreamReader(inputStream, bw2.getJavaName());
            }
            case 32: {
                return new er(this._context, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._context.getEncoding().isBigEndian());
            }
        }
        return (Reader)iu.throwInternalReturnAny();
    }

    public final cg constructParser(int n2, cs cs2, gv gv2, gx gx2, int n3) throws IOException {
        int n4 = this._inputPtr;
        bw bw2 = by.CHARSET_DETECTION.enabledIn(n3) ? this.detectEncoding() : bw.UTF8;
        int n5 = this._inputPtr - n4;
        if (bw2 == bw.UTF8 && by.CANONICALIZE_FIELD_NAMES.enabledIn(n3)) {
            gv gv3 = gv2.makeChild(n3);
            return new gp(this._context, n2, this._in, cs2, gv3, this._inputBuffer, this._inputPtr, this._inputEnd, n5, this._bufferRecyclable);
        }
        return new gm(this._context, n2, this.constructReader(), cs2, gx2.makeChild());
    }

    public static ea hasJSONFormat(dy dy2) throws IOException {
        int n2;
        if (!dy2.hasMoreBytes()) {
            return ea.INCONCLUSIVE;
        }
        byte by2 = dy2.nextByte();
        if (by2 == -17) {
            if (!dy2.hasMoreBytes()) {
                return ea.INCONCLUSIVE;
            }
            if (dy2.nextByte() != -69) {
                return ea.NO_MATCH;
            }
            if (!dy2.hasMoreBytes()) {
                return ea.INCONCLUSIVE;
            }
            if (dy2.nextByte() != -65) {
                return ea.NO_MATCH;
            }
            if (!dy2.hasMoreBytes()) {
                return ea.INCONCLUSIVE;
            }
            by2 = dy2.nextByte();
        }
        if ((n2 = gd.skipSpace(dy2, by2)) < 0) {
            return ea.INCONCLUSIVE;
        }
        if (n2 == 123) {
            n2 = gd.skipSpace(dy2);
            if (n2 < 0) {
                return ea.INCONCLUSIVE;
            }
            if (n2 == 34 || n2 == 125) {
                return ea.SOLID_MATCH;
            }
            return ea.NO_MATCH;
        }
        if (n2 == 91) {
            n2 = gd.skipSpace(dy2);
            if (n2 < 0) {
                return ea.INCONCLUSIVE;
            }
            if (n2 == 93 || n2 == 91) {
                return ea.SOLID_MATCH;
            }
            return ea.SOLID_MATCH;
        }
        ea ea2 = ea.WEAK_MATCH;
        if (n2 == 34) {
            return ea2;
        }
        if (n2 <= 57 && n2 >= 48) {
            return ea2;
        }
        if (n2 == 45) {
            n2 = gd.skipSpace(dy2);
            if (n2 < 0) {
                return ea.INCONCLUSIVE;
            }
            if (n2 <= 57 && n2 >= 48) {
                return ea2;
            }
            return ea.NO_MATCH;
        }
        if (n2 == 110) {
            return gd.tryMatch(dy2, "ull", ea2);
        }
        if (n2 == 116) {
            return gd.tryMatch(dy2, "rue", ea2);
        }
        if (n2 == 102) {
            return gd.tryMatch(dy2, "alse", ea2);
        }
        return ea.NO_MATCH;
    }

    private static ea tryMatch(dy dy2, String string, ea ea2) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!dy2.hasMoreBytes()) {
                return ea.INCONCLUSIVE;
            }
            if (dy2.nextByte() == string.charAt(i2)) continue;
            return ea.NO_MATCH;
        }
        return ea2;
    }

    private static int skipSpace(dy dy2) throws IOException {
        if (!dy2.hasMoreBytes()) {
            return -1;
        }
        dy dy3 = dy2;
        return gd.skipSpace(dy3, dy3.nextByte());
    }

    private static int skipSpace(dy dy2, byte by2) throws IOException {
        int n2;
        while ((n2 = by2 & 0xFF) == 32 || n2 == 13 || n2 == 10 || n2 == 9) {
            if (!dy2.hasMoreBytes()) {
                return -1;
            }
            by2 = dy2.nextByte();
        }
        return n2;
    }

    private boolean handleBOM(int n2) throws IOException {
        switch (n2) {
            case 65279: {
                this._bigEndian = true;
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                return true;
            }
            case -131072: {
                this._inputPtr += 4;
                this._bytesPerChar = 4;
                this._bigEndian = false;
                return true;
            }
            case 65534: {
                this.reportWeirdUCS4("2143");
                break;
            }
            case -16842752: {
                this.reportWeirdUCS4("3412");
            }
        }
        int n3 = n2 >>> 16;
        if (n3 == 65279) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = true;
            return true;
        }
        if (n3 == 65534) {
            this._inputPtr += 2;
            this._bytesPerChar = 2;
            this._bigEndian = false;
            return true;
        }
        if (n2 >>> 8 == 0xEFBBBF) {
            this._inputPtr += 3;
            this._bytesPerChar = 1;
            this._bigEndian = true;
            return true;
        }
        return false;
    }

    private boolean checkUTF32(int n2) throws IOException {
        if (n2 >> 8 == 0) {
            this._bigEndian = true;
        } else if ((n2 & 0xFFFFFF) == 0) {
            this._bigEndian = false;
        } else if ((n2 & 0xFF00FFFF) == 0) {
            this.reportWeirdUCS4("3412");
        } else if ((n2 & 0xFFFF00FF) == 0) {
            this.reportWeirdUCS4("2143");
        } else {
            return false;
        }
        this._bytesPerChar = 4;
        return true;
    }

    private boolean checkUTF16(int n2) {
        if ((n2 & 0xFF00) == 0) {
            this._bigEndian = true;
        } else if ((n2 & 0xFF) == 0) {
            this._bigEndian = false;
        } else {
            return false;
        }
        this._bytesPerChar = 2;
        return true;
    }

    private void reportWeirdUCS4(String string) throws IOException {
        throw new CharConversionException("Unsupported UCS-4 endianness (" + string + ") detected");
    }

    protected final boolean ensureLoaded(int n2) throws IOException {
        int n3;
        for (int i2 = this._inputEnd - this._inputPtr; i2 < n2; i2 += n3) {
            n3 = this._in == null ? -1 : this._in.read(this._inputBuffer, this._inputEnd, this._inputBuffer.length - this._inputEnd);
            if (n3 <= 0) {
                return false;
            }
            this._inputEnd += n3;
        }
        return true;
    }
}

