/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.sdk.lib;

import java.math.BigInteger;
import us.hebi.sdk.lib.fb;
import us.hebi.sdk.lib.ff;
import us.hebi.sdk.lib.fg;

class fe {
    public static final double COS_0_25 = Math.cos(0.7853981633974483);
    public static final double SIN_0_25 = Math.sin(0.7853981633974483);
    private static final int FFT_THRESHOLD = 33220;
    private static final int MAX_MAG_LENGTH = 0x4000000;
    private static final int ROOTS3_CACHE_SIZE = 20;
    private static final int ROOTS_CACHE2_SIZE = 20;
    private static final int TOOM_COOK_THRESHOLD = 1920;
    private static volatile ff[] ROOTS2_CACHE = new ff[20];
    private static volatile ff[] ROOTS3_CACHE = new ff[20];

    fe() {
    }

    static int bitsPerFftPoint(int n2) {
        if (n2 <= 9728) {
            return 19;
        }
        if (n2 <= 18432) {
            return 18;
        }
        if (n2 <= 69632) {
            return 17;
        }
        if (n2 <= 262144) {
            return 16;
        }
        if (n2 <= 983040) {
            return 15;
        }
        if (n2 <= 0x380000) {
            return 14;
        }
        if (n2 <= 0xD00000) {
            return 13;
        }
        if (n2 <= 0x1800000) {
            return 12;
        }
        if (n2 <= 0x5800000) {
            return 11;
        }
        if (n2 <= 0x14000000) {
            return 10;
        }
        if (n2 <= 0x48000000) {
            return 9;
        }
        return 8;
    }

    private static ff calculateRootsOfUnity(int n2) {
        if (n2 == 1) {
            ff ff2 = new ff(1);
            ff2.real(0, 1.0);
            ff2.imag(0, 0.0);
            return ff2;
        }
        ff ff3 = new ff(n2);
        ff3.set(0, 1.0, 0.0);
        double d2 = COS_0_25;
        double d3 = SIN_0_25;
        ff3.set(n2 / 2, d2, d3);
        double d4 = 1.5707963267948966 / (double)n2;
        for (int i2 = 1; i2 < n2 / 2; ++i2) {
            double d5 = d4 * (double)i2;
            d2 = Math.cos(d5);
            d3 = Math.sin(d5);
            ff3.set(i2, d2, d3);
            ff3.set(n2 - i2, d3, d2);
        }
        return ff3;
    }

    private static void fft(ff ff2, ff[] ffArray) {
        int n2;
        int n3 = ff.access$000(ff2);
        int n4 = 31 - Integer.numberOfLeadingZeros(n3);
        fg fg2 = new fg();
        fg fg3 = new fg();
        fg fg4 = new fg();
        fg fg5 = new fg();
        fg fg6 = new fg();
        fg fg7 = new fg();
        for (n2 = n4; n2 >= 2; n2 -= 2) {
            ff ff3 = ffArray[n2 - 2];
            int n5 = 1 << n2;
            for (int i2 = 0; i2 < n3; i2 += n5) {
                for (int i3 = 0; i3 < n5 / 4; ++i3) {
                    fg6.set(ff3, i3);
                    fg6.squareInto(fg7);
                    int n6 = i2 + i3;
                    int n7 = i2 + i3 + n5 / 4;
                    int n8 = i2 + i3 + n5 / 2;
                    int n9 = i2 + i3 + n5 * 3 / 4;
                    ff2.addInto(n6, ff2, n7, fg2);
                    fg2.add(ff2, n8);
                    fg2.add(ff2, n9);
                    ff2.subtractTimesIInto(n6, ff2, n7, fg3);
                    fg3.subtract(ff2, n8);
                    fg3.addTimesI(ff2, n9);
                    fg3.multiplyConjugate(fg6);
                    ff2.subtractInto(n6, ff2, n7, fg4);
                    fg4.add(ff2, n8);
                    fg4.subtract(ff2, n9);
                    fg4.multiplyConjugate(fg7);
                    ff2.addTimesIInto(n6, ff2, n7, fg5);
                    fg5.subtract(ff2, n8);
                    fg5.subtractTimesI(ff2, n9);
                    fg5.multiply(fg6);
                    fg2.copyInto(ff2, n6);
                    fg3.copyInto(ff2, n7);
                    fg4.copyInto(ff2, n8);
                    fg5.copyInto(ff2, n9);
                }
            }
        }
        if (n2 > 0) {
            for (int i4 = 0; i4 < n3; i4 += 2) {
                ff2.copyInto(i4, fg2);
                ff2.copyInto(i4 + 1, fg3);
                ff2.add(i4, fg3);
                fg2.subtractInto(fg3, ff2, i4 + 1);
            }
        }
    }

    private static void fft3(ff ff2, ff ff3, ff ff4, int n2, double d2) {
        double d3 = (double)n2 * -0.5 * Math.sqrt(3.0);
        for (int i2 = 0; i2 < ff.access$000(ff2); ++i2) {
            double d4 = ff2.real(i2) + ff3.real(i2) + ff4.real(i2);
            double d5 = ff2.imag(i2) + ff3.imag(i2) + ff4.imag(i2);
            double d6 = d3 * (ff4.imag(i2) - ff3.imag(i2));
            double d7 = d3 * (ff3.real(i2) - ff4.real(i2));
            double d8 = 0.5 * (ff3.real(i2) + ff4.real(i2));
            double d9 = 0.5 * (ff3.imag(i2) + ff4.imag(i2));
            double d10 = ff2.real(i2) - d8 + d6;
            double d11 = ff2.imag(i2) + d7 - d9;
            double d12 = ff2.real(i2) - d8 - d6;
            double d13 = ff2.imag(i2) - d7 - d9;
            ff2.real(i2, d4 * d2);
            ff2.imag(i2, d5 * d2);
            ff3.real(i2, d10 * d2);
            ff3.imag(i2, d11 * d2);
            ff4.real(i2, d12 * d2);
            ff4.imag(i2, d13 * d2);
        }
    }

    private static void fftMixedRadix(ff ff2, ff[] ffArray, ff ff3) {
        int n2;
        int n3 = ff.access$000(ff2) / 3;
        ff ff4 = new ff(ff2, 0, n3);
        int n4 = n3;
        ff ff5 = new ff(ff2, n4, n4 << 1);
        ff ff6 = new ff(ff2, n3 << 1, ff.access$000(ff2));
        fe.fft3(ff4, ff5, ff6, 1, 1.0);
        fg fg2 = new fg();
        for (n2 = 0; n2 < ff.access$000(ff2) / 4; ++n2) {
            fg2.set(ff3, n2);
            ff5.multiplyConjugate(n2, fg2);
            ff6.multiplyConjugate(n2, fg2);
            ff6.multiplyConjugate(n2, fg2);
        }
        for (n2 = ff.access$000(ff2) / 4; n2 < n3; ++n2) {
            fg2.set(ff3, n2 - ff.access$000(ff2) / 4);
            ff5.multiplyConjugateTimesI(n2, fg2);
            ff6.multiplyConjugateTimesI(n2, fg2);
            ff6.multiplyConjugateTimesI(n2, fg2);
        }
        fe.fft(ff4, ffArray);
        fe.fft(ff5, ffArray);
        fe.fft(ff6, ffArray);
    }

    static BigInteger fromFftVector(ff ff2, int n2, int n3) {
        assert (n3 <= 25) : n3 + " does not fit into an int with slack";
        int n4 = (int)Math.min((long)ff.access$000(ff2), 0x80000000L / (long)n3 + 1L);
        int n5 = (int)(8L * ((long)n4 * (long)n3 + 31L) / 32L);
        byte[] byArray = new byte[n5];
        int n6 = (1 << n3) - 1;
        int n7 = 32 - n3;
        long l2 = 0L;
        int n8 = (n5 << 3) - n3;
        int n9 = 0;
        int n10 = Math.min(Math.max(0, n8 >> 3), n5 - 4);
        for (int i2 = 0; i2 <= 1; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                long l3 = Math.round(ff2.part(i3, i2)) + l2;
                l2 = l3 >> n3;
                int n11 = Math.min(Math.max(0, n8 >> 3), n5 - 4);
                n9 >>>= n10 - n11 << 3;
                int n12 = n7 - n8 + (n11 << 3);
                n9 = (int)((long)n9 | (l3 & (long)n6) << n12);
                fb.writeIntBE(byArray, n11, n9);
                n10 = n11;
                n8 -= n3;
            }
        }
        return new BigInteger(n2, byArray);
    }

    private static ff[] getRootsOfUnity2(int n2) {
        ff[] ffArray = new ff[n2 + 1];
        for (int i2 = n2; i2 >= 0; i2 -= 2) {
            if (i2 < 20) {
                if (ROOTS2_CACHE[i2] == null) {
                    fe.ROOTS2_CACHE[i2] = fe.calculateRootsOfUnity(1 << i2);
                }
                ffArray[i2] = ROOTS2_CACHE[i2];
                continue;
            }
            ffArray[i2] = fe.calculateRootsOfUnity(1 << i2);
        }
        return ffArray;
    }

    private static ff getRootsOfUnity3(int n2) {
        if (n2 < 20) {
            if (ROOTS3_CACHE[n2] == null) {
                fe.ROOTS3_CACHE[n2] = fe.calculateRootsOfUnity(3 << n2);
            }
            return ROOTS3_CACHE[n2];
        }
        return fe.calculateRootsOfUnity(3 << n2);
    }

    private static void ifft(ff ff2, ff[] ffArray) {
        int n2 = ff.access$000(ff2);
        int n3 = 31 - Integer.numberOfLeadingZeros(n2);
        fg fg2 = new fg();
        fg fg3 = new fg();
        fg fg4 = new fg();
        fg fg5 = new fg();
        fg fg6 = new fg();
        fg fg7 = new fg();
        fg fg8 = new fg();
        fg fg9 = new fg();
        int n4 = 1;
        if (n3 % 2 != 0) {
            for (int i2 = 0; i2 < n2; i2 += 2) {
                ff2.copyInto(i2 + 1, fg4);
                ff2.copyInto(i2, fg2);
                ff2.add(i2, fg4);
                fg2.subtractInto(fg4, ff2, i2 + 1);
            }
            ++n4;
        }
        fg fg10 = new fg();
        fg fg11 = new fg();
        while (n4 <= n3) {
            ff ff3 = ffArray[n4 - 1];
            int n5 = 1 << n4 + 1;
            for (int i3 = 0; i3 < n2; i3 += n5) {
                for (int i4 = 0; i4 < n5 / 4; ++i4) {
                    fg10.set(ff3, i4);
                    fg10.squareInto(fg11);
                    int n6 = i3 + i4;
                    int n7 = i3 + i4 + n5 / 4;
                    int n8 = i3 + i4 + n5 / 2;
                    int n9 = i3 + i4 + n5 * 3 / 4;
                    ff2.copyInto(n6, fg2);
                    ff2.multiplyInto(n7, fg10, fg3);
                    ff2.multiplyInto(n8, fg11, fg4);
                    ff2.multiplyConjugateInto(n9, fg10, fg5);
                    fg2.addInto(fg3, fg6);
                    fg6.add(fg4);
                    fg6.add(fg5);
                    fg2.addTimesIInto(fg3, fg7);
                    fg7.subtract(fg4);
                    fg7.subtractTimesI(fg5);
                    fg2.subtractInto(fg3, fg8);
                    fg8.add(fg4);
                    fg8.subtract(fg5);
                    fg2.subtractTimesIInto(fg3, fg9);
                    fg9.subtract(fg4);
                    fg9.addTimesI(fg5);
                    fg6.copyInto(ff2, n6);
                    fg7.copyInto(ff2, n7);
                    fg8.copyInto(ff2, n8);
                    fg9.copyInto(ff2, n9);
                }
            }
            n4 += 2;
        }
        for (int i5 = 0; i5 < n2; ++i5) {
            ff2.timesTwoToThe(i5, -n3);
        }
    }

    private static void ifftMixedRadix(ff ff2, ff[] ffArray, ff ff3) {
        int n2;
        int n3 = ff.access$000(ff2) / 3;
        ff ff4 = new ff(ff2, 0, n3);
        int n4 = n3;
        ff ff5 = new ff(ff2, n4, n4 << 1);
        ff ff6 = new ff(ff2, n3 << 1, ff.access$000(ff2));
        fe.ifft(ff4, ffArray);
        fe.ifft(ff5, ffArray);
        fe.ifft(ff6, ffArray);
        fg fg2 = new fg();
        for (n2 = 0; n2 < ff.access$000(ff2) / 4; ++n2) {
            fg2.set(ff3, n2);
            ff5.multiply(n2, fg2);
            ff6.multiply(n2, fg2);
            ff6.multiply(n2, fg2);
        }
        for (n2 = ff.access$000(ff2) / 4; n2 < n3; ++n2) {
            fg2.set(ff3, n2 - ff.access$000(ff2) / 4);
            ff5.multiplyByIAnd(n2, fg2);
            ff6.multiplyByIAnd(n2, fg2);
            ff6.multiplyByIAnd(n2, fg2);
        }
        fe.fft3(ff4, ff5, ff6, -1, 0.3333333333333333);
    }

    static BigInteger multiply(BigInteger bigInteger, BigInteger bigInteger2) {
        int n2;
        assert (bigInteger != null) : "a==null";
        assert (bigInteger2 != null) : "b==null";
        if (bigInteger2.signum() == 0 || bigInteger.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (bigInteger2 == bigInteger) {
            return fe.square(bigInteger2);
        }
        int n3 = bigInteger.bitLength();
        if ((long)n3 + (long)(n2 = bigInteger2.bitLength()) > 0x80000000L) {
            throw new ArithmeticException("BigInteger would overflow supported range");
        }
        if (n3 > 1920 && n2 > 1920 && (n3 > 33220 || n2 > 33220)) {
            return fe.multiplyFft(bigInteger, bigInteger2);
        }
        return bigInteger.multiply(bigInteger2);
    }

    static BigInteger multiplyFft(BigInteger bigInteger, BigInteger bigInteger2) {
        int n2;
        int n3;
        int n4;
        int n5;
        byte[] byArray;
        int n6 = bigInteger.signum() * bigInteger2.signum();
        byte[] byArray2 = (bigInteger.signum() < 0 ? bigInteger.negate() : bigInteger).toByteArray();
        int n7 = Math.max(byArray2.length, (byArray = (bigInteger2.signum() < 0 ? bigInteger2.negate() : bigInteger2).toByteArray()).length) << 3;
        int n8 = (n7 + (n5 = fe.bitsPerFftPoint(n7)) - 1) / n5 + 1;
        if (n8 < (n4 = (n3 = 1 << (n2 = 32 - Integer.numberOfLeadingZeros(n8 - 1))) * 3 / 4) && n2 > 3) {
            ff[] ffArray = fe.getRootsOfUnity2(n2 - 2);
            ff ff2 = fe.getRootsOfUnity3(n2 - 2);
            ff ff3 = fe.getRootsOfUnity3(n2 - 4);
            ff ff4 = fe.toFftVector(byArray2, n4, n5);
            ff4.applyWeights(ff2);
            fe.fftMixedRadix(ff4, ffArray, ff3);
            ff ff5 = fe.toFftVector(byArray, n4, n5);
            ff5.applyWeights(ff2);
            fe.fftMixedRadix(ff5, ffArray, ff3);
            ff4.multiplyPointwise(ff5);
            fe.ifftMixedRadix(ff4, ffArray, ff3);
            ff4.applyInverseWeights(ff2);
            return fe.fromFftVector(ff4, n6, n5);
        }
        ff[] ffArray = fe.getRootsOfUnity2(n2);
        ff ff6 = fe.toFftVector(byArray2, n3, n5);
        ff6.applyWeights(ffArray[n2]);
        fe.fft(ff6, ffArray);
        ff ff7 = fe.toFftVector(byArray, n3, n5);
        ff7.applyWeights(ffArray[n2]);
        fe.fft(ff7, ffArray);
        ff6.multiplyPointwise(ff7);
        fe.ifft(ff6, ffArray);
        ff6.applyInverseWeights(ffArray[n2]);
        return fe.fromFftVector(ff6, n6, n5);
    }

    static BigInteger square(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (bigInteger.bitLength() < 33220) {
            BigInteger bigInteger2 = bigInteger;
            return bigInteger2.multiply(bigInteger2);
        }
        return fe.squareFft(bigInteger);
    }

    static BigInteger squareFft(BigInteger bigInteger) {
        int n2;
        int n3;
        int n4;
        int n5;
        byte[] byArray = bigInteger.toByteArray();
        int n6 = byArray.length << 3;
        int n7 = (n6 + (n5 = fe.bitsPerFftPoint(n6)) - 1) / n5 + 1;
        if (n7 < (n4 = (n3 = 1 << (n2 = 32 - Integer.numberOfLeadingZeros(n7 - 1))) * 3 / 4)) {
            n7 = n4;
            ff ff2 = fe.toFftVector(byArray, n7, n5);
            ff[] ffArray = fe.getRootsOfUnity2(n2 - 2);
            ff ff3 = fe.getRootsOfUnity3(n2 - 2);
            ff ff4 = fe.getRootsOfUnity3(n2 - 4);
            ff2.applyWeights(ff3);
            fe.fftMixedRadix(ff2, ffArray, ff4);
            ff2.squarePointwise();
            fe.ifftMixedRadix(ff2, ffArray, ff4);
            ff2.applyInverseWeights(ff3);
            return fe.fromFftVector(ff2, 1, n5);
        }
        n7 = n3;
        ff ff5 = fe.toFftVector(byArray, n7, n5);
        ff[] ffArray = fe.getRootsOfUnity2(n2);
        ff5.applyWeights(ffArray[n2]);
        fe.fft(ff5, ffArray);
        ff5.squarePointwise();
        fe.ifft(ff5, ffArray);
        ff5.applyInverseWeights(ffArray[n2]);
        return fe.fromFftVector(ff5, 1, n5);
    }

    static ff toFftVector(byte[] byArray, int n2, int n3) {
        assert (n3 <= 25) : n3 + " does not fit into an int with slack";
        ff ff2 = new ff(n2);
        if (byArray.length < 4) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 0, byArray2, 4 - byArray.length, byArray.length);
            byArray = byArray2;
        }
        int n4 = 1 << n3;
        int n5 = n4 / 2;
        int n6 = n4 - 1;
        int n7 = 32 - n3;
        int n8 = byArray.length << 3;
        int n9 = 0;
        int n10 = 0;
        for (int i2 = n8 - n3; i2 > -n3; i2 -= n3) {
            int n11 = Math.min(Math.max(0, i2 >> 3), byArray.length - 4);
            int n12 = n7 - i2 + (n11 << 3);
            int n13 = (fb.readIntBE(byArray, n11) >>> n12 & n6) + n9;
            n9 = n5 - n13 >>> 31;
            ff2.real(n10, n13 -= n4 & -n9);
            ++n10;
        }
        if (n9 > 0) {
            ff2.real(n10, n9);
        }
        return ff2;
    }
}

