/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.sdk.lib;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import us.hebi.sdk.lib.bo;
import us.hebi.sdk.lib.ce;
import us.hebi.sdk.lib.cf;
import us.hebi.sdk.lib.cg;
import us.hebi.sdk.lib.ch;
import us.hebi.sdk.lib.ci;
import us.hebi.sdk.lib.co;
import us.hebi.sdk.lib.cq;
import us.hebi.sdk.lib.cv;
import us.hebi.sdk.lib.cw;
import us.hebi.sdk.lib.cy;
import us.hebi.sdk.lib.dg;
import us.hebi.sdk.lib.dn;
import us.hebi.sdk.lib.dp;
import us.hebi.sdk.lib.ef;
import us.hebi.sdk.lib.eh;
import us.hebi.sdk.lib.em;
import us.hebi.sdk.lib.ge;
import us.hebi.sdk.lib.gh;
import us.hebi.sdk.lib.gl;
import us.hebi.sdk.lib.hh;
import us.hebi.sdk.lib.hq;
import us.hebi.sdk.lib.ir;

public abstract class dm
extends dn {
    protected static final hq<cv> JSON_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES;
    protected final eh _ioContext;
    protected final cw _streamReadConstraints;
    protected boolean _closed;
    protected int _inputPtr;
    protected int _inputEnd;
    protected long _currInputProcessed;
    protected int _currInputRow = 1;
    protected int _currInputRowStart;
    protected long _tokenInputTotal;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol;
    protected gh _parsingContext;
    protected cq _nextToken;
    protected final ir _textBuffer;
    protected char[] _nameCopyBuffer;
    protected boolean _nameCopied;
    protected hh _byteArrayBuilder;
    protected byte[] _binaryValue;
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected float _numberFloat;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    protected String _numberString;
    protected boolean _numberIsNaN;
    protected boolean _numberNegative;
    protected int _intLength;
    protected int _fractLength;
    protected int _expLength;

    protected dm(eh eh2, int n2) {
        super(n2);
        this._ioContext = eh2;
        cw cw2 = eh2.streamReadConstraints();
        this._streamReadConstraints = cw2 == null ? cw.defaults() : cw2;
        this._textBuffer = eh2.constructReadConstrainedTextBuffer();
        ge ge2 = ch.STRICT_DUPLICATE_DETECTION.enabledIn(n2) ? ge.rootDetector(this) : null;
        this._parsingContext = gh.createRootContext(ge2);
    }

    @Override
    public dg version() {
        return gl.VERSION;
    }

    @Override
    public Object currentValue() {
        return this._parsingContext.getCurrentValue();
    }

    @Override
    public void assignCurrentValue(Object object) {
        this._parsingContext.setCurrentValue(object);
    }

    @Override
    public cg enable(ch ch2) {
        this._features |= ch2.getMask();
        if (ch2 == ch.STRICT_DUPLICATE_DETECTION && this._parsingContext.getDupDetector() == null) {
            this._parsingContext = this._parsingContext.withDupDetector(ge.rootDetector(this));
        }
        return this;
    }

    @Override
    public cg disable(ch ch2) {
        this._features &= ~ch2.getMask();
        if (ch2 == ch.STRICT_DUPLICATE_DETECTION) {
            this._parsingContext = this._parsingContext.withDupDetector(null);
        }
        return this;
    }

    @Override
    @Deprecated
    public cg setFeatureMask(int n2) {
        int n3 = this._features ^ n2;
        if (n3 != 0) {
            this._features = n2;
            this._checkStdFeatureChanges(n2, n3);
        }
        return this;
    }

    @Override
    public cg overrideStdFeatures(int n2, int n3) {
        int n4 = this._features;
        int n5 = n4 & ~n3 | n2 & n3;
        int n6 = n4 ^ n5;
        if (n6 != 0) {
            this._features = n5;
            this._checkStdFeatureChanges(n5, n6);
        }
        return this;
    }

    protected void _checkStdFeatureChanges(int n2, int n3) {
        int n4 = ch.STRICT_DUPLICATE_DETECTION.getMask();
        if ((n3 & n4) != 0 && (n2 & n4) != 0) {
            if (this._parsingContext.getDupDetector() == null) {
                this._parsingContext = this._parsingContext.withDupDetector(ge.rootDetector(this));
                return;
            }
            this._parsingContext = this._parsingContext.withDupDetector(null);
        }
    }

    @Override
    @Deprecated
    public String getCurrentName() throws IOException {
        gh gh2;
        if ((this._currToken == cq.START_OBJECT || this._currToken == cq.START_ARRAY) && (gh2 = this._parsingContext.getParent()) != null) {
            return gh2.getCurrentName();
        }
        return this._parsingContext.getCurrentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        gh gh2 = this._parsingContext;
        if (this._currToken == cq.START_OBJECT || this._currToken == cq.START_ARRAY) {
            gh2 = gh2.getParent();
        }
        try {
            gh2.setCurrentName(string);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._inputPtr = Math.max(this._inputPtr, this._inputEnd);
            this._closed = true;
            try {
                this._closeInput();
                return;
            }
            finally {
                this._releaseBuffers();
                this._ioContext.close();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public gh getParsingContext() {
        return this._parsingContext;
    }

    @Override
    @Deprecated
    public ce getTokenLocation() {
        return new ce(this._contentReference(), -1L, this.getTokenCharacterOffset(), this.getTokenLineNr(), this.getTokenColumnNr());
    }

    @Override
    @Deprecated
    public ce getCurrentLocation() {
        int n2 = this._inputPtr - this._currInputRowStart + 1;
        return new ce(this._contentReference(), -1L, this._currInputProcessed + (long)this._inputPtr, this._currInputRow, n2);
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == cq.VALUE_STRING) {
            return true;
        }
        if (this._currToken == cq.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    @Override
    public byte[] getBinaryValue(bo bo2) throws IOException {
        if (this._binaryValue == null) {
            if (this._currToken != cq.VALUE_STRING) {
                this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING, can not access as binary");
            }
            hh hh2 = this._getByteArrayBuilder();
            dm dm2 = this;
            dm2._decodeBase64(dm2.getText(), hh2, bo2);
            this._binaryValue = hh2.toByteArray();
        }
        return this._binaryValue;
    }

    public long getTokenCharacterOffset() {
        return this._tokenInputTotal;
    }

    public int getTokenLineNr() {
        return this._tokenInputRow;
    }

    public int getTokenColumnNr() {
        int n2 = this._tokenInputCol;
        if (n2 < 0) {
            return n2;
        }
        return n2 + 1;
    }

    protected abstract void _closeInput() throws IOException;

    protected void _releaseBuffers() throws IOException {
        this._textBuffer.releaseBuffers();
        char[] cArray = this._nameCopyBuffer;
        if (this._nameCopyBuffer != null) {
            this._nameCopyBuffer = null;
            this._ioContext.releaseNameCopyBuffer(cArray);
        }
    }

    @Override
    protected void _handleEOF() throws cf {
        if (!this._parsingContext.inRoot()) {
            String string = this._parsingContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", string, this._parsingContext.startLocation(this._contentReference())), null);
        }
    }

    protected final int _eofAsNextChar() throws cf {
        this._handleEOF();
        return -1;
    }

    public hh _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new hh();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected final cq reset(boolean bl2, int n2, int n3, int n4) throws IOException {
        if (n3 <= 0 && n4 <= 0) {
            return this.resetInt(bl2, n2);
        }
        return this.resetFloat(bl2, n2, n3, n4);
    }

    protected final cq resetInt(boolean bl2, int n2) throws IOException {
        this._streamReadConstraints.validateIntegerLength(n2);
        this._numberNegative = bl2;
        this._numberIsNaN = false;
        this._intLength = n2;
        this._fractLength = 0;
        this._expLength = 0;
        this._numTypesValid = 0;
        return cq.VALUE_NUMBER_INT;
    }

    protected final cq resetFloat(boolean bl2, int n2, int n3, int n4) throws IOException {
        this._streamReadConstraints.validateFPLength(n2 + n3 + n4);
        this._numberNegative = bl2;
        this._numberIsNaN = false;
        this._intLength = n2;
        this._fractLength = n3;
        this._expLength = n4;
        this._numTypesValid = 0;
        return cq.VALUE_NUMBER_FLOAT;
    }

    protected final cq resetAsNaN(String string, double d2) throws IOException {
        this._textBuffer.resetWithString(string);
        this._numberDouble = d2;
        this._numTypesValid = 8;
        this._numberIsNaN = true;
        return cq.VALUE_NUMBER_FLOAT;
    }

    @Override
    public boolean isNaN() throws IOException {
        return this._currToken == cq.VALUE_NUMBER_FLOAT && this._numberIsNaN;
    }

    @Override
    public Number getNumberValue() throws IOException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == cq.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._getBigInteger();
            }
            this._throwInternal();
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._getBigDecimal();
        }
        if ((this._numTypesValid & 0x20) != 0) {
            return Float.valueOf(this._getNumberFloat());
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._getNumberDouble();
    }

    @Override
    public Number getNumberValueExact() throws IOException {
        if (this._currToken == cq.VALUE_NUMBER_INT) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(0);
            }
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._getBigInteger();
            }
            this._throwInternal();
        }
        if (this._numTypesValid == 0) {
            this._parseNumericValue(16);
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._getBigDecimal();
        }
        if ((this._numTypesValid & 0x20) != 0) {
            return Float.valueOf(this._getNumberFloat());
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._getNumberDouble();
    }

    @Override
    public Object getNumberValueDeferred() throws IOException {
        if (this._currToken == cq.VALUE_NUMBER_INT) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(0);
            }
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                if (this._numberBigInt != null) {
                    return this._numberBigInt;
                }
                if (this._numberString != null) {
                    return this._numberString;
                }
                return this._getBigInteger();
            }
            this._throwInternal();
        }
        if (this._currToken == cq.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 0x10) != 0) {
                return this._getBigDecimal();
            }
            if ((this._numTypesValid & 8) != 0) {
                return this._getNumberDouble();
            }
            if ((this._numTypesValid & 0x20) != 0) {
                return Float.valueOf(this._getNumberFloat());
            }
            return this._textBuffer.contentsAsString();
        }
        return this.getNumberValue();
    }

    @Override
    public ci getNumberType() throws IOException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == cq.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return ci.INT;
            }
            if ((this._numTypesValid & 2) != 0) {
                return ci.LONG;
            }
            return ci.BIG_INTEGER;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return ci.BIG_DECIMAL;
        }
        if ((this._numTypesValid & 0x20) != 0) {
            return ci.FLOAT;
        }
        return ci.DOUBLE;
    }

    @Override
    public int getIntValue() throws IOException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                return this._parseIntValue();
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public long getLongValue() throws IOException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._getBigInteger();
    }

    @Override
    public float getFloatValue() throws IOException {
        if ((this._numTypesValid & 0x20) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(32);
            }
            if ((this._numTypesValid & 0x20) == 0) {
                this.convertNumberToFloat();
            }
        }
        return this._getNumberFloat();
    }

    @Override
    public double getDoubleValue() throws IOException {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._getNumberDouble();
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._getBigDecimal();
    }

    @Override
    public cw streamReadConstraints() {
        return this._streamReadConstraints;
    }

    protected void _parseNumericValue(int n2) throws IOException {
        if (this._closed) {
            this._reportError("Internal error: _parseNumericValue called when parser instance closed");
        }
        if (this._currToken == cq.VALUE_NUMBER_INT) {
            int n3 = this._intLength;
            if (n3 <= 9) {
                this._numberInt = this._textBuffer.contentsAsInt(this._numberNegative);
                this._numTypesValid = 1;
                return;
            }
            if (n3 <= 18) {
                long l2 = this._textBuffer.contentsAsLong(this._numberNegative);
                if (n3 == 10) {
                    if (this._numberNegative) {
                        if (l2 >= Integer.MIN_VALUE) {
                            this._numberInt = (int)l2;
                            this._numTypesValid = 1;
                            return;
                        }
                    } else if (l2 <= Integer.MAX_VALUE) {
                        this._numberInt = (int)l2;
                        this._numTypesValid = 1;
                        return;
                    }
                }
                this._numberLong = l2;
                this._numTypesValid = 2;
                return;
            }
            if (n3 == 19) {
                char[] cArray = this._textBuffer.getTextBuffer();
                int n4 = this._textBuffer.getTextOffset();
                if (this._numberNegative) {
                    ++n4;
                }
                if (em.inLongRange(cArray, n4, n3, this._numberNegative)) {
                    this._numberLong = em.parseLong19(cArray, n4, this._numberNegative);
                    this._numTypesValid = 2;
                    return;
                }
            }
            this._parseSlowInt(n2);
            return;
        }
        if (this._currToken == cq.VALUE_NUMBER_FLOAT) {
            this._parseSlowFloat(n2);
            return;
        }
        this._reportError("Current token (%s) not numeric, can not use numeric value accessors", (Object)this._currToken);
    }

    protected int _parseIntValue() throws IOException {
        if (this._closed) {
            this._reportError("Internal error: _parseNumericValue called when parser instance closed");
        }
        if (this._currToken == cq.VALUE_NUMBER_INT && this._intLength <= 9) {
            int n2;
            this._numberInt = n2 = this._textBuffer.contentsAsInt(this._numberNegative);
            this._numTypesValid = 1;
            return n2;
        }
        this._parseNumericValue(1);
        if ((this._numTypesValid & 1) == 0) {
            this.convertNumberToInt();
        }
        return this._numberInt;
    }

    private void _parseSlowFloat(int n2) throws IOException {
        if (n2 == 16) {
            this._numberBigDecimal = null;
            this._numberString = this._textBuffer.contentsAsString();
            this._numTypesValid = 16;
            return;
        }
        if (n2 == 32) {
            this._numberFloat = 0.0f;
            this._numberString = this._textBuffer.contentsAsString();
            this._numTypesValid = 32;
            return;
        }
        this._numberDouble = 0.0;
        this._numberString = this._textBuffer.contentsAsString();
        this._numTypesValid = 8;
    }

    private void _parseSlowInt(int n2) throws IOException {
        String string = this._textBuffer.contentsAsString();
        if (n2 == 1 || n2 == 2) {
            this._reportTooLongIntegral(n2, string);
        }
        if (n2 == 8 || n2 == 32) {
            this._numberString = string;
            this._numTypesValid = 8;
            return;
        }
        this._numberBigInt = null;
        this._numberString = string;
        this._numTypesValid = 4;
    }

    protected void _reportTooLongIntegral(int n2, String string) throws IOException {
        if (n2 == 1) {
            this.reportOverflowInt(string);
            return;
        }
        this.reportOverflowLong(string);
    }

    protected void convertNumberToInt() throws IOException {
        if ((this._numTypesValid & 2) != 0) {
            int n2 = (int)this._numberLong;
            if ((long)n2 != this._numberLong) {
                dm dm2 = this;
                dm2.reportOverflowInt(dm2.getText(), this.currentToken());
            }
            this._numberInt = n2;
        } else if ((this._numTypesValid & 4) != 0) {
            BigInteger bigInteger = this._getBigInteger();
            if (BI_MIN_INT.compareTo(bigInteger) > 0 || BI_MAX_INT.compareTo(bigInteger) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = bigInteger.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            double d2 = this._getNumberDouble();
            if (d2 < -2.147483648E9 || d2 > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)d2;
        } else if ((this._numTypesValid & 0x10) != 0) {
            BigDecimal bigDecimal = this._getBigDecimal();
            if (BD_MIN_INT.compareTo(bigDecimal) > 0 || BD_MAX_INT.compareTo(bigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = bigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void convertNumberToLong() throws IOException {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            BigInteger bigInteger = this._getBigInteger();
            if (BI_MIN_LONG.compareTo(bigInteger) > 0 || BI_MAX_LONG.compareTo(bigInteger) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = bigInteger.longValue();
        } else if ((this._numTypesValid & 8) != 0) {
            double d2 = this._getNumberDouble();
            if (d2 < -9.223372036854776E18 || d2 > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)d2;
        } else if ((this._numTypesValid & 0x10) != 0) {
            BigDecimal bigDecimal = this._getBigDecimal();
            if (BD_MIN_LONG.compareTo(bigDecimal) > 0 || BD_MAX_LONG.compareTo(bigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = bigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void convertNumberToBigInteger() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberBigInt = this._convertBigDecimalToBigInteger(this._getBigDecimal());
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = this._numberString != null ? this._convertBigDecimalToBigInteger(this._getBigDecimal()) : this._convertBigDecimalToBigInteger(BigDecimal.valueOf(this._getNumberDouble()));
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected void convertNumberToDouble() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberString != null ? this._getNumberDouble() : this._getBigDecimal().doubleValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberString != null ? this._getNumberDouble() : this._getBigInteger().doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberDouble = this._numberString != null ? this._getNumberDouble() : (double)this._getNumberFloat();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected void convertNumberToFloat() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberFloat = this._numberString != null ? this._getNumberFloat() : this._getBigDecimal().floatValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberFloat = this._numberString != null ? this._getNumberFloat() : this._getBigInteger().floatValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberFloat = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberFloat = this._numberInt;
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberFloat = this._numberString != null ? this._getNumberFloat() : (float)this._getNumberDouble();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x20;
    }

    protected void convertNumberToBigDecimal() throws IOException {
        if ((this._numTypesValid & 8) != 0) {
            String string = this._numberString == null ? this.getText() : this._numberString;
            this._numberBigDecimal = em.parseBigDecimal(string, this.isEnabled(cy.USE_FAST_BIG_NUMBER_PARSER));
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._getBigInteger());
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected BigInteger _convertBigDecimalToBigInteger(BigDecimal bigDecimal) throws IOException {
        this._streamReadConstraints.validateBigIntegerScale(bigDecimal.scale());
        return bigDecimal.toBigInteger();
    }

    protected BigInteger _getBigInteger() throws cf {
        if (this._numberBigInt != null) {
            return this._numberBigInt;
        }
        if (this._numberString == null) {
            throw new IllegalStateException("cannot get BigInteger from current parser state");
        }
        try {
            this._numberBigInt = em.parseBigInteger(this._numberString, this.isEnabled(cy.USE_FAST_BIG_NUMBER_PARSER));
        }
        catch (NumberFormatException numberFormatException) {
            dm dm2 = this;
            this._wrapError("Malformed numeric value (" + dm2._longNumberDesc(dm2._numberString) + ")", numberFormatException);
        }
        this._numberString = null;
        return this._numberBigInt;
    }

    protected BigDecimal _getBigDecimal() throws cf {
        if (this._numberBigDecimal != null) {
            return this._numberBigDecimal;
        }
        if (this._numberString == null) {
            throw new IllegalStateException("cannot get BigDecimal from current parser state");
        }
        try {
            this._numberBigDecimal = em.parseBigDecimal(this._numberString, this.isEnabled(cy.USE_FAST_BIG_NUMBER_PARSER));
        }
        catch (NumberFormatException numberFormatException) {
            dm dm2 = this;
            this._wrapError("Malformed numeric value (" + dm2._longNumberDesc(dm2._numberString) + ")", numberFormatException);
        }
        this._numberString = null;
        return this._numberBigDecimal;
    }

    protected double _getNumberDouble() throws cf {
        if (this._numberString != null) {
            try {
                this._numberDouble = em.parseDouble(this._numberString, this.isEnabled(cy.USE_FAST_DOUBLE_PARSER));
            }
            catch (NumberFormatException numberFormatException) {
                dm dm2 = this;
                this._wrapError("Malformed numeric value (" + dm2._longNumberDesc(dm2._numberString) + ")", numberFormatException);
            }
            this._numberString = null;
        }
        return this._numberDouble;
    }

    protected float _getNumberFloat() throws cf {
        if (this._numberString != null) {
            try {
                this._numberFloat = em.parseFloat(this._numberString, this.isEnabled(cy.USE_FAST_DOUBLE_PARSER));
            }
            catch (NumberFormatException numberFormatException) {
                dm dm2 = this;
                this._wrapError("Malformed numeric value (" + dm2._longNumberDesc(dm2._numberString) + ")", numberFormatException);
            }
            this._numberString = null;
        }
        return this._numberFloat;
    }

    protected void createChildArrayContext(int n2, int n3) throws IOException {
        this._parsingContext = this._parsingContext.createChildArrayContext(n2, n3);
        this._streamReadConstraints.validateNestingDepth(this._parsingContext.getNestingDepth());
    }

    protected void createChildObjectContext(int n2, int n3) throws IOException {
        this._parsingContext = this._parsingContext.createChildObjectContext(n2, n3);
        this._streamReadConstraints.validateNestingDepth(this._parsingContext.getNestingDepth());
    }

    protected char _handleUnrecognizedCharacterEscape(char c2) throws co {
        if (this.isEnabled(ch.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return c2;
        }
        if (c2 == '\'' && this.isEnabled(ch.ALLOW_SINGLE_QUOTES)) {
            return c2;
        }
        throw this._constructReadException("Unrecognized character escape " + dm._getCharDesc(c2), this._currentLocationMinusOne());
    }

    protected void _reportMismatchedEndMarker(int n2, char c2) throws cf {
        gh gh2 = this.getParsingContext();
        String string = String.format("Unexpected close marker '%s': expected '%c' (for %s starting at %s)", Character.valueOf((char)n2), Character.valueOf(c2), gh2.typeDesc(), gh2.startLocation(this._contentReference()));
        throw this._constructReadException(string, this._currentLocationMinusOne());
    }

    protected void _throwUnquotedSpace(int n2, String string) throws cf {
        if (!this.isEnabled(ch.ALLOW_UNQUOTED_CONTROL_CHARS) || n2 > 32) {
            char c2 = (char)n2;
            String string2 = "Illegal unquoted character (" + dm._getCharDesc(c2) + "): has to be escaped using backslash to be included in " + string;
            throw this._constructReadException(string2, this._currentLocationMinusOne());
        }
    }

    protected String _validJsonTokenList() throws IOException {
        return this._validJsonValueList();
    }

    protected String _validJsonValueList() throws IOException {
        if (this.isEnabled(ch.ALLOW_NON_NUMERIC_NUMBERS)) {
            return "(JSON String, Number (or 'NaN'/'+INF'/'-INF'), Array, Object or token 'null', 'true' or 'false')";
        }
        return "(JSON String, Number, Array, Object or token 'null', 'true' or 'false')";
    }

    protected char _decodeEscaped() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected final int _decodeBase64Escape(bo bo2, int n2, int n3) throws IOException {
        if (n2 != 92) {
            throw this.reportInvalidBase64Char(bo2, n2, n3);
        }
        char c2 = this._decodeEscaped();
        if (c2 <= ' ' && n3 == 0) {
            return -1;
        }
        int n4 = bo2.decodeBase64Char((int)c2);
        if (n4 < 0 && n4 != -2) {
            throw this.reportInvalidBase64Char(bo2, c2, n3);
        }
        return n4;
    }

    protected final int _decodeBase64Escape(bo bo2, char c2, int n2) throws IOException {
        if (c2 != '\\') {
            throw this.reportInvalidBase64Char(bo2, c2, n2);
        }
        char c3 = this._decodeEscaped();
        if (c3 <= ' ' && n2 == 0) {
            return -1;
        }
        int n3 = bo2.decodeBase64Char(c3);
        if (n3 < 0 && (n3 != -2 || n2 < 2)) {
            throw this.reportInvalidBase64Char(bo2, c3, n2);
        }
        return n3;
    }

    protected IllegalArgumentException reportInvalidBase64Char(bo bo2, int n2, int n3) throws IllegalArgumentException {
        return this.reportInvalidBase64Char(bo2, n2, n3, null);
    }

    protected IllegalArgumentException reportInvalidBase64Char(bo bo2, int n2, int n3, String string) throws IllegalArgumentException {
        String string2 = n2 <= 32 ? String.format("Illegal white space character (code 0x%s) as character #%d of 4-char base64 unit: can only used between units", Integer.toHexString(n2), n3 + 1) : (bo2.usesPaddingChar(n2) ? "Unexpected padding character ('" + bo2.getPaddingChar() + "') as character #" + (n3 + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(n2) || Character.isISOControl(n2) ? "Illegal character (code 0x" + Integer.toHexString(n2) + ") in base64 content" : "Illegal character '" + (char)n2 + "' (code 0x" + Integer.toHexString(n2) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        return new IllegalArgumentException(string2);
    }

    protected void _handleBase64MissingPadding(bo bo2) throws IOException {
        this._reportError(bo2.missingPaddingMessage());
    }

    @Deprecated
    protected Object _getSourceReference() {
        if (ch.INCLUDE_SOURCE_IN_LOCATION.enabledIn(this._features)) {
            return this._ioContext.contentReference().getRawContent();
        }
        return null;
    }

    protected ef _contentReference() {
        if (ch.INCLUDE_SOURCE_IN_LOCATION.enabledIn(this._features)) {
            return this._ioContext.contentReference();
        }
        return this._contentReferenceRedacted();
    }

    protected ef _contentReferenceRedacted() {
        return ef.redacted();
    }

    protected static int[] growArrayBy(int[] nArray, int n2) throws IllegalArgumentException {
        if (nArray == null) {
            return new int[n2];
        }
        int n3 = nArray.length + n2;
        if (n3 < 0) {
            throw new IllegalArgumentException("Unable to grow array to longer than `Integer.MAX_VALUE`");
        }
        return Arrays.copyOf(nArray, n3);
    }

    protected int[] _growNameDecodeBuffer(int[] nArray, int n2) throws dp {
        this._streamReadConstraints.validateNameLength(nArray.length << 2);
        return dm.growArrayBy(nArray, n2);
    }

    @Deprecated
    protected void loadMoreGuaranteed() throws IOException {
        if (!this.loadMore()) {
            this._reportInvalidEOF();
        }
    }

    @Deprecated
    protected boolean loadMore() throws IOException {
        return false;
    }

    protected void _finishString() throws IOException {
    }
}

