/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.sdk.lib;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlRootElement;
import lombok.Generated;
import us.hebi.sdk.lib.aj;
import us.hebi.sdk.lib.ajv;
import us.hebi.sdk.lib.bg;
import us.hebi.sdk.lib.bpt;
import us.hebi.sdk.lib.bpu;
import us.hebi.sdk.lib.bpv;
import us.hebi.sdk.lib.bpw;
import us.hebi.sdk.lib.bzw;
import us.hebi.sdk.lib.bzx;
import us.hebi.sdk.lib.clm;
import us.hebi.sdk.lib.f;
import us.hebi.sdk.lib.ke;

@XmlRootElement
public class bps {
    private static final Pattern VALID_STRUCT_FIELD_NAME = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
    private URL origin;
    private bzw version;
    private List<String> names = Collections.emptyList();
    private List<String> families = Collections.emptyList();
    private double feedbackFrequency = Double.NaN;
    private double commandLifetime = Double.NaN;
    private String hrdf;
    private Map<String, String> gains = Collections.emptyMap();
    private List<bpw> plugins = Collections.emptyList();
    private Map<String, Object> userData;
    private static final bzw VERSION_1_0_0 = new bzw("1.0.0");
    private static final bzw VERSION_1_1_0;
    public static bzw HIGHEST_SUPPORTED_VERSION;

    public static bps tryReadFile(Path path) throws IOException {
        clm.a(Files.isRegularFile(path, new LinkOption[0]), (Object)"file is not a regular file");
        Path path2 = path;
        return bps.parseURL((URL)bzx.a(new bpt(path2))).relativizePaths().validate();
    }

    public static bps parseURL(URL uRL) throws IOException {
        clm.a(uRL, "invalid input: %s", uRL);
        ke ke2 = new ke(new ajv());
        ke2.registerSubtypes(bps.class, bpw.class);
        return ke2.readValue(uRL, bps.class).setOrigin(uRL);
    }

    private bps setOrigin(URL uRL) {
        this.origin = uRL;
        return this;
    }

    public bps relativizePaths() {
        URL uRL = clm.a(this.origin, (Object)"origin: null");
        uRL.getClass();
        Serializable serializable = uRL;
        URI uRI = (URI)bzx.a(new bpu((URL)serializable));
        this.hrdf = this.relativize(uRI, this.hrdf);
        serializable = uRI;
        bps bps2 = this;
        this.gains.replaceAll(new bpv(bps2, (URI)serializable));
        return this;
    }

    private String relativize(URI uRI, String string) {
        if (string == null) {
            return null;
        }
        return Paths.get(uRI.resolve(string)).toAbsolutePath().toString();
    }

    private String relativize(Path path, String string) {
        if (string == null) {
            return null;
        }
        return path.relativize(Paths.get(string, new String[0])).toAbsolutePath().toString();
    }

    public bps validate() {
        clm.a(!this.names.isEmpty(), (Object)"Names must not be empty");
        clm.a(!this.families.isEmpty(), (Object)"Families must not be empty");
        clm.a(this.families.size() == 1 || this.families.size() == this.names.size(), (Object)"Families must be singular or match the number of names");
        clm.a(this.version != null, (Object)"Version must be set");
        bps.validateKeys(this.gains);
        bps.validateKeys(this.userData);
        if (this.plugins != null && !this.plugins.isEmpty()) {
            Iterator<bpw> iterator = this.plugins.iterator();
            while (iterator.hasNext()) {
                bps.validateKeys(iterator.next().getProps());
            }
        }
        return this;
    }

    private static void validateKeys(Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (String string : map.keySet()) {
            clm.a(bps.isValidKey(string), "Keys must be alphanumeric with optional underscores and do not start with a number. Encountered invalid key '%s'", new Object[]{string});
        }
    }

    private static boolean isValidKey(String string) {
        return VALID_STRUCT_FIELD_NAME.matcher(string).matches();
    }

    @aj(value="names", required=true)
    public void setNames(Object object) {
        this.names = bps.toStringList(object);
    }

    @aj(value="families", required=true)
    public void setFamilies(Object object) {
        this.families = bps.toStringList(object);
    }

    @aj(value="feedback_frequency")
    public void setFeedbackFrequency(double d2) {
        this.requireMinimumVersion(VERSION_1_1_0);
        this.feedbackFrequency = d2;
    }

    @aj(value="command_lifetime")
    public void setCommandLifetime(double d2) {
        this.requireMinimumVersion(VERSION_1_1_0);
        this.commandLifetime = d2;
    }

    @aj(value="hrdf")
    public void setHrdf(String string) {
        this.hrdf = string;
    }

    @aj(value="gains")
    public void setGains(Object object) {
        if (object == null) {
            this.gains = Collections.emptyMap();
            return;
        }
        if (object instanceof String) {
            this.gains = new HashMap<String, String>();
            this.gains.put("default", (String)object);
            return;
        }
        if (object instanceof Map) {
            this.gains = (Map)object;
            return;
        }
        throw new IllegalArgumentException("Expected file or list of named gains. Found: ".concat(String.valueOf(object)));
    }

    @aj(value="user_data")
    public void setUserData(Object object) {
        if (object == null) {
            this.userData = Collections.emptyMap();
            return;
        }
        if (object instanceof Map) {
            this.userData = (Map)object;
            return;
        }
        throw new IllegalArgumentException("Expected list of key:value pairs. Found: ".concat(String.valueOf(object)));
    }

    @aj(value="plugins")
    public void setPlugins(List<bpw> list) {
        if (list == null) {
            this.plugins = Collections.emptyList();
            return;
        }
        this.plugins = list;
    }

    private static List<String> toStringList(Object object) {
        if (object instanceof String) {
            return Collections.singletonList((String)object);
        }
        if (object instanceof List) {
            return (List)object;
        }
        throw new IllegalArgumentException("Expected string or list of strings");
    }

    @f
    public void setProperty(String string, Object object) {
        if (this.version == null) {
            throw new IllegalStateException("Encountered unknown field for an unknown version. Please specify the file version on the first line.");
        }
        if (HIGHEST_SUPPORTED_VERSION.c(this.version)) {
            throw new IllegalArgumentException("Encountered unsupported key '" + string + "' with value '" + object + "'");
        }
        System.err.printf("Ignoring unknown field '%s' with value '%s'%n", string, object);
    }

    @aj(value="version", required=true)
    public void setVersion(String string) {
        this.version = new bzw(string);
        if (HIGHEST_SUPPORTED_VERSION.a(this.version)) {
            throw new IllegalArgumentException(String.format("This API supports robot config version '%s'. Please update your API to parse version '%s' files.", HIGHEST_SUPPORTED_VERSION, this.version));
        }
        if (HIGHEST_SUPPORTED_VERSION.b(this.version)) {
            System.err.printf("This API supports robot config version '%s'. Please upgrade your API to fully parse version '%s'. Some features may not be available.%n", HIGHEST_SUPPORTED_VERSION, this.version);
        }
    }

    private void requireMinimumVersion(bzw bzw2) {
        if (!this.version.c(bzw2)) {
            bg.a("The robot config file specifies version '%s' but uses features that were introduced in '%s'", new Object[]{this.version.toString(), bzw2.toString()});
        }
    }

    @Generated
    public bzw getVersion() {
        return this.version;
    }

    @Generated
    public List<String> getNames() {
        return this.names;
    }

    @Generated
    public List<String> getFamilies() {
        return this.families;
    }

    @Generated
    public double getFeedbackFrequency() {
        return this.feedbackFrequency;
    }

    @Generated
    public double getCommandLifetime() {
        return this.commandLifetime;
    }

    @Generated
    public String getHrdf() {
        return this.hrdf;
    }

    @Generated
    public Map<String, String> getGains() {
        return this.gains;
    }

    @Generated
    public List<bpw> getPlugins() {
        return this.plugins;
    }

    @Generated
    public Map<String, Object> getUserData() {
        return this.userData;
    }

    @Generated
    public String toString() {
        return "RobotConfig(origin=" + this.getOrigin() + ", version=" + this.getVersion() + ", names=" + this.getNames() + ", families=" + this.getFamilies() + ", feedbackFrequency=" + this.getFeedbackFrequency() + ", commandLifetime=" + this.getCommandLifetime() + ", hrdf=" + this.getHrdf() + ", gains=" + this.getGains() + ", plugins=" + this.getPlugins() + ", userData=" + this.getUserData() + ")";
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof bps)) {
            return false;
        }
        bps bps2 = (bps)object;
        if (!bps2.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getFeedbackFrequency(), bps2.getFeedbackFrequency()) != 0) {
            return false;
        }
        if (Double.compare(this.getCommandLifetime(), bps2.getCommandLifetime()) != 0) {
            return false;
        }
        URL uRL = this.getOrigin();
        URL uRL2 = bps2.getOrigin();
        if (uRL == null ? uRL2 != null : !((Object)uRL).equals(uRL2)) {
            return false;
        }
        bzw bzw2 = this.getVersion();
        bzw bzw3 = bps2.getVersion();
        if (bzw2 == null ? bzw3 != null : !((Object)bzw2).equals(bzw3)) {
            return false;
        }
        List<String> list = this.getNames();
        List<String> list2 = bps2.getNames();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<String> list3 = this.getFamilies();
        List<String> list4 = bps2.getFamilies();
        if (list3 == null ? list4 != null : !((Object)list3).equals(list4)) {
            return false;
        }
        String string = this.getHrdf();
        String string2 = bps2.getHrdf();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        Map<String, String> map = this.getGains();
        Map<String, String> map2 = bps2.getGains();
        if (map == null ? map2 != null : !((Object)map).equals(map2)) {
            return false;
        }
        List<bpw> list5 = this.getPlugins();
        List<bpw> list6 = bps2.getPlugins();
        if (list5 == null ? list6 != null : !((Object)list5).equals(list6)) {
            return false;
        }
        Map<String, Object> map3 = this.getUserData();
        Map<String, Object> map4 = bps2.getUserData();
        return !(map3 == null ? map4 != null : !((Object)map3).equals(map4));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof bps;
    }

    @Generated
    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.getFeedbackFrequency());
        int n2 = 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = Double.doubleToLongBits(this.getCommandLifetime());
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        URL uRL = this.getOrigin();
        n2 = n2 * 59 + (uRL == null ? 43 : ((Object)uRL).hashCode());
        bzw bzw2 = this.getVersion();
        n2 = n2 * 59 + (bzw2 == null ? 43 : ((Object)bzw2).hashCode());
        List<String> list = this.getNames();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<String> list2 = this.getFamilies();
        n2 = n2 * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        String string = this.getHrdf();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        Map<String, String> map = this.getGains();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        List<bpw> list3 = this.getPlugins();
        n2 = n2 * 59 + (list3 == null ? 43 : ((Object)list3).hashCode());
        Map<String, Object> map2 = this.getUserData();
        return n2 * 59 + (map2 == null ? 43 : ((Object)map2).hashCode());
    }

    @Generated
    public URL getOrigin() {
        return this.origin;
    }

    private /* synthetic */ String lambda$relativizePaths$1(URI uRI, String string, String string2) {
        return this.relativize(uRI, this.gains.get(string));
    }

    private static /* synthetic */ URL lambda$tryReadFile$0(Path path) throws Exception {
        return path.toUri().toURL();
    }

    static {
        HIGHEST_SUPPORTED_VERSION = VERSION_1_1_0 = new bzw("1.1.0");
    }

    static /* synthetic */ URL a(Path path) {
        return bps.lambda$tryReadFile$0(path);
    }

    static /* synthetic */ String a(bps bps2, URI uRI, String string, String string2) {
        return bps2.lambda$relativizePaths$1(uRI, string, string2);
    }
}

