/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.sdk.lib;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import us.hebi.sdk.lib.ait;
import us.hebi.sdk.lib.aiz;
import us.hebi.sdk.lib.aja;
import us.hebi.sdk.lib.ajb;
import us.hebi.sdk.lib.ajg;
import us.hebi.sdk.lib.aji;
import us.hebi.sdk.lib.ajj;
import us.hebi.sdk.lib.ajk;
import us.hebi.sdk.lib.ajl;
import us.hebi.sdk.lib.ajm;
import us.hebi.sdk.lib.ajo;
import us.hebi.sdk.lib.ajp;

public final class aix<K, V>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final int NUMBER_OF_READ_BUFFERS = Math.min(4, aix.ceilingNextPowerOfTwo(NCPU));
    static final int READ_BUFFERS_MASK = NUMBER_OF_READ_BUFFERS - 1;
    static final int READ_BUFFER_THRESHOLD = 4;
    static final int READ_BUFFER_DRAIN_THRESHOLD = 8;
    static final int READ_BUFFER_SIZE = 16;
    static final int READ_BUFFER_INDEX_MASK = 15;
    static final int WRITE_BUFFER_DRAIN_THRESHOLD = 16;
    final ConcurrentMap<K, ajj<K, V>> data;
    final int concurrencyLevel;
    final long[] readBufferReadCount;
    final ait<ajj<K, V>> evictionDeque;
    final AtomicLong weightedSize;
    final AtomicLong capacity;
    final Lock evictionLock;
    final Queue<Runnable> writeBuffer;
    final AtomicLongArray readBufferWriteCount;
    final AtomicLongArray readBufferDrainAtWriteCount;
    final AtomicReferenceArray<ajj<K, V>> readBuffers;
    final AtomicReference<ajb> drainStatus;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    static int ceilingNextPowerOfTwo(int n2) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    private static int readBufferIndex(int n2, int n3) {
        return (n2 << 4) + n3;
    }

    aix(aja<K, V> aja2) {
        this.concurrencyLevel = aja2.concurrencyLevel;
        this.capacity = new AtomicLong(Math.min(aja2.capacity, 9223372034707292160L));
        this.data = new ConcurrentHashMap<K, ajj<K, V>>(aja2.initialCapacity, 0.75f, this.concurrencyLevel);
        this.evictionLock = new ReentrantLock();
        this.weightedSize = new AtomicLong();
        this.evictionDeque = new ait();
        this.writeBuffer = new ConcurrentLinkedQueue<Runnable>();
        this.drainStatus = new AtomicReference<ajb>(ajb.IDLE);
        this.readBufferReadCount = new long[NUMBER_OF_READ_BUFFERS];
        this.readBufferWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBufferDrainAtWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBuffers = new AtomicReferenceArray(NUMBER_OF_READ_BUFFERS << 4);
    }

    static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static void checkArgument(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException();
        }
    }

    static void checkState(boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException();
        }
    }

    public final long capacity() {
        return this.capacity.get();
    }

    public final void setCapacity(long l2) {
        aix.checkArgument(l2 >= 0L);
        this.evictionLock.lock();
        try {
            this.capacity.lazySet(Math.min(l2, 9223372034707292160L));
            this.drainBuffers();
            this.evict();
            return;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    final boolean hasOverflowed() {
        return this.weightedSize.get() > this.capacity.get();
    }

    final void evict() {
        while (this.hasOverflowed()) {
            ajj ajj2 = (ajj)this.evictionDeque.poll();
            if (ajj2 == null) {
                return;
            }
            this.data.remove(ajj2.key, ajj2);
            this.makeDead(ajj2);
        }
    }

    final void afterRead(ajj<K, V> ajj2) {
        int n2 = aix.readBufferIndex();
        long l2 = this.recordRead(n2, ajj2);
        this.drainOnReadIfNeeded(n2, l2);
    }

    static int readBufferIndex() {
        return (int)Thread.currentThread().getId() & READ_BUFFERS_MASK;
    }

    final long recordRead(int n2, ajj<K, V> ajj2) {
        long l2 = this.readBufferWriteCount.get(n2);
        this.readBufferWriteCount.lazySet(n2, l2 + 1L);
        int n3 = (int)(l2 & 0xFL);
        this.readBuffers.lazySet(aix.readBufferIndex(n2, n3), ajj2);
        return l2;
    }

    final void drainOnReadIfNeeded(int n2, long l2) {
        boolean bl2;
        boolean bl3 = bl2 = l2 - this.readBufferDrainAtWriteCount.get(n2) < 4L;
        if (this.drainStatus.get().shouldDrainBuffers(bl2)) {
            this.tryToDrainBuffers();
        }
    }

    final void afterWrite(Runnable runnable) {
        this.writeBuffer.add(runnable);
        this.drainStatus.lazySet(ajb.REQUIRED);
        this.tryToDrainBuffers();
    }

    final void tryToDrainBuffers() {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.lazySet(ajb.PROCESSING);
                this.drainBuffers();
                return;
            }
            finally {
                this.drainStatus.compareAndSet(ajb.PROCESSING, ajb.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    final void drainBuffers() {
        this.drainReadBuffers();
        this.drainWriteBuffer();
    }

    final void drainReadBuffers() {
        int n2 = (int)Thread.currentThread().getId();
        int n3 = n2 + NUMBER_OF_READ_BUFFERS;
        for (int i2 = n2; i2 < n3; ++i2) {
            this.drainReadBuffer(i2 & READ_BUFFERS_MASK);
        }
    }

    final void drainReadBuffer(int n2) {
        int n3;
        int n4;
        ajj<K, V> ajj2;
        long l2 = this.readBufferWriteCount.get(n2);
        for (int i2 = 0; i2 < 8 && (ajj2 = this.readBuffers.get(n4 = aix.readBufferIndex(n2, n3 = (int)(this.readBufferReadCount[n2] & 0xFL)))) != null; ++i2) {
            this.readBuffers.lazySet(n4, null);
            this.applyRead(ajj2);
            int n5 = n2;
            this.readBufferReadCount[n5] = this.readBufferReadCount[n5] + 1L;
        }
        this.readBufferDrainAtWriteCount.lazySet(n2, l2);
    }

    final void applyRead(ajj<K, V> ajj2) {
        if (this.evictionDeque.contains(ajj2)) {
            this.evictionDeque.moveToBack(ajj2);
        }
    }

    final void drainWriteBuffer() {
        Runnable runnable;
        for (int i2 = 0; i2 < 16 && (runnable = this.writeBuffer.poll()) != null; ++i2) {
            runnable.run();
        }
    }

    final boolean tryToRetire(ajj<K, V> ajj2, ajp<V> ajp2) {
        if (ajp2.isAlive()) {
            ajp ajp3 = new ajp(ajp2.value, -ajp2.weight);
            return ajj2.compareAndSet(ajp2, ajp3);
        }
        return false;
    }

    final void makeRetired(ajj<K, V> ajj2) {
        ajp ajp2;
        ajp ajp3;
        do {
            if ((ajp3 = (ajp)ajj2.get()).isAlive()) continue;
            return;
        } while (!ajj2.compareAndSet(ajp3, ajp2 = new ajp(ajp3.value, -ajp3.weight)));
    }

    final void makeDead(ajj<K, V> ajj2) {
        ajp ajp2;
        ajp ajp3;
        while (!ajj2.compareAndSet(ajp3 = (ajp)ajj2.get(), ajp2 = new ajp(ajp3.value, 0))) {
        }
        this.weightedSize.lazySet(this.weightedSize.get() - (long)Math.abs(ajp3.weight));
    }

    @Override
    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public final int size() {
        return this.data.size();
    }

    @Override
    public final void clear() {
        this.evictionLock.lock();
        try {
            Runnable runnable;
            ajj ajj2;
            while ((ajj2 = (ajj)this.evictionDeque.poll()) != null) {
                this.data.remove(ajj2.key, ajj2);
                this.makeDead(ajj2);
            }
            for (int i2 = 0; i2 < this.readBuffers.length(); ++i2) {
                this.readBuffers.lazySet(i2, null);
            }
            while ((runnable = this.writeBuffer.poll()) != null) {
                runnable.run();
            }
            return;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.data.containsKey(object);
    }

    @Override
    public final boolean containsValue(Object object) {
        aix.checkNotNull(object);
        Iterator iterator = this.data.values().iterator();
        while (iterator.hasNext()) {
            if (!((ajj)iterator.next()).getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final V get(Object object) {
        ajj ajj2 = (ajj)this.data.get(object);
        if (ajj2 == null) {
            return null;
        }
        this.afterRead(ajj2);
        return ajj2.getValue();
    }

    @Override
    public final V put(K k2, V v2) {
        return this.put(k2, v2, false);
    }

    @Override
    public final V putIfAbsent(K k2, V v2) {
        return this.put(k2, v2, true);
    }

    final V put(K k2, V v2, boolean bl2) {
        ajp ajp2;
        ajj<K, ajp<V>> ajj2;
        aix.checkNotNull(k2);
        aix.checkNotNull(v2);
        ajp<V> ajp3 = new ajp<V>(v2, 1);
        ajj<K, V> ajj3 = new ajj<K, V>(k2, ajp3);
        block0: while (true) {
            if ((ajj2 = this.data.putIfAbsent(ajj3.key, ajj3)) == null) {
                this.afterWrite(new aiz(this, ajj3, 1));
                return null;
            }
            if (bl2) {
                this.afterRead(ajj2);
                return ajj2.getValue();
            }
            do {
                if (!(ajp2 = (ajp)ajj2.get()).isAlive()) continue block0;
            } while (!ajj2.compareAndSet(ajp2, ajp3));
            break;
        }
        int n2 = 1 - ajp2.weight;
        if (n2 == 0) {
            this.afterRead(ajj2);
        } else {
            this.afterWrite(new ajm(this, ajj2, n2));
        }
        return ajp2.value;
    }

    @Override
    public final V remove(Object object) {
        ajj ajj2 = (ajj)this.data.remove(object);
        if (ajj2 == null) {
            return null;
        }
        this.makeRetired(ajj2);
        this.afterWrite(new ajk(this, ajj2));
        return ajj2.getValue();
    }

    @Override
    public final boolean remove(Object object, Object object2) {
        ajj ajj2 = (ajj)this.data.get(object);
        if (ajj2 == null || object2 == null) {
            return false;
        }
        ajp ajp2 = (ajp)ajj2.get();
        while (ajp2.contains(object2)) {
            if (this.tryToRetire(ajj2, ajp2)) {
                if (!this.data.remove(object, ajj2)) break;
                this.afterWrite(new ajk(this, ajj2));
                return true;
            }
            ajp2 = (ajp)ajj2.get();
            if (ajp2.isAlive()) continue;
        }
        return false;
    }

    @Override
    public final V replace(K k2, V v2) {
        ajp ajp2;
        aix.checkNotNull(k2);
        aix.checkNotNull(v2);
        ajp<V> ajp3 = new ajp<V>(v2, 1);
        ajj ajj2 = (ajj)this.data.get(k2);
        if (ajj2 == null) {
            return null;
        }
        do {
            if ((ajp2 = (ajp)ajj2.get()).isAlive()) continue;
            return null;
        } while (!ajj2.compareAndSet(ajp2, ajp3));
        int n2 = 1 - ajp2.weight;
        if (n2 == 0) {
            this.afterRead(ajj2);
        } else {
            this.afterWrite(new ajm(this, ajj2, n2));
        }
        return ajp2.value;
    }

    @Override
    public final boolean replace(K k2, V v2, V v3) {
        ajp ajp2;
        aix.checkNotNull(k2);
        aix.checkNotNull(v2);
        aix.checkNotNull(v3);
        ajp<V> ajp3 = new ajp<V>(v3, 1);
        ajj ajj2 = (ajj)this.data.get(k2);
        if (ajj2 == null) {
            return false;
        }
        do {
            if ((ajp2 = (ajp)ajj2.get()).isAlive() && ajp2.contains(v2)) continue;
            return false;
        } while (!ajj2.compareAndSet(ajp2, ajp3));
        int n2 = 1 - ajp2.weight;
        if (n2 == 0) {
            this.afterRead(ajj2);
        } else {
            this.afterWrite(new ajm(this, ajj2, n2));
        }
        return true;
    }

    @Override
    public final Set<K> keySet() {
        Set<K> set = this.keySet;
        if (set == null) {
            this.keySet = new aji(this);
            return this.keySet;
        }
        return set;
    }

    @Override
    public final Collection<V> values() {
        Collection<V> collection = this.values;
        if (collection == null) {
            this.values = new ajo(this);
            return this.values;
        }
        return collection;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set == null) {
            this.entrySet = new ajg(this);
            return this.entrySet;
        }
        return set;
    }

    final Object writeReplace() {
        return new ajl(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }
}

