/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.sdk.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import us.hebi.sdk.lib.ahi;
import us.hebi.sdk.lib.aim;
import us.hebi.sdk.lib.ain;
import us.hebi.sdk.lib.bo;
import us.hebi.sdk.lib.bv;
import us.hebi.sdk.lib.ce;
import us.hebi.sdk.lib.ci;
import us.hebi.sdk.lib.cj;
import us.hebi.sdk.lib.cp;
import us.hebi.sdk.lib.cq;
import us.hebi.sdk.lib.cs;
import us.hebi.sdk.lib.cv;
import us.hebi.sdk.lib.cw;
import us.hebi.sdk.lib.cy;
import us.hebi.sdk.lib.dg;
import us.hebi.sdk.lib.dn;
import us.hebi.sdk.lib.em;
import us.hebi.sdk.lib.hh;
import us.hebi.sdk.lib.hq;
import us.hebi.sdk.lib.mw;

public final class ail
extends dn {
    protected cs _codec;
    protected cw _streamReadConstraints;
    protected final boolean _hasNativeTypeIds;
    protected final boolean _hasNativeObjectIds;
    protected final boolean _hasNativeIds;
    protected aim _segment;
    protected int _segmentPtr;
    protected ain _parsingContext;
    protected boolean _closed;
    protected transient hh _byteBuilder;
    protected ce _location = null;

    @Deprecated
    public ail(aim aim2, cs cs2, boolean bl2, boolean bl3) {
        this(aim2, cs2, bl2, bl3, null);
    }

    @Deprecated
    public ail(aim aim2, cs cs2, boolean bl2, boolean bl3, cp cp2) {
        this(aim2, cs2, bl2, bl3, cp2, cw.defaults());
    }

    public ail(aim aim2, cs cs2, boolean bl2, boolean bl3, cp cp2, cw cw2) {
        this._segment = aim2;
        this._segmentPtr = -1;
        this._codec = cs2;
        this._streamReadConstraints = cw2;
        this._parsingContext = ain.createRootContext(cp2);
        this._hasNativeTypeIds = bl2;
        this._hasNativeObjectIds = bl3;
        this._hasNativeIds = bl2 || bl3;
    }

    public final void setLocation(ce ce2) {
        this._location = ce2;
    }

    @Override
    public final cs getCodec() {
        return this._codec;
    }

    @Override
    public final void setCodec(cs cs2) {
        this._codec = cs2;
    }

    @Override
    public final dg version() {
        return mw.VERSION;
    }

    @Override
    public final hq<cv> getReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    @Override
    public final cw streamReadConstraints() {
        return this._streamReadConstraints;
    }

    public final cq peekNextToken() throws IOException {
        if (this._closed) {
            return null;
        }
        aim aim2 = this._segment;
        int n2 = this._segmentPtr + 1;
        if (n2 >= 16) {
            n2 = 0;
            aim aim3 = aim2 = aim2 == null ? null : aim2.next();
        }
        if (aim2 == null) {
            return null;
        }
        return aim2.type(n2);
    }

    @Override
    public final void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
        }
    }

    @Override
    public final cq nextToken() throws IOException {
        if (this._closed || this._segment == null) {
            return null;
        }
        if (++this._segmentPtr >= 16) {
            this._segmentPtr = 0;
            this._segment = this._segment.next();
            if (this._segment == null) {
                return null;
            }
        }
        this._currToken = this._segment.type(this._segmentPtr);
        if (this._currToken == cq.FIELD_NAME) {
            Object object = this._currentObject();
            String string = object instanceof String ? (String)object : object.toString();
            this._parsingContext.setCurrentName(string);
        } else if (this._currToken == cq.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext();
        } else if (this._currToken == cq.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext();
        } else if (this._currToken == cq.END_OBJECT || this._currToken == cq.END_ARRAY) {
            this._parsingContext = this._parsingContext.parentOrCopy();
        } else {
            this._parsingContext.updateForValue();
        }
        return this._currToken;
    }

    @Override
    public final String nextFieldName() throws IOException {
        if (this._closed || this._segment == null) {
            return null;
        }
        int n2 = this._segmentPtr + 1;
        if (n2 < 16 && this._segment.type(n2) == cq.FIELD_NAME) {
            this._segmentPtr = n2;
            this._currToken = cq.FIELD_NAME;
            Object object = this._segment.get(n2);
            String string = object instanceof String ? (String)object : object.toString();
            this._parsingContext.setCurrentName(string);
            return string;
        }
        if (this.nextToken() == cq.FIELD_NAME) {
            return this.currentName();
        }
        return null;
    }

    @Override
    public final boolean isClosed() {
        return this._closed;
    }

    @Override
    public final cp getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public final ce currentLocation() {
        if (this._location == null) {
            return ce.NA;
        }
        return this._location;
    }

    @Override
    public final ce currentTokenLocation() {
        return this.currentLocation();
    }

    @Override
    @Deprecated
    public final ce getTokenLocation() {
        return this.currentTokenLocation();
    }

    @Override
    @Deprecated
    public final ce getCurrentLocation() {
        return this.currentLocation();
    }

    @Override
    public final String currentName() {
        if (this._currToken == cq.START_OBJECT || this._currToken == cq.START_ARRAY) {
            return this._parsingContext.getParent().getCurrentName();
        }
        return this._parsingContext.getCurrentName();
    }

    @Override
    public final void overrideCurrentName(String string) {
        cp cp2 = this._parsingContext;
        if (this._currToken == cq.START_OBJECT || this._currToken == cq.START_ARRAY) {
            cp2 = cp2.getParent();
        }
        if (cp2 instanceof ain) {
            try {
                ((ain)cp2).setCurrentName(string);
                return;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    @Override
    @Deprecated
    public final String getCurrentName() {
        return this.currentName();
    }

    @Override
    public final String getText() {
        if (this._currToken == cq.VALUE_STRING || this._currToken == cq.FIELD_NAME) {
            Object object = this._currentObject();
            if (object instanceof String) {
                return (String)object;
            }
            return ahi.nullOrToString(object);
        }
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return ahi.nullOrToString(this._currentObject());
            }
        }
        return this._currToken.asString();
    }

    @Override
    public final char[] getTextCharacters() {
        String string = this.getText();
        if (string == null) {
            return null;
        }
        return string.toCharArray();
    }

    @Override
    public final int getTextLength() {
        String string = this.getText();
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    @Override
    public final int getTextOffset() {
        return 0;
    }

    @Override
    public final boolean hasTextCharacters() {
        return false;
    }

    @Override
    public final boolean isNaN() {
        if (this._currToken == cq.VALUE_NUMBER_FLOAT) {
            Object object = this._currentObject();
            if (object instanceof Double) {
                return !Double.isFinite((Double)object);
            }
            if (object instanceof Float) {
                return !Double.isFinite(((Float)object).floatValue());
            }
        }
        return false;
    }

    @Override
    public final BigInteger getBigIntegerValue() throws IOException {
        Number number = this.getNumberValue(true);
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            this.streamReadConstraints().validateBigIntegerScale(bigDecimal.scale());
            return bigDecimal.toBigInteger();
        }
        return BigInteger.valueOf(number.longValue());
    }

    @Override
    public final BigDecimal getDecimalValue() throws IOException {
        Number number = this.getNumberValue(true);
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Integer) {
            return BigDecimal.valueOf(number.intValue());
        }
        if (number instanceof Long) {
            return BigDecimal.valueOf(number.longValue());
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return BigDecimal.valueOf(number.doubleValue());
    }

    @Override
    public final double getDoubleValue() throws IOException {
        return this.getNumberValue().doubleValue();
    }

    @Override
    public final float getFloatValue() throws IOException {
        return this.getNumberValue().floatValue();
    }

    @Override
    public final int getIntValue() throws IOException {
        Number number = this._currToken == cq.VALUE_NUMBER_INT ? (Number)((Number)this._currentObject()) : (Number)this.getNumberValue();
        if (number instanceof Integer || this._smallerThanInt(number)) {
            return number.intValue();
        }
        return this._convertNumberToInt(number);
    }

    @Override
    public final long getLongValue() throws IOException {
        Number number = this._currToken == cq.VALUE_NUMBER_INT ? (Number)((Number)this._currentObject()) : (Number)this.getNumberValue();
        if (number instanceof Long || this._smallerThanLong(number)) {
            return number.longValue();
        }
        return this._convertNumberToLong(number);
    }

    @Override
    public final ci getNumberType() throws IOException {
        Object object = this.getNumberValueDeferred();
        if (object instanceof Integer) {
            return ci.INT;
        }
        if (object instanceof Long) {
            return ci.LONG;
        }
        if (object instanceof Double) {
            return ci.DOUBLE;
        }
        if (object instanceof BigDecimal) {
            return ci.BIG_DECIMAL;
        }
        if (object instanceof BigInteger) {
            return ci.BIG_INTEGER;
        }
        if (object instanceof Float) {
            return ci.FLOAT;
        }
        if (object instanceof Short) {
            return ci.INT;
        }
        if (object instanceof String) {
            if (this._currToken == cq.VALUE_NUMBER_FLOAT) {
                return ci.BIG_DECIMAL;
            }
            return ci.BIG_INTEGER;
        }
        return null;
    }

    @Override
    public final cj getNumberTypeFP() throws IOException {
        if (this._currToken == cq.VALUE_NUMBER_FLOAT) {
            Object object = this._currentObject();
            if (object instanceof Double) {
                return cj.DOUBLE64;
            }
            if (object instanceof BigDecimal) {
                return cj.BIG_DECIMAL;
            }
            if (object instanceof Float) {
                return cj.FLOAT32;
            }
        }
        return cj.UNKNOWN;
    }

    @Override
    public final Number getNumberValue() throws IOException {
        return this.getNumberValue(false);
    }

    @Override
    public final Object getNumberValueDeferred() throws IOException {
        this._checkIsNumber();
        return this._currentObject();
    }

    private Number getNumberValue(boolean bl2) throws IOException {
        this._checkIsNumber();
        Object object = this._currentObject();
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            int n2 = string.length();
            if (this._currToken == cq.VALUE_NUMBER_INT) {
                if (bl2 || n2 >= 19) {
                    return em.parseBigInteger(string, this.isEnabled(cy.USE_FAST_BIG_NUMBER_PARSER));
                }
                if (n2 >= 10) {
                    return em.parseLong(string);
                }
                return em.parseInt(string);
            }
            if (bl2) {
                BigDecimal bigDecimal = em.parseBigDecimal(string, this.isEnabled(cy.USE_FAST_BIG_NUMBER_PARSER));
                if (bigDecimal == null) {
                    throw new IllegalStateException("Internal error: failed to parse number '" + string + "'");
                }
                return bigDecimal;
            }
            return em.parseDouble(string, this.isEnabled(cy.USE_FAST_DOUBLE_PARSER));
        }
        throw new IllegalStateException("Internal error: entry should be a Number, but is of type " + ahi.classNameOf(object));
    }

    private final boolean _smallerThanInt(Number number) {
        return number instanceof Short || number instanceof Byte;
    }

    private final boolean _smallerThanLong(Number number) {
        return number instanceof Integer || number instanceof Short || number instanceof Byte;
    }

    protected final int _convertNumberToInt(Number number) throws IOException {
        if (number instanceof Long) {
            long l2 = number.longValue();
            int n2 = (int)l2;
            if ((long)n2 != l2) {
                this.reportOverflowInt();
            }
            return n2;
        }
        if (number instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)number;
            if (BI_MIN_INT.compareTo(bigInteger) > 0 || BI_MAX_INT.compareTo(bigInteger) < 0) {
                this.reportOverflowInt();
            }
        } else {
            if (number instanceof Double || number instanceof Float) {
                double d2 = number.doubleValue();
                if (d2 < -2.147483648E9 || d2 > 2.147483647E9) {
                    this.reportOverflowInt();
                }
                return (int)d2;
            }
            if (number instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)number;
                if (BD_MIN_INT.compareTo(bigDecimal) > 0 || BD_MAX_INT.compareTo(bigDecimal) < 0) {
                    this.reportOverflowInt();
                }
            } else {
                this._throwInternal();
            }
        }
        return number.intValue();
    }

    protected final long _convertNumberToLong(Number number) throws IOException {
        if (number instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)number;
            if (BI_MIN_LONG.compareTo(bigInteger) > 0 || BI_MAX_LONG.compareTo(bigInteger) < 0) {
                this.reportOverflowLong();
            }
        } else {
            if (number instanceof Double || number instanceof Float) {
                double d2 = number.doubleValue();
                if (d2 < -9.223372036854776E18 || d2 > 9.223372036854776E18) {
                    this.reportOverflowLong();
                }
                return (long)d2;
            }
            if (number instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)number;
                if (BD_MIN_LONG.compareTo(bigDecimal) > 0 || BD_MAX_LONG.compareTo(bigDecimal) < 0) {
                    this.reportOverflowLong();
                }
            } else {
                this._throwInternal();
            }
        }
        return number.longValue();
    }

    @Override
    public final Object getEmbeddedObject() {
        if (this._currToken == cq.VALUE_EMBEDDED_OBJECT) {
            return this._currentObject();
        }
        return null;
    }

    @Override
    public final byte[] getBinaryValue(bo bo2) throws IOException {
        Object object;
        if (this._currToken == cq.VALUE_EMBEDDED_OBJECT && (object = this._currentObject()) instanceof byte[]) {
            return (byte[])object;
        }
        if (this._currToken != cq.VALUE_STRING) {
            throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING (or VALUE_EMBEDDED_OBJECT with byte[]), cannot access as binary");
        }
        object = this.getText();
        if (object == null) {
            return null;
        }
        hh hh2 = this._byteBuilder;
        if (hh2 == null) {
            this._byteBuilder = hh2 = new hh(100);
        } else {
            this._byteBuilder.reset();
        }
        this._decodeBase64((String)object, hh2, bo2);
        return hh2.toByteArray();
    }

    @Override
    public final int readBinaryValue(bo bo2, OutputStream outputStream) throws IOException {
        byte[] byArray = this.getBinaryValue(bo2);
        if (byArray != null) {
            outputStream.write(byArray, 0, byArray.length);
            return byArray.length;
        }
        return 0;
    }

    @Override
    public final boolean canReadObjectId() {
        return this._hasNativeObjectIds;
    }

    @Override
    public final boolean canReadTypeId() {
        return this._hasNativeTypeIds;
    }

    @Override
    public final Object getTypeId() {
        return this._segment.findTypeId(this._segmentPtr);
    }

    @Override
    public final Object getObjectId() {
        return this._segment.findObjectId(this._segmentPtr);
    }

    protected final Object _currentObject() {
        return this._segment.get(this._segmentPtr);
    }

    protected final void _checkIsNumber() throws bv {
        if (this._currToken == null || !this._currToken.isNumeric()) {
            throw this._constructError("Current token (" + (Object)((Object)this._currToken) + ") not numeric, cannot use numeric value accessors");
        }
    }

    @Override
    protected final void _handleEOF() {
        this._throwInternal();
    }
}

