/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.glue;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import us.hebi.glue.UnsafeAccess;

public final class Jvm {
    private static final int JVM_JAVA_MAJOR_VERSION = Jvm.getMajorVersion0();
    static final boolean IS_JAVA_8_PLUS = JVM_JAVA_MAJOR_VERSION >= 8;
    static final boolean IS_JAVA_9_PLUS = JVM_JAVA_MAJOR_VERSION >= 9;
    static final boolean IS_JAVA_12_PLUS = JVM_JAVA_MAJOR_VERSION >= 12;
    static final boolean IS_JAVA_16_PLUS = JVM_JAVA_MAJOR_VERSION >= 16;
    static final boolean IS_JAVA_17_PLUS = JVM_JAVA_MAJOR_VERSION >= 17;
    static final int CLASS_VERSION_6 = 50;
    static final int CLASS_VERSION_7 = 51;
    static final int CLASS_VERSION_8 = 52;
    static final int CLASS_VERSION_9 = 53;
    static final int CLASS_VERSION_10 = 54;
    static final int CLASS_VERSION_11 = 55;

    public static int majorVersion() {
        return JVM_JAVA_MAJOR_VERSION;
    }

    private static int getMajorVersion0() {
        try {
            Method method = Runtime.class.getDeclaredMethod("version", new Class[0]);
            if (method != null) {
                Object version = method.invoke((Object)Runtime.getRuntime(), new Object[0]);
                Class<?> clz2 = Class.forName("java.lang.Runtime$Version");
                return (Integer)clz2.getDeclaredMethod("major", new Class[0]).invoke(version, new Object[0]);
            }
        }
        catch (NoSuchMethodException e2) {
        }
        catch (IllegalAccessException e3) {
        }
        catch (InvocationTargetException e4) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Integer.parseInt(Runtime.class.getPackage().getSpecificationVersion().split("\\.")[1]);
    }

    public static Field getField(Class clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            Jvm.setAccessible(field);
            return field;
        }
        catch (NoSuchFieldException e2) {
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                try {
                    return Jvm.getField(superclass, name);
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            throw new AssertionError((Object)e2);
        }
    }

    public static Method getMethod(Class clazz, String name, Class ... args) {
        return Jvm.getMethod0(clazz, name, args, true);
    }

    private static Method getMethod0(Class clazz, String name, Class[] args, boolean first) {
        try {
            Method method = clazz.getDeclaredMethod(name, args);
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                Jvm.setAccessible(method);
            }
            return method;
        }
        catch (NoSuchMethodException e2) {
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                try {
                    Method m2 = Jvm.getMethod0(superclass, name, args, false);
                    if (m2 != null) {
                        return m2;
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (first) {
                throw new AssertionError((Object)e2);
            }
            return null;
        }
    }

    private static void setAccessible(AccessibleObject h2) {
        if (!IS_JAVA_9_PLUS || IS_JAVA_12_PLUS) {
            h2.setAccessible(true);
            return;
        }
        try {
            Field f2 = AccessibleObject.class.getDeclaredField("override");
            long offset = UnsafeAccess.UNSAFE.objectFieldOffset(f2);
            UnsafeAccess.UNSAFE.putBoolean(h2, offset, true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private Jvm() {
    }
}

