/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.glue;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import us.hebi.glue.UnsafeAccess;

class DirectBuffer6Fallback {
    private static final long INVALID_OFFSET = -1L;
    private static final long BYTE_BUFFER_ADDRESS_FIELD_OFFSET;

    DirectBuffer6Fallback() {
    }

    static long getAddress(ByteBuffer directBuffer) {
        if (BYTE_BUFFER_ADDRESS_FIELD_OFFSET == -1L) {
            String msg = "DirectBuffer6::getAddress may require JVM option '--add-opens=java.base/java.nio=ALL-UNNAMED'";
            System.err.println(msg);
            throw new AssertionError((Object)msg);
        }
        return UnsafeAccess.UNSAFE.getLong(directBuffer, BYTE_BUFFER_ADDRESS_FIELD_OFFSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        long offset = -1L;
        try {
            Field addressField = Buffer.class.getDeclaredField("address");
            offset = UnsafeAccess.UNSAFE.objectFieldOffset(addressField);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        finally {
            BYTE_BUFFER_ADDRESS_FIELD_OFFSET = offset;
        }
    }
}

