import os
import sys

proto_dir, _ = os.path.split(__file__)

sys.path.insert(0, proto_dir)

from . import Bootloader_pb2
from . import Control_pb2
from . import Core_pb2
from . import DataTypes_pb2
from . import RemoteServices_pb2

from .Bootloader_pb2 import Statuses, Partitions, Read, Write, Erase, PartitionLengthRequest, SetKey, Bootloader
from .Control_pb2 import ActuatorFeedback, ActuatorCommand, PinValue, PinBank, IoData, GPSData, MobileData, Command, Feedback
from .Core_pb2 import Echo, FirmwareInfo, HardwareInfo, EthernetInfo, ModuleState, DatabaseAccess, DebugMessage, ErrorMessage, RootMessage
from .DataTypes_pb2 import Quaternion, Vector3, HighResPosition, Color
from .RemoteServices_pb2 import Calibrate, Safety, RemoteServices

__all__ = ['Statuses', 'Partitions', 'Read', 'Write', 'Erase', 'PartitionLengthRequest',
'SetKey', 'Bootloader', 'ActuatorFeedback', 'ActuatorCommand', 'PinValue', 'PinBank',
'IoData', 'GPSData', 'MobileData', 'Command', 'Feedback', 'Echo', 'FirmwareInfo',
'HardwareInfo', 'EthernetInfo', 'ModuleState', 'DatabaseAccess', 'DebugMessage',
'ErrorMessage', 'RootMessage', 'Quaternion', 'Vector3', 'HighResPosition',
'Color', 'Calibrate', 'Safety', 'RemoteServices']
