#!/usr/bin/env python3

import math
import sys

from hebi_tools.util import create_module_connection, new_root_message

argc = len(sys.argv)

if argc != 7:
  print('Usage: set_poly_spring <dest_ip> <a> <b> <c> <d> <e>')
  print('Example for a linear spring:')
  print('  ./set_poly_spring 10.10.10.225 5 0 0 0 0')
  print('Example for a polynomial spring:')
  print('  ./set_poly_spring 10.10.10.225 1 2 0 3 4')
  exit(1)


ip_addr = sys.argv[1]
connection = create_module_connection(ip_addr)

message_out = new_root_message()
message_in = new_root_message()

poly_consts = [float(sys.argv[i + 2]) for i in range(5)]

for i in range(5):
  message_out.settings.actuator.poly_spring_consts.append(poly_consts[i])

# NOTE: This is required to get the settings back in feedback
message_out.request_settings = True

# Send the message to the module
print('Sending message...')
if not connection.send(message_out):
  print('ERROR: Failed when sending message. Exiting.')
  exit(1)


# Try to receive a message. Wait for 5 seconds
if not connection.recv(message_in):
  print('ERROR: Did not get a response from the module after {0} milliseconds.'.format(connection.timeout_ms))
  exit(1)

recv_consts = message_in.settings.actuator.poly_spring_consts
coeffs_match = True
for i in range(5):    
  if math.isclose(recv_consts[i], poly_consts[i], rel_tol=1e-4) == False:
    coeffs_match = False;

if not coeffs_match:
  print('ERROR: Returned message did not include the appropriate spring constants.')
  print('Expected: {0}'.format(poly_consts))
  print('Received: {0}'.format(recv_consts))
  exit(1)


print('')
print('Command succeeded as expected. Received spring constants from module:')

for i in range(5):
  print('Coeff {0}: {1}'.format(i + 1, recv_consts[i]))
