#!/usr/bin/env python3

import sys
import math
from hebi_tools.util import create_module_connection, new_root_message

argc = len(sys.argv)

if argc != 2 and argc != 6:
  print('Usage: set_imu_params <dest_ip> [accel_scale accel_cutoff gyro_scale gyro_cutoff]')
  print('')
  print('Note - IMU parameters are optional; omitting will retrieve current values.')
  print('When setting, value will round up to the nearest option for each parameter (unless')
  print('above the max, at which point it will round down to the max)')
  print('')
  print('  ./set_imu_params 10.10.10.115')
  print('  ./set_imu_params 10.10.10.115 1 10 1 4')
  exit(1)

ip_addr = sys.argv[1]
connection = create_module_connection(ip_addr)

message_out = new_root_message()
message_in = new_root_message()

if (argc == 6):
  a_scale = int(sys.argv[2])
  a_freq = int(sys.argv[3])
  g_scale = int(sys.argv[4])
  g_freq = int(sys.argv[5])

  message_out.settings.imu.accel_scale = a_scale
  message_out.settings.imu.accel_cutoff_freq = a_freq
  message_out.settings.imu.gyro_scale = g_scale
  message_out.settings.imu.gyro_cutoff_freq = g_freq


# NOTE: This is required to get the settings back in feedback
message_out.request_settings = True

# Send the message to the module
print('Sending message...')
if not connection.send(message_out):
  print('ERROR: Failed when sending message. Exiting.')
  exit(1)


# Try to receive a message. Wait for 5 seconds
if not connection.recv(message_in):
  print('ERROR: Did not get a response from the module after {0} milliseconds.'.format(connection.timeout_ms))
  exit(1)

recv_accel_scale = message_in.settings.imu.accel_scale
recv_accel_cutoff_freq = message_in.settings.imu.accel_cutoff_freq
recv_gyro_scale = message_in.settings.imu.gyro_scale
recv_gyro_cutoff_freq = message_in.settings.imu.gyro_cutoff_freq

print('as: {0} acof: {1} gs: {2} gcof: {3}'.format(recv_accel_scale, recv_accel_cutoff_freq, recv_gyro_scale, recv_gyro_cutoff_freq))
print('Response received')
