#!/usr/bin/env python3

import math
import sys

from hebi_tools.util import create_module_connection, new_root_message

argc = len(sys.argv)

if argc != 3:
  print('Usage: set_effort_gain_scale_factor <dest_ip> <a>')
  print('Example:')
  print('  ./set_effort_gain_scale_factor 10.10.10.225 0.3')
  exit(1)


ip_addr = sys.argv[1]
connection = create_module_connection(ip_addr)

message_out = new_root_message()
message_in = new_root_message()

factor = float(sys.argv[2])

message_out.settings.actuator.effort_gain_scale_factor = factor

# NOTE: This is required to get the settings back in feedback
message_out.request_settings = True

# Send the message to the module
print('Sending message...')
if not connection.send(message_out):
  print('ERROR: Failed when sending message. Exiting.')
  exit(1)


# Try to receive a message. Wait for 5 seconds
if not connection.recv(message_in):
  print('ERROR: Did not get a response from the module after {0} milliseconds.'.format(connection.timeout_ms))
  exit(1)

recv_val = message_in.settings.actuator.effort_gain_scale_factor
if math.isclose(recv_val, factor, rel_tol=1e-4) == False:
  print('ERROR: Returned message did not include the appropriate factor.')
  print('Expected: {0}'.format(factor))
  print('Received: {0}'.format(recv_val))
  exit(1)


print('')
print('Command succeeded as expected. Received factor from module:')

print('Factor {0}:'.format(recv_val))
