#!/usr/bin/env python3

import sys
from hebi_tools.util import create_module_connection, new_root_message

argc = len(sys.argv)

if argc != 3:
  print('Usage: offset_position <dest_ip> <offset_amount>')
  print('  ./offset_position 10.10.10.225 .00143')
  exit(1)


val = float(sys.argv[2])
ip_addr = sys.argv[1]
connection = create_module_connection(ip_addr)

message_out = new_root_message()
message_in = new_root_message()

message_out.remote_services.calibrate.offset_encoders = True
message_out.remote_services.calibrate.offset_encoders_value = val

# NOTE: This is required to get the settings back in feedback
message_out.request_settings = True

# Send the message to the module
print('Sending message...')
if not connection.send(message_out):
  print('ERROR: Failed when sending message. Exiting.')
  exit(1)


# Try to receive a message. Wait for 5 seconds
if not connection.recv(message_in):
  print('ERROR: Did not get a response from the module after {0} milliseconds.'.format(connection.timeout_ms))
  exit(1)
