#!/usr/bin/env python3

import sys
import math
from hebi_tools.util import create_module_connection, new_root_message

argc = len(sys.argv)

if argc != 5:
  print('Usage: mobile_io_sliders <dest_ip> <slider num> <0 (config)/1 (set)> <value>')
  print('Example (config slider 3 to not snap)')
  print('  ./mobile_io_sliders 10.10.10.125 3 0 nan')
  exit(1)

message_out = new_root_message()
message_in = new_root_message()

slider = int(sys.argv[2])
set_type = int(sys.argv[3])
set_val = float(sys.argv[4])

if set_type == 1:
  io = message_out.command.io_command.a
elif set_type == 0:
  io = message_out.command.io_command.f
else:
  print('ERROR: invalid config value')
  exit(1)

if not slider > 0 and slider < 9:
  print('ERROR: invalid pin')
  exit(1)

pin = getattr(io, 'pin{0}'.format(slider))
pin.float_value = set_val

ip_addr = sys.argv[1]
connection = create_module_connection(ip_addr)

# NOTE: This is required to get returned message
message_out.request_settings = True

# Send the message to the module
print('Sending message...')
if not connection.send(message_out):
  print('ERROR: Failed when sending message. Exiting.')
  exit(1)

# Try to receive a message. Wait for 5 seconds
if not connection.recv(message_in):
  print('ERROR: Did not get a response from the module after {0} milliseconds.'.format(connection.timeout_ms))
  exit(1)

print('')
print('Command succeeded as expected.')
