#!/usr/bin/env python3

import sys
import math
from hebi_tools.util import create_module_connection, new_root_message
import hebi_tools.hebi_conn
import hebi_tools.hebi_proto

argc = len(sys.argv)

if argc != 2:
  print('Usage: mobile_io_buttons <dest_ip> ')
  print('Example')
  print('  ./mobile_io_buttons 10.10.10.125')
  exit(1)

message_out = new_root_message()
message_in = new_root_message()

message_out.debug.debug1 = 128
message_out.debug.bytes_payloads.extend([(3).to_bytes(1, 'big')])

ip_addr = sys.argv[1]
connection = create_module_connection(ip_addr)

# NOTE: This is required to get a returned message
message_out.request_settings = True

# Send the message to the module
print('Sending message...')
if not connection.send(message_out):
  print('ERROR: Failed when sending message. Exiting.')
  exit(1)

# Try to receive a message. Wait for 5 seconds
if not connection.recv(message_in):
  print('ERROR: Did not get a response from the module after {0} milliseconds.'.format(connection.timeout_ms))
  exit(1)

print('')
print('Command succeeded as expected.')
