#!/usr/bin/env python3

from hebi_tools import hebi_proto
import hebi_tools
from hebi_tools.hebi_proto.RemoteServices_pb2 import CalibrationActions, CalibrationTargets, CalibrationTypes
from hebi_tools.hebi_proto.Core_pb2 import RootMessage
import sys
from hebi_tools.util import create_module_connection, new_root_message

argc = len(sys.argv)

def print_usage_and_quit():
  print('Usage: python calibrate_encoder.py <dest_ip> <table type> <table index> <action> [<sector>] [values 1 through 8...]')
  print('  python calibrate_encoder.py 10.10.10.225 nonius outer clear')
  print('  python calibrate_encoder.py 10.10.10.225 nonlinear outer persist')
  print('  python calibrate_encoder.py 10.10.10.225 nonius outer read 2')
  print('  python calibrate_encoder.py 10.10.10.225 nonlinear inner write 4 0.1 -0.2 0.3 0.4 1.1 -1.2 0.2 -0.5')
  exit(1)


if argc < 5:
  print_usage_and_quit()

message_out = new_root_message()
message_in = new_root_message()

ip_addr = sys.argv[1]

# Get table type
table_type = sys.argv[2]
if table_type == 'nonius':
  message_out.remote_services.calibrate.calibration_type = CalibrationTypes.NONIUS
elif table_type == 'nonlinear':
  message_out.remote_services.calibrate.calibration_type = CalibrationTypes.NONLINEAR
elif table_type == 'hall_offset':
  message_out.remote_services.calibrate.calibration_type = CalibrationTypes.HALL_OFFSET
elif table_type == 'spwl':
  message_out.remote_services.calibrate.calibration_type = CalibrationTypes.SPWL
else:  
  print_usage_and_quit()

# Get table target
table_target = sys.argv[3]
if table_target == 'inner':
  message_out.remote_services.calibrate.calibration_target = CalibrationTargets.INNER
elif table_target == 'outer':
  message_out.remote_services.calibrate.calibration_target = CalibrationTargets.OUTER
elif table_target == 'deflection':
  message_out.remote_services.calibrate.calibration_target = CalibrationTargets.DEFLECTION
elif table_target == 'halls':
  message_out.remote_services.calibrate.calibration_target = CalibrationTargets.HALLS
elif table_target == 'md_enc_a1':
  message_out.remote_services.calibrate.calibration_target = CalibrationTargets.MD_ENC_A1
elif table_target == 'md_enc_a2':
  message_out.remote_services.calibrate.calibration_target = CalibrationTargets.MD_ENC_A2
elif table_target == 'md_enc_b1':
  message_out.remote_services.calibrate.calibration_target = CalibrationTargets.MD_ENC_B1
elif table_target == 'md_enc_b2':
  message_out.remote_services.calibrate.calibration_target = CalibrationTargets.MD_ENC_B2
else:  
  print_usage_and_quit()

# Get action
action = sys.argv[4]
if action != 'clear' and action != 'persist' and action != 'read' and action != 'write':
  print_usage_and_quit()

if action == 'clear' and argc == 5:
  message_out.remote_services.calibrate.calibration_action = CalibrationActions.CLEAR
elif action == 'persist' and argc == 5:
  message_out.remote_services.calibrate.calibration_action = CalibrationActions.PERSIST_TABLE
elif action == 'read' and argc == 6:
  message_out.remote_services.calibrate.calibration_action = CalibrationActions.READ_SECTOR
  message_out.remote_services.calibrate.calibration_sector = int(sys.argv[5])
elif action == 'write' and argc == (6 + 8):
  message_out.remote_services.calibrate.calibration_action = CalibrationActions.WRITE_SECTOR
  message_out.remote_services.calibrate.calibration_sector = int(sys.argv[5])
  # Set values:
  message_out.remote_services.calibrate.calibration_data_1 = float(sys.argv[6])
  message_out.remote_services.calibrate.calibration_data_2 = float(sys.argv[7])
  message_out.remote_services.calibrate.calibration_data_3 = float(sys.argv[8])
  message_out.remote_services.calibrate.calibration_data_4 = float(sys.argv[9])
  message_out.remote_services.calibrate.calibration_data_5 = float(sys.argv[10])
  message_out.remote_services.calibrate.calibration_data_6 = float(sys.argv[11])
  message_out.remote_services.calibrate.calibration_data_7 = float(sys.argv[12])
  message_out.remote_services.calibrate.calibration_data_8 = float(sys.argv[13])
else:  
  print_usage_and_quit()

connection = create_module_connection(ip_addr)

# NOTE: This is required to get the settings back in feedback
message_out.request_settings = True

# Send the message to the module
print('Sending message...')
if not connection.send(message_out):
  print('ERROR: Failed when sending message. Exiting.')
  exit(1)

# Try to receive a message. Wait for 5 seconds
if not connection.recv(message_in):
  print('ERROR: Did not get a response from the module after {0} milliseconds.'.format(connection.timeout_ms))
  exit(1)

# Check the return value:
if not message_in.remote_services.calibrate.HasField('calibration_action') or not message_in.remote_services.calibrate.HasField('calibration_type'):
  print('ERROR: Received error response from module.')
  exit(1)
if action == 'write' or action == 'read':
  if not message_in.remote_services.calibrate.HasField('calibration_sector') or \
     not message_in.remote_services.calibrate.HasField('calibration_data_1') or \
     not message_in.remote_services.calibrate.HasField('calibration_data_2') or \
     not message_in.remote_services.calibrate.HasField('calibration_data_3') or \
     not message_in.remote_services.calibrate.HasField('calibration_data_4') or \
     not message_in.remote_services.calibrate.HasField('calibration_data_5') or \
     not message_in.remote_services.calibrate.HasField('calibration_data_6') or \
     not message_in.remote_services.calibrate.HasField('calibration_data_7') or \
     not message_in.remote_services.calibrate.HasField('calibration_data_8'):
    print('ERROR: Received bad response from module.')
    exit(1)

print ('Success')

if action == 'write' or action == 'read':
  print('Received data from read/write operation:')
  print('{0} {1} {2} {3} {4} {5} {6} {7}'.format(message_in.remote_services.calibrate.calibration_data_1,
    message_in.remote_services.calibrate.calibration_data_2,
    message_in.remote_services.calibrate.calibration_data_3,
    message_in.remote_services.calibrate.calibration_data_4,
    message_in.remote_services.calibrate.calibration_data_5,
    message_in.remote_services.calibrate.calibration_data_6,
    message_in.remote_services.calibrate.calibration_data_7,
    message_in.remote_services.calibrate.calibration_data_8))
