#!/usr/bin/env python3

import sys
import math
from hebi_tools.util import create_module_connection, new_root_message

argc = len(sys.argv)

if argc != 3:
  print('Usage: set_accel_style <dest_ip> <include grav ? 1 : 0>')
  print('Example for including grav in acceleration feedback:')
  print('  ./set_accel_style 10.10.10.125 1')
  exit(1)


ip_addr = sys.argv[1]
connection = create_module_connection(ip_addr)

message_out = new_root_message()
message_in = new_root_message()

message_out.settings.imu.accel_includes_gravity = int(sys.argv[2])

# NOTE: This is required to get the settings back in feedback
message_out.request_settings = True

# Send the message to the module
print('Sending message...')
if not connection.send(message_out):
  print('ERROR: Failed when sending message. Exiting.')
  exit(1)


# Try to receive a message. Wait for 5 seconds
if not connection.recv(message_in):
  print('ERROR: Did not get a response from the module after {0} milliseconds.'.format(connection.timeout_ms))
  exit(1)

recv_val = message_in.settings.imu.accel_includes_gravity

if recv_val != int(sys.argv[2]):
  print('ERROR: Returned message did not include correct accelerometer setting.')
  print('Expected: {0}'.format(recv_val))
  print('Received: {0}'.format(int(sts.argv[2])))
  exit(1)

print('')
print('Command succeeded as expected. Received matching accel setting from module.')
