#!/usr/bin/env python3

import math
import sys

from hebi_tools.util import create_module_connection, new_root_message

argc = len(sys.argv)

valid_args = False
factory_reset = False
if argc == 2:
  valid_args = True
elif argc == 3:
  if sys.argv[2] == '-f':
    valid_args = True
    factory_reset = True

if not valid_args:
  print('Usage:')
  print('reset trip odometer:')
  print('  reset_runtime_data <dest_ip>')
  print('full factory reset:')
  print('  reset_runtime_data <dest_ip> -f')
  exit(1)

ip_addr = sys.argv[1]
connection = create_module_connection(ip_addr)

message_out = new_root_message()
message_in = new_root_message()

# NOTE: This is required to get the settings back in feedback
message_out.request_settings = True
message_out.request_runtime_data = True
if factory_reset:
  message_out.settings.factory_reset_runtime_data = True
else:
  message_out.settings.restart_runtime_data = True

# Send the message to the module
print('Sending message...')
if not connection.send(message_out):
  print('ERROR: Failed when sending message. Exiting.')
  exit(1)

# Try to receive a message. Wait for 5 seconds
if not connection.recv(message_in):
  print('ERROR: Did not get a response from the module after {0} milliseconds.'.format(connection.timeout_ms))
  exit(1)

if factory_reset and not message_in.settings.factory_reset_runtime_data:
  print('ERROR: Returned message did not indicate successful factory reset.')
  exit(1)
if not factory_reset and not message_in.settings.restart_runtime_data:
  print('ERROR: Returned message did not indicate successful trip odometer restart.')
  exit(1)

print('')
print('Command succeeded as expected.')
